/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.session;

import com.boydti.fawe.object.collection.SoftHashMap;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.ConfigurationLoadEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.session.storage.JsonFileSessionStore;
import com.sk89q.worldedit.session.storage.SessionStore;
import com.sk89q.worldedit.session.storage.VoidStore;
import com.sk89q.worldedit.util.concurrency.EvenMoreExecutors;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SessionManager {
    @Deprecated
    public static int EXPIRATION_GRACE = 600000;
    private static final ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)EvenMoreExecutors.newBoundedCachedThreadPool(0, 1, 5));
    private static final Logger log = Logger.getLogger(SessionManager.class.getCanonicalName());
    private final Timer timer = new Timer();
    private final WorldEdit worldEdit;
    private final Map<UUID, SessionHolder> sessions = new ConcurrentHashMap<UUID, SessionHolder>(8, 0.9f, 1);
    private final Map<UUID, Reference<SessionHolder>> softSessions = new SoftHashMap<UUID, Reference<SessionHolder>>();
    private SessionStore store = new VoidStore();
    private File path;

    public SessionManager(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
        worldEdit.getEventBus().register(this);
    }

    public synchronized boolean contains(SessionOwner owner) {
        Preconditions.checkNotNull((Object)owner);
        return this.sessions.containsKey(this.getKey(owner)) || this.softSessions.containsKey(owner);
    }

    @Nullable
    public synchronized LocalSession findByName(String name) {
        Preconditions.checkNotNull((Object)name);
        for (SessionHolder holder : this.sessions.values()) {
            String test = holder.key.getName();
            if (!name.equals(test)) continue;
            return holder.session;
        }
        Iterator<Map.Entry<UUID, Reference<SessionHolder>>> iter = this.softSessions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UUID, Reference<SessionHolder>> entry = iter.next();
            UUID key = entry.getKey();
            SessionHolder holder = entry.getValue().get();
            if (holder == null) {
                iter.remove();
                continue;
            }
            String test = holder.key.getName();
            if (test == null || !name.equals(test)) continue;
            iter.remove();
            this.sessions.put(key, holder);
            return holder.session;
        }
        return null;
    }

    @Nullable
    public synchronized LocalSession getIfPresent(SessionOwner owner) {
        Preconditions.checkNotNull((Object)owner);
        UUID key = this.getKey(owner);
        SessionHolder stored = this.sessions.get(key);
        if (stored != null) {
            return stored.session;
        }
        Reference<SessionHolder> reference = this.softSessions.get(key);
        if (reference != null && (stored = reference.get()) != null) {
            this.softSessions.remove(key);
            this.sessions.put(key, stored);
            return stored.session;
        }
        return null;
    }

    public synchronized LocalSession get(SessionOwner owner) {
        Preconditions.checkNotNull((Object)owner);
        LocalSession session = this.getIfPresent(owner);
        LocalConfiguration config = this.worldEdit.getConfiguration();
        SessionKey sessionKey = owner.getSessionKey();
        if (session == null) {
            try {
                session = this.store.load(this.getKey(sessionKey));
                session.postLoad();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Failed to load saved session", e);
                session = new LocalSession();
            }
            session.setConfiguration(config);
            session.setBlockChangeLimit(config.defaultChangeLimit);
            this.sessions.put(this.getKey(owner), new SessionHolder(sessionKey, session));
        }
        int currentChangeLimit = session.getBlockChangeLimit();
        if (!owner.hasPermission("worldedit.limit.unrestricted") && config.maxChangeLimit > -1) {
            if (config.defaultChangeLimit < 0) {
                if (currentChangeLimit < 0 || currentChangeLimit > config.maxChangeLimit) {
                    session.setBlockChangeLimit(config.maxChangeLimit);
                }
            } else {
                int maxChangeLimit = config.maxChangeLimit;
                if (currentChangeLimit == -1 || currentChangeLimit > maxChangeLimit) {
                    session.setBlockChangeLimit(maxChangeLimit);
                }
            }
        }
        session.setUseInventory(config.useInventory && (!config.useInventoryOverride || !owner.hasPermission("worldedit.inventory.unrestricted") && (!config.useInventoryCreativeOverride || owner instanceof Player && ((Player)owner).getGameMode() != GameModes.CREATIVE)));
        return session;
    }

    private void save(SessionHolder holder) {
        SessionKey key = holder.key;
        holder.session.setClipboard(null);
        if (key.isPersistent()) {
            try {
                if (holder.session.compareAndResetDirty()) {
                    File file;
                    if (holder.session.save()) {
                        this.store.save(this.getKey(key), holder.session);
                    } else if (this.path != null && (file = new File(this.path, this.getKey(key) + ".json")).exists() && !file.delete()) {
                        file.deleteOnExit();
                    }
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to write session for UUID " + this.getKey(key), e);
            }
        }
    }

    protected UUID getKey(SessionOwner owner) {
        return this.getKey(owner.getSessionKey());
    }

    protected UUID getKey(SessionKey key) {
        String forcedKey = System.getProperty("worldedit.session.uuidOverride");
        if (forcedKey != null) {
            return UUID.fromString(forcedKey);
        }
        return key.getUniqueId();
    }

    public synchronized void remove(SessionOwner owner) {
        Preconditions.checkNotNull((Object)owner);
        SessionHolder session = this.sessions.remove(this.getKey(owner));
        if (session != null) {
            this.save(session);
        }
    }

    public synchronized void forget(SessionOwner owner) {
        Preconditions.checkNotNull((Object)owner);
        UUID key = this.getKey(owner);
        SessionHolder holder = this.sessions.remove(key);
        if (holder != null) {
            this.softSessions.put(key, new SoftReference<SessionHolder>(holder));
            this.save(holder);
        }
    }

    public synchronized void clear() {
        for (Map.Entry<UUID, SessionHolder> entry : this.sessions.entrySet()) {
            this.save(entry.getValue());
        }
        this.sessions.clear();
    }

    @Subscribe
    public void onConfigurationLoad(ConfigurationLoadEvent event) {
        LocalConfiguration config = event.getConfiguration();
        File dir = new File(config.getWorkingDirectory(), "sessions");
        this.store = new JsonFileSessionStore(dir);
        this.path = dir;
    }

    private static class SessionHolder {
        private final SessionKey key;
        private final LocalSession session;
        private long lastActive = System.currentTimeMillis();

        private SessionHolder(SessionKey key, LocalSession session) {
            this.key = key;
            this.session = session;
        }
    }
}

