/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.command.parametric;

import com.boydti.fawe.command.SuggestInputParseException;
import com.boydti.fawe.config.BBC;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.minecraft.util.commands.SuggestionContext;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.MissingParameterException;
import com.sk89q.worldedit.util.command.Parameter;
import com.sk89q.worldedit.util.command.SimpleDescription;
import com.sk89q.worldedit.util.command.SimpleParameter;
import com.sk89q.worldedit.util.command.UnconsumedParameterException;
import com.sk89q.worldedit.util.command.parametric.ArgumentStack;
import com.sk89q.worldedit.util.command.parametric.BindingBehavior;
import com.sk89q.worldedit.util.command.parametric.ContextArgumentStack;
import com.sk89q.worldedit.util.command.parametric.ParameterData;
import com.sk89q.worldedit.util.command.parametric.ParameterException;
import com.sk89q.worldedit.util.command.parametric.ParametricBuilder;
import com.sk89q.worldedit.util.command.parametric.ParametricException;
import com.sk89q.worldedit.util.command.parametric.StringArgumentStack;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AParametricCallable
implements CommandCallable {
    public abstract ParameterData[] getParameters();

    public abstract Set<Character> getValueFlags();

    public abstract Set<Character> getLegacyFlags();

    @Override
    public abstract SimpleDescription getDescription();

    public abstract String[] getPermissions();

    public abstract ParametricBuilder getBuilder();

    public abstract boolean anyFlags();

    public abstract Command getCommand();

    public Command getDefinition() {
        return this.getCommand();
    }

    public abstract String getGroup();

    public abstract String toString();

    public static ArgumentStack getScopedContext(Parameter parameter, ArgumentStack existing) {
        if (parameter.getFlag() != null) {
            CommandContext context = existing.getContext();
            if (parameter.isValueFlag()) {
                return new StringArgumentStack(context, context.getFlag(parameter.getFlag().charValue()), false);
            }
            String v = context.hasFlag(parameter.getFlag().charValue()) ? "true" : "false";
            return new StringArgumentStack(context, v, true);
        }
        return existing;
    }

    public boolean mayConsumeArguments(int i, ContextArgumentStack scoped) {
        CommandContext context = scoped.getContext();
        ParameterData parameter = this.getParameters()[i];
        if (parameter.isOptional()) {
            if (parameter.getFlag() != null) {
                return !parameter.isValueFlag() || context.hasFlag(parameter.getFlag().charValue());
            }
            int numberFree = context.argsLength() - scoped.position();
            for (int j = i; j < this.getParameters().length; ++j) {
                if (!this.getParameters()[j].isNonFlagConsumer() || this.getParameters()[j].isOptional()) continue;
                numberFree -= this.getParameters()[j].getConsumedCount();
            }
            if (numberFree < 1) {
                return false;
            }
        }
        return true;
    }

    public Object getDefaultValue(int i, ContextArgumentStack scoped) throws ParameterException, CommandException, InvocationTargetException {
        CommandContext context = scoped.getContext();
        ParameterData parameter = this.getParameters()[i];
        String[] defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            try {
                return parameter.getBinding().bind(parameter, new StringArgumentStack(context, defaultValue, false), false);
            }
            catch (MissingParameterException e) {
                throw new ParametricException("The default value of the parameter using the binding " + parameter.getBinding().getClass() + " in the method\n" + this.toString() + "\nis invalid");
            }
        }
        return null;
    }

    public void checkUnconsumed(ContextArgumentStack scoped) throws UnconsumedParameterException {
        CommandContext context = scoped.getContext();
        String unconsumedFlags = this.getUnusedFlags(context);
        String unconsumed = scoped.getUnconsumed();
        if (unconsumed != null) {
            throw new UnconsumedParameterException(unconsumed + " " + unconsumedFlags);
        }
        if (unconsumedFlags != null) {
            throw new UnconsumedParameterException(unconsumedFlags);
        }
    }

    public String getUnusedFlags(CommandContext context) {
        if (!this.anyFlags()) {
            HashSet<Character> unusedFlags = null;
            for (char flag : context.getFlags()) {
                boolean found = false;
                if (this.getLegacyFlags().contains(Character.valueOf(flag))) break;
                for (ParameterData parameter : this.getParameters()) {
                    Character paramFlag = parameter.getFlag();
                    if (paramFlag == null || flag != paramFlag.charValue()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (unusedFlags == null) {
                    unusedFlags = new HashSet<Character>();
                }
                unusedFlags.add(Character.valueOf(flag));
            }
            if (unusedFlags != null) {
                StringBuilder builder = new StringBuilder();
                for (Character flag : unusedFlags) {
                    builder.append("-").append(flag).append(" ");
                }
                return builder.toString().trim();
            }
        }
        return null;
    }

    @Override
    public boolean testPermission(CommandLocals locals) {
        String[] perms = this.getPermissions();
        if (perms != null && perms.length != 0) {
            for (String perm : perms) {
                if (!this.getBuilder().getAuthorizer().testPermission(locals, perm)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<String> getSuggestions(String arguments, CommandLocals locals) throws CommandException {
        String[] split = ("ignored " + arguments).split(" ", -1);
        CommandContext context = new CommandContext(split, this.getValueFlags(), !arguments.endsWith(" "), locals);
        ContextArgumentStack scoped = new ContextArgumentStack(context);
        SuggestionContext suggestable = context.getSuggestionContext();
        ArrayList<String> suggestions = new ArrayList<String>(2);
        SimpleParameter parameter = null;
        ParameterData[] parameters = this.getParameters();
        String consumed = "";
        boolean hasSuggestion = false;
        int minConsumedI = 0;
        try {
            int maxConsumedI;
            for (maxConsumedI = 0; maxConsumedI < parameters.length; ++maxConsumedI) {
                parameter = parameters[maxConsumedI];
                if (((ParameterData)parameter).getBinding().getBehavior((ParameterData)parameter) == BindingBehavior.PROVIDES) continue;
                ArgumentStack usedArguments = AParametricCallable.getScopedContext(parameter, scoped);
                usedArguments.mark();
                try {
                    ((ParameterData)parameter).getBinding().bind((ParameterData)parameter, usedArguments, false);
                    minConsumedI = maxConsumedI + 1;
                    continue;
                }
                catch (Throwable e) {
                    while (e.getCause() != null && !(e instanceof ParameterException) && !(e instanceof InvocationTargetException)) {
                        e = e.getCause();
                    }
                    consumed = usedArguments.reset();
                    if (parameter.isOptional()) continue;
                    if (!(e instanceof MissingParameterException)) {
                        minConsumedI = maxConsumedI;
                    }
                    throw e;
                }
            }
            if (minConsumedI >= maxConsumedI && (parameter == null || ((ParameterData)parameter).getType() == CommandContext.class)) {
                this.checkUnconsumed(scoped);
            }
        }
        catch (MissingParameterException usedArguments) {
        }
        catch (UnconsumedParameterException e) {
            suggestions.add(BBC.color("&cToo many parameters! Unused parameters: " + e.getUnconsumed()));
        }
        catch (ParameterException e) {
            String name = parameter.getName();
            suggestions.add(BBC.color("&cFor parameter '" + name + "': " + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            SuggestInputParseException suggestion = SuggestInputParseException.get(e);
            if (suggestion != null && !suggestion.getSuggestions().isEmpty()) {
                hasSuggestion = true;
                suggestions.addAll(suggestion.getSuggestions());
            } else {
                Throwable t = e;
                while (((Throwable)t).getCause() != null) {
                    t = ((Throwable)t).getCause();
                }
                String msg = t.getMessage();
                String name = parameter.getName();
                if (msg != null && !msg.isEmpty()) {
                    suggestions.add(BBC.color("&cFor parameter '" + name + "': " + msg));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new WrappedCommandException(t);
        }
        if (!hasSuggestion && suggestions.size() <= 1) {
            StringBuilder suggestion = new StringBuilder();
            String prefix = "";
            block15: while (minConsumedI < parameters.length) {
                parameter = parameters[minConsumedI];
                if (((ParameterData)parameter).getBinding().getBehavior((ParameterData)parameter) != BindingBehavior.PROVIDES) {
                    suggestion.append(prefix);
                    List<String> argSuggestions = ((ParameterData)parameter).getBinding().getSuggestions((ParameterData)parameter, consumed);
                    switch (argSuggestions.size()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            suggestion.append(argSuggestions.iterator().next());
                            break;
                        }
                        default: {
                            suggestion.setLength(0);
                            suggestions.addAll(argSuggestions);
                            break block15;
                        }
                    }
                    consumed = "";
                    prefix = " ";
                }
                ++minConsumedI;
            }
            if (suggestion.length() != 0) {
                suggestions.add(suggestion.toString());
            }
        }
        return suggestions;
    }
}

