/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.FawePattern;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Map;
import java.util.stream.Collectors;

public interface BlockStateHolder<T extends BlockStateHolder>
extends FawePattern,
TileEntityBlock {
    public BlockTypes getBlockType();

    @Deprecated
    default public BlockStateHolder withPropertyId(int propertyId) {
        return this.getBlockType().withPropertyId(propertyId);
    }

    @Deprecated
    public int getInternalId();

    @Deprecated
    public int getOrdinal();

    default public BlockMaterial getMaterial() {
        return this.getBlockType().getMaterial();
    }

    @Deprecated
    default public int getInternalBlockTypeId() {
        return this.getBlockType().getInternalId();
    }

    @Deprecated
    public int getInternalPropertiesId();

    public Mask toMask(Extent var1);

    public <V> T with(Property<V> var1, V var2);

    public <V> BlockStateHolder with(PropertyKey var1, V var2);

    public <V> V getState(Property<V> var1);

    public <V> V getState(PropertyKey var1);

    public Map<Property<?>, Object> getStates();

    @Deprecated
    public boolean equalsFuzzy(BlockStateHolder var1);

    public BlockState toImmutableState();

    default public String getAsString() {
        if (this.getStates().isEmpty()) {
            return this.getBlockType().getId();
        }
        String properties = this.getStates().entrySet().stream().map(entry -> ((Property)entry.getKey()).getName() + "=" + entry.getValue().toString().toLowerCase()).collect(Collectors.joining(","));
        return this.getBlockType().getId() + "[" + properties + "]";
    }
}

