/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.registry;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.util.gson.VectorAdapter;
import com.sk89q.worldedit.world.registry.SimpleBlockMaterial;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class BundledBlockData {
    private static final Logger log = Logger.getLogger(BundledBlockData.class.getCanonicalName());
    private static BundledBlockData INSTANCE;
    private final Map<String, BlockEntry> idMap = new HashMap<String, BlockEntry>();

    private BundledBlockData() {
        try {
            this.loadFromResource();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Failed to load the built-in block registry", e);
        }
    }

    private void loadFromResource() throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Vector.class, (Object)new VectorAdapter());
        gsonBuilder.registerTypeAdapter(Integer.TYPE, (Object)new JsonDeserializer<Integer>(){

            public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonPrimitive primitive = (JsonPrimitive)json;
                if (primitive.isString()) {
                    String value = primitive.getAsString();
                    if (value.charAt(0) == '#') {
                        return Integer.parseInt(value.substring(1), 16);
                    }
                    return Integer.parseInt(value);
                }
                return primitive.getAsInt();
            }
        });
        Gson gson = gsonBuilder.create();
        URL url = BundledBlockData.class.getResource("blocks.json");
        if (url == null) {
            throw new IOException("Could not find blocks.json");
        }
        String data = Resources.toString((URL)url, (Charset)Charset.defaultCharset());
        List entries = (List)gson.fromJson(data, new TypeToken<List<BlockEntry>>(){}.getType());
        for (BlockEntry entry : entries) {
            this.idMap.put(entry.id, entry);
        }
    }

    @Nullable
    public BlockEntry findById(String id) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return this.idMap.get(id);
    }

    @Nullable
    public BlockMaterial getMaterialById(String id) {
        BlockEntry entry = this.findById(id);
        if (entry != null) {
            return entry.material;
        }
        return null;
    }

    public static BundledBlockData getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BundledBlockData();
        }
        return INSTANCE;
    }

    public static class BlockEntry {
        public String id;
        public String localizedName;
        public SimpleBlockMaterial material = new SimpleBlockMaterial();
    }
}

