/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrency;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class IntegerSet {
    private final boolean[] array;

    public IntegerSet(int maximumCount) {
        this.array = new boolean[maximumCount];
    }

    public IntegerSet(int maximumCount, Collection<Integer> values) {
        this.array = new boolean[maximumCount];
        this.addAll(values);
    }

    public boolean contains(int element) {
        return this.array[element];
    }

    public void add(int element) {
        this.array[element] = true;
    }

    public void addAll(Collection<Integer> packets) {
        for (Integer id : packets) {
            this.add(id);
        }
    }

    public void remove(int element) {
        if (element >= 0 && element < this.array.length) {
            this.array[element] = false;
        }
    }

    public void clear() {
        Arrays.fill(this.array, false);
    }

    public Set<Integer> toSet() {
        HashSet<Integer> elements = new HashSet<Integer>();
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i]) continue;
            elements.add(i);
        }
        return elements;
    }
}

