/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.async.AsyncMarker;
import com.comphenix.protocol.error.PluginContext;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.ScheduledPacket;
import com.comphenix.protocol.events.SerializedOfflinePlayer;
import com.comphenix.protocol.injector.server.TemporaryPlayer;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;

public class PacketEvent
extends EventObject
implements Cancellable {
    public static final ReportType REPORT_CHANGING_PACKET_TYPE_IS_CONFUSING = new ReportType("Plugin %s changed packet type from %s to %s in packet listener. This is confusing for other plugins! (Not an error, though!)");
    private static final SetMultimap<PacketType, PacketType> CHANGE_WARNINGS = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private static final long serialVersionUID = -5360289379097430620L;
    private transient WeakReference<Player> playerReference;
    private PacketContainer packet;
    private boolean serverPacket;
    private boolean cancel;
    private AsyncMarker asyncMarker;
    private boolean asynchronous;
    NetworkMarker networkMarker;
    private boolean readOnly;
    private boolean filtered;

    public PacketEvent(Object source) {
        super(source);
        this.filtered = true;
    }

    private PacketEvent(Object source, PacketContainer packet, Player player, boolean serverPacket) {
        this(source, packet, null, player, serverPacket, true);
    }

    private PacketEvent(Object source, PacketContainer packet, NetworkMarker marker, Player player, boolean serverPacket, boolean filtered) {
        super(source);
        this.packet = packet;
        this.playerReference = new WeakReference<Player>(player);
        this.networkMarker = marker;
        this.serverPacket = serverPacket;
        this.filtered = filtered;
    }

    private PacketEvent(PacketEvent origial, AsyncMarker asyncMarker) {
        super(origial.source);
        this.packet = origial.packet;
        this.playerReference = origial.getPlayerReference();
        this.cancel = origial.cancel;
        this.serverPacket = origial.serverPacket;
        this.filtered = origial.filtered;
        this.networkMarker = origial.networkMarker;
        this.asyncMarker = asyncMarker;
        this.asynchronous = true;
    }

    public static PacketEvent fromClient(Object source, PacketContainer packet, Player client) {
        return new PacketEvent(source, packet, client, false);
    }

    public static PacketEvent fromClient(Object source, PacketContainer packet, NetworkMarker marker, Player client) {
        return new PacketEvent(source, packet, marker, client, false, true);
    }

    public static PacketEvent fromClient(Object source, PacketContainer packet, NetworkMarker marker, Player client, boolean filtered) {
        return new PacketEvent(source, packet, marker, client, false, filtered);
    }

    public static PacketEvent fromServer(Object source, PacketContainer packet, Player recipient) {
        return new PacketEvent(source, packet, recipient, true);
    }

    public static PacketEvent fromServer(Object source, PacketContainer packet, NetworkMarker marker, Player recipient) {
        return new PacketEvent(source, packet, marker, recipient, true, true);
    }

    public static PacketEvent fromServer(Object source, PacketContainer packet, NetworkMarker marker, Player recipient, boolean filtered) {
        return new PacketEvent(source, packet, marker, recipient, true, filtered);
    }

    public static PacketEvent fromSynchronous(PacketEvent event, AsyncMarker marker) {
        return new PacketEvent(event, marker);
    }

    public boolean isAsync() {
        return !Bukkit.isPrimaryThread();
    }

    public PacketContainer getPacket() {
        return this.packet;
    }

    public void setPacket(PacketContainer packet) {
        if (this.readOnly) {
            throw new IllegalStateException("The packet event is read-only.");
        }
        if (packet == null) {
            throw new IllegalArgumentException("Cannot set packet to NULL. Use setCancelled() instead.");
        }
        PacketType oldType = this.packet.getType();
        PacketType newType = packet.getType();
        if (this.packet != null && !Objects.equal((Object)oldType, (Object)newType) && CHANGE_WARNINGS.put((Object)oldType, (Object)newType)) {
            ProtocolLibrary.getErrorReporter().reportWarning((Object)this, Report.newBuilder(REPORT_CHANGING_PACKET_TYPE_IS_CONFUSING).messageParam(PluginContext.getPluginCaller(new Exception()), oldType, newType).build());
        }
        this.packet = packet;
    }

    @Deprecated
    public int getPacketID() {
        return this.packet.getID();
    }

    public PacketType getPacketType() {
        return this.packet.getType();
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public NetworkMarker getNetworkMarker() {
        if (this.networkMarker == null) {
            if (this.isServerPacket()) {
                this.networkMarker = new NetworkMarker.EmptyBufferMarker(this.serverPacket ? ConnectionSide.SERVER_SIDE : ConnectionSide.CLIENT_SIDE);
            } else {
                throw new IllegalStateException("Add the option ListenerOptions.INTERCEPT_INPUT_BUFFER to your listener.");
            }
        }
        return this.networkMarker;
    }

    public void setNetworkMarker(NetworkMarker networkMarker) {
        this.networkMarker = (NetworkMarker)Preconditions.checkNotNull((Object)networkMarker, (Object)"marker cannot be NULL");
    }

    public void setCancelled(boolean cancel) {
        if (this.readOnly) {
            throw new IllegalStateException("The packet event is read-only.");
        }
        this.cancel = cancel;
    }

    private WeakReference<Player> getPlayerReference() {
        Player updated;
        Player player = (Player)this.playerReference.get();
        if (player instanceof TemporaryPlayer && (updated = player.getPlayer()) != null && !(updated instanceof TemporaryPlayer)) {
            this.playerReference.clear();
            this.playerReference = new WeakReference<Player>(updated);
        }
        return this.playerReference;
    }

    public Player getPlayer() {
        return (Player)this.getPlayerReference().get();
    }

    public boolean isPlayerTemporary() {
        return this.getPlayer() instanceof TemporaryPlayer;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isServerPacket() {
        return this.serverPacket;
    }

    public AsyncMarker getAsyncMarker() {
        return this.asyncMarker;
    }

    public void setAsyncMarker(AsyncMarker asyncMarker) {
        if (this.isAsynchronous()) {
            throw new IllegalStateException("The marker is immutable for asynchronous events");
        }
        if (this.readOnly) {
            throw new IllegalStateException("The packet event is read-only.");
        }
        this.asyncMarker = asyncMarker;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void schedule(ScheduledPacket scheduled) {
        this.getNetworkMarker().getScheduledPackets().add(scheduled);
    }

    public boolean unschedule(ScheduledPacket scheduled) {
        if (this.networkMarker != null) {
            return this.networkMarker.getScheduledPackets().remove(scheduled);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        Player player = this.getPlayer();
        output.writeObject(player != null ? new SerializedOfflinePlayer((OfflinePlayer)player) : null);
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        SerializedOfflinePlayer serialized = (SerializedOfflinePlayer)input.readObject();
        if (serialized != null) {
            Player offlinePlayer = serialized.getPlayer();
            this.playerReference = new WeakReference<Player>(offlinePlayer);
        }
    }

    @Override
    public String toString() {
        return "PacketEvent[player=" + this.getPlayer() + ", packet=" + this.packet + "]";
    }
}

