/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.injector.netty.ProtocolRegistry;
import com.comphenix.protocol.injector.packet.MapContainer;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class NettyProtocolRegistry
extends ProtocolRegistry {
    @Override
    protected synchronized void initialize() {
        if (MinecraftVersion.getCurrentVersion().isAtLeast(MinecraftVersion.BEE_UPDATE)) {
            this.initializeNew();
            return;
        }
        T[] protocols = this.enumProtocol.getEnumConstants();
        LinkedHashMap serverMaps = Maps.newLinkedHashMap();
        LinkedHashMap clientMaps = Maps.newLinkedHashMap();
        ProtocolRegistry.Register result = new ProtocolRegistry.Register();
        StructureModifier modifier = null;
        for (Object protocol : protocols) {
            if (modifier == null) {
                modifier = new StructureModifier(protocol.getClass().getSuperclass(), false);
            }
            StructureModifier maps = modifier.withTarget(protocol).withType(Map.class);
            for (Map.Entry entry : ((Map)maps.read(0)).entrySet()) {
                String direction = entry.getKey().toString();
                if (direction.contains("CLIENTBOUND")) {
                    serverMaps.put(protocol, entry.getValue());
                    continue;
                }
                if (!direction.contains("SERVERBOUND")) continue;
                clientMaps.put(protocol, entry.getValue());
            }
        }
        for (Object map : serverMaps.values()) {
            result.containers.add(new MapContainer(map));
        }
        for (Object map : clientMaps.values()) {
            result.containers.add(new MapContainer(map));
        }
        for (Object protocol : protocols) {
            Enum enumProtocol = (Enum)protocol;
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            if (serverMaps.containsKey(protocol)) {
                this.associatePackets(result, (Map)serverMaps.get(protocol), equivalent, PacketType.Sender.SERVER);
            }
            if (!clientMaps.containsKey(protocol)) continue;
            this.associatePackets(result, (Map)clientMaps.get(protocol), equivalent, PacketType.Sender.CLIENT);
        }
        this.register = result;
    }

    private synchronized void initializeNew() {
        T[] protocols = this.enumProtocol.getEnumConstants();
        LinkedHashMap serverMaps = Maps.newLinkedHashMap();
        LinkedHashMap clientMaps = Maps.newLinkedHashMap();
        ProtocolRegistry.Register result = new ProtocolRegistry.Register();
        Field mainMapField = null;
        Field packetMapField = null;
        for (Object protocol : protocols) {
            Map directionMap;
            if (mainMapField == null) {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(protocol.getClass(), true);
                mainMapField = fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).requireModifier(16).typeDerivedOf(Map.class).build());
                mainMapField.setAccessible(true);
            }
            try {
                directionMap = (Map)mainMapField.get(protocol);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to access packet map", ex);
            }
            for (Map.Entry entry : directionMap.entrySet()) {
                Map packetMap;
                Object holder = entry.getValue();
                if (packetMapField == null) {
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(holder.getClass(), true);
                    packetMapField = fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).requireModifier(16).typeDerivedOf(Map.class).build());
                    packetMapField.setAccessible(true);
                }
                try {
                    packetMap = (Map)packetMapField.get(holder);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException("Failed to access packet map", ex);
                }
                String direction = entry.getKey().toString();
                if (direction.contains("CLIENTBOUND")) {
                    serverMaps.put(protocol, packetMap);
                    continue;
                }
                if (!direction.contains("SERVERBOUND")) continue;
                clientMaps.put(protocol, packetMap);
            }
        }
        for (Object protocol : protocols) {
            Enum enumProtocol = (Enum)protocol;
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            if (serverMaps.containsKey(protocol)) {
                this.associatePackets(result, this.reverse((Map)serverMaps.get(protocol)), equivalent, PacketType.Sender.SERVER);
            }
            if (!clientMaps.containsKey(protocol)) continue;
            this.associatePackets(result, this.reverse((Map)clientMaps.get(protocol)), equivalent, PacketType.Sender.CLIENT);
        }
        this.register = result;
    }

    private <K, V> Map<V, K> reverse(Map<K, V> map) {
        HashMap<V, K> newMap = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }

    @Override
    protected void associatePackets(ProtocolRegistry.Register register, Map<Integer, Class<?>> lookup, PacketType.Protocol protocol, PacketType.Sender sender) {
        for (Map.Entry<Integer, Class<?>> entry : lookup.entrySet()) {
            PacketType type = PacketType.fromCurrent(protocol, sender, entry.getKey(), entry.getValue());
            try {
                register.typeToClass.put((Object)type, entry.getValue());
                if (sender == PacketType.Sender.SERVER) {
                    register.serverPackets.add(type);
                }
                if (sender != PacketType.Sender.CLIENT) continue;
                register.clientPackets.add(type);
            }
            catch (Exception ex) {
                ProtocolLogger.debug("Encountered an exception associating packet " + type, ex);
            }
        }
    }
}

