/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.player;

import com.comphenix.net.sf.cglib.proxy.Callback;
import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.net.sf.cglib.proxy.MethodInterceptor;
import com.comphenix.net.sf.cglib.proxy.MethodProxy;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.player.NetworkFieldInjector;
import com.comphenix.protocol.injector.player.PlayerInjector;
import com.comphenix.protocol.utility.EnhancerFactory;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.MapMaker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

class InjectedArrayList
extends ArrayList<Object> {
    public static final ReportType REPORT_CANNOT_REVERT_CANCELLED_PACKET = new ReportType("Reverting cancelled packet failed.");
    private static final long serialVersionUID = -1173865905404280990L;
    private static ConcurrentMap<Object, Object> delegateLookup = new MapMaker().weakKeys().makeMap();
    private transient PlayerInjector injector;
    private transient Set<Object> ignoredPackets;
    private transient InvertedIntegerCallback callback;

    public InjectedArrayList(PlayerInjector injector, Set<Object> ignoredPackets) {
        this.injector = injector;
        this.ignoredPackets = ignoredPackets;
        this.callback = new InvertedIntegerCallback();
    }

    @Override
    public boolean add(Object packet) {
        Object result = null;
        if (packet instanceof NetworkFieldInjector.FakePacket) {
            return true;
        }
        result = this.ignoredPackets.contains(packet) ? Boolean.valueOf(this.ignoredPackets.remove(packet)) : this.injector.handlePacketSending(packet);
        try {
            if (result != null) {
                super.add(result);
            } else {
                this.injector.sendServerPacket(this.createNegativePacket(packet), null, true);
            }
            return true;
        }
        catch (InvocationTargetException e) {
            ProtocolLibrary.getErrorReporter().reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_REVERT_CANCELLED_PACKET).error(e).callerParam(packet));
            return false;
        }
    }

    Object createNegativePacket(Object source) {
        ListenerInvoker invoker = this.injector.getInvoker();
        PacketType type = invoker.getPacketType(source);
        Enhancer ex = EnhancerFactory.getInstance().createEnhancer();
        ex.setSuperclass(MinecraftReflection.getPacketClass());
        ex.setInterfaces(new Class[]{NetworkFieldInjector.FakePacket.class});
        ex.setUseCache(true);
        ex.setCallbackType(InvertedIntegerCallback.class);
        Class proxyClass = ex.createClass();
        Enhancer.registerCallbacks(proxyClass, new Callback[]{this.callback});
        try {
            invoker.registerPacketClass(proxyClass, type.getLegacyId());
            Object proxy = proxyClass.newInstance();
            InjectedArrayList.registerDelegate(proxy, source);
            Object t = proxy;
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create fake class.", e);
        }
        finally {
            invoker.unregisterPacketClass(proxyClass);
        }
    }

    private static void registerDelegate(Object proxy, Object source) {
        delegateLookup.put(proxy, source);
    }

    private class InvertedIntegerCallback
    implements MethodInterceptor {
        private InvertedIntegerCallback() {
        }

        @Override
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object delegate = delegateLookup.get(obj);
            if (delegate == null) {
                throw new IllegalStateException("Unable to find delegate source for " + obj);
            }
            if (method.getReturnType().equals(Integer.TYPE) && args.length == 0) {
                Integer result = (Integer)proxy.invoke(delegate, args);
                return -result.intValue();
            }
            return proxy.invoke(delegate, args);
        }
    }
}

