/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.player;

import com.comphenix.protocol.concurrency.IntegerSet;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.GamePhase;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.PlayerInjectHooks;
import com.comphenix.protocol.injector.player.InjectedArrayList;
import com.comphenix.protocol.injector.player.PlayerInjector;
import com.comphenix.protocol.injector.player.UnsupportedListener;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.VolatileField;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

class NetworkFieldInjector
extends PlayerInjector {
    private MinecraftVersion safeVersion = new MinecraftVersion("1.4.4");
    private Set<Object> ignoredPackets = Sets.newSetFromMap(new ConcurrentHashMap());
    private List<VolatileField> overridenLists = new ArrayList<VolatileField>();
    private static Field syncField;
    private Object syncObject;
    private IntegerSet sendingFilters;

    public NetworkFieldInjector(ErrorReporter reporter, Player player, ListenerInvoker manager, IntegerSet sendingFilters) {
        super(reporter, player, manager);
        this.sendingFilters = sendingFilters;
    }

    @Override
    protected boolean hasListener(int packetID) {
        return this.sendingFilters.contains(packetID);
    }

    @Override
    public synchronized void initialize(Object injectionSource) throws IllegalAccessException {
        super.initialize(injectionSource);
        if (this.hasInitialized) {
            if (syncField == null) {
                syncField = FuzzyReflection.fromObject(this.networkManager, true).getFieldByType("java\\.lang\\.Object");
            }
            this.syncObject = FieldUtils.readField(syncField, this.networkManager, true);
        }
    }

    @Override
    public void sendServerPacket(Object packet, NetworkMarker marker, boolean filtered) throws InvocationTargetException {
        if (this.networkManager != null) {
            try {
                if (!filtered) {
                    this.ignoredPackets.add(packet);
                }
                if (marker != null) {
                    this.queuedMarkers.put(packet, marker);
                }
                queueMethod.invoke(this.networkManager, packet);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to access queue method.", e);
            }
        } else {
            throw new IllegalStateException("Unable to load network mananager. Cannot send packet.");
        }
    }

    @Override
    public UnsupportedListener checkListener(MinecraftVersion version, PacketListener listener) {
        if (version != null && version.compareTo(this.safeVersion) > 0) {
            return null;
        }
        int[] unsupported = new int[]{51, 56};
        if (ListeningWhitelist.containsAny(listener.getSendingWhitelist(), unsupported)) {
            return new UnsupportedListener("The NETWORK_FIELD_INJECTOR hook doesn't support map chunk listeners.", unsupported);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectManager() {
        if (this.networkManager != null) {
            StructureModifier list = networkModifier.withType(List.class);
            for (Field field : list.getFields()) {
                VolatileField overwriter = new VolatileField(field, this.networkManager, true);
                List minecraftList = (List)overwriter.getOldValue();
                Object object = this.syncObject;
                synchronized (object) {
                    InjectedArrayList hackedList = new InjectedArrayList(this, this.ignoredPackets);
                    for (Object packet : minecraftList) {
                        hackedList.add(packet);
                    }
                    minecraftList.clear();
                    overwriter.setValue(Collections.synchronizedList(hackedList));
                }
                this.overridenLists.add(overwriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanHook() {
        for (VolatileField overriden : this.overridenLists) {
            List hacketList;
            List minecraftList = (List)overriden.getOldValue();
            if (minecraftList == (hacketList = (List)overriden.getValue())) {
                return;
            }
            Object object = this.syncObject;
            synchronized (object) {
                try {
                    for (Object packet : (List)overriden.getValue()) {
                        minecraftList.add(packet);
                    }
                }
                finally {
                    overriden.revertValue();
                }
            }
        }
        this.overridenLists.clear();
    }

    @Override
    public void handleDisconnect() {
    }

    @Override
    public boolean canInject(GamePhase phase) {
        return true;
    }

    @Override
    public PlayerInjectHooks getHookType() {
        return PlayerInjectHooks.NETWORK_HANDLER_FIELDS;
    }

    public static interface FakePacket {
    }
}

