/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import com.google.common.base.Objects;
import java.util.regex.Pattern;

class ClassRegexMatcher
extends AbstractFuzzyMatcher<Class<?>> {
    private final Pattern regex;
    private final int priority;

    public ClassRegexMatcher(Pattern regex, int priority) {
        if (regex == null) {
            throw new IllegalArgumentException("Regular expression pattern cannot be NULL.");
        }
        this.regex = regex;
        this.priority = priority;
    }

    @Override
    public boolean isMatch(Class<?> value, Object parent) {
        if (value != null) {
            return this.regex.matcher(value.getCanonicalName()).matches();
        }
        return false;
    }

    @Override
    protected int calculateRoundNumber() {
        return -this.priority;
    }

    public String toString() {
        return "class name of " + this.regex.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.regex, this.priority});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassRegexMatcher) {
            ClassRegexMatcher other = (ClassRegexMatcher)obj;
            return this.priority == other.priority && FuzzyMatchers.checkPattern(this.regex, other.regex);
        }
        return false;
    }
}

