/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import java.util.function.Function;

public class Converters {
    public static <T> EquivalentConverter<T> ignoreNull(final EquivalentConverter<T> converter) {
        return new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return generic != null ? (Object)converter.getSpecific(generic) : null;
            }

            @Override
            public Object getGeneric(T specific) {
                return specific != null ? converter.getGeneric(specific) : null;
            }

            @Override
            public Class<T> getSpecificType() {
                return converter.getSpecificType();
            }
        };
    }

    public static <T> EquivalentConverter<T> passthrough(final Class<T> clazz) {
        return Converters.ignoreNull(new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return generic;
            }

            @Override
            public Object getGeneric(T specific) {
                return specific;
            }

            @Override
            public Class<T> getSpecificType() {
                return clazz;
            }
        });
    }

    public static <T> EquivalentConverter<T> handle(final Function<T, Object> toHandle, final Function<Object, T> fromHandle) {
        return new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return fromHandle.apply(generic);
            }

            @Override
            public Object getGeneric(T specific) {
                return toHandle.apply(specific);
            }

            @Override
            public Class<T> getSpecificType() {
                return null;
            }
        };
    }
}

