/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkCoordIntPair;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.bukkit.Location;
import org.bukkit.World;

public class MultiBlockChangeInfo {
    private static Constructor<?> constructor;
    private static Class<?> nmsClass;
    private short location;
    private WrappedBlockData data;
    private ChunkCoordIntPair chunk;

    public MultiBlockChangeInfo(short location, WrappedBlockData data, ChunkCoordIntPair chunk) {
        this.location = location;
        this.data = data;
        this.chunk = chunk;
    }

    public MultiBlockChangeInfo(Location location, WrappedBlockData data) {
        this.data = data;
        this.chunk = new ChunkCoordIntPair(location.getBlockX() >> 4, location.getBlockZ() >> 4);
        this.setLocation(location);
    }

    public Location getLocation(World world) {
        return new Location(world, (double)this.getAbsoluteX(), (double)this.getY(), (double)this.getAbsoluteZ());
    }

    public void setLocation(Location location) {
        this.setLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public void setLocation(int x, int y, int z) {
        this.location = (short)((x &= 0xF) << 12 | (z &= 0xF) << 8 | y);
    }

    public int getX() {
        return this.location >> 12 & 0xF;
    }

    public int getAbsoluteX() {
        return (this.chunk.getChunkX() << 4) + this.getX();
    }

    public void setX(int x) {
        this.setLocation(x, this.getY(), this.getZ());
    }

    public int getY() {
        return this.location & 0xFF;
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y, this.getZ());
    }

    public int getZ() {
        return this.location >> 8 & 0xF;
    }

    public int getAbsoluteZ() {
        return (this.chunk.getChunkZ() << 4) + this.getZ();
    }

    public void setZ(int z) {
        this.setLocation(this.getX(), this.getY(), z);
    }

    public WrappedBlockData getData() {
        return this.data;
    }

    public void setData(WrappedBlockData data) {
        this.data = data;
    }

    public ChunkCoordIntPair getChunk() {
        return this.chunk;
    }

    public static EquivalentConverter<MultiBlockChangeInfo> getConverter(final ChunkCoordIntPair chunk) {
        return new EquivalentConverter<MultiBlockChangeInfo>(){

            @Override
            public MultiBlockChangeInfo getSpecific(Object generic) {
                StructureModifier modifier = new StructureModifier(generic.getClass(), null, false).withTarget(generic);
                StructureModifier shorts = modifier.withType(Short.TYPE);
                short location = (Short)shorts.read(0);
                StructureModifier<WrappedBlockData> dataModifier = modifier.withType(MinecraftReflection.getIBlockDataClass(), BukkitConverters.getWrappedBlockDataConverter());
                WrappedBlockData data = dataModifier.read(0);
                return new MultiBlockChangeInfo(location, data, chunk);
            }

            @Override
            public Object getGeneric(MultiBlockChangeInfo specific) {
                try {
                    if (constructor == null) {
                        constructor = nmsClass.getConstructor(PacketType.Play.Server.MULTI_BLOCK_CHANGE.getPacketClass(), Short.TYPE, MinecraftReflection.getIBlockDataClass());
                    }
                    return constructor.newInstance(null, specific.location, BukkitConverters.getWrappedBlockDataConverter().getGeneric(specific.data));
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Failed to construct MultiBlockChangeInfo instance.", ex);
                }
            }

            @Override
            public Class<MultiBlockChangeInfo> getSpecificType() {
                return MultiBlockChangeInfo.class;
            }
        };
    }

    public static EquivalentConverter<MultiBlockChangeInfo[]> getArrayConverter(final ChunkCoordIntPair chunk) {
        return new EquivalentConverter<MultiBlockChangeInfo[]>(){
            private final EquivalentConverter<MultiBlockChangeInfo> converter;
            {
                this.converter = MultiBlockChangeInfo.getConverter(chunk);
            }

            @Override
            public MultiBlockChangeInfo[] getSpecific(Object generic) {
                Object[] array = (Object[])generic;
                MultiBlockChangeInfo[] result = new MultiBlockChangeInfo[array.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = this.converter.getSpecific(array[i]);
                }
                return result;
            }

            @Override
            public Object getGeneric(MultiBlockChangeInfo[] specific) {
                Object[] result = (Object[])Array.newInstance(nmsClass, specific.length);
                for (int i = 0; i < result.length; ++i) {
                    result[i] = this.converter.getGeneric(specific[i]);
                }
                return result;
            }

            @Override
            public Class<MultiBlockChangeInfo[]> getSpecificType() {
                return MultiBlockChangeInfo[].class;
            }
        };
    }

    static {
        nmsClass = MinecraftReflection.getMultiBlockChangeInfoClass();
    }
}

