/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketTypeEnum;
import com.comphenix.protocol.PacketTypeLookup;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.utility.Constants;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketType
implements Serializable,
Cloneable,
Comparable<PacketType> {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_PACKET = -1;
    private static PacketTypeLookup LOOKUP;
    private static final MinecraftVersion PROTOCOL_VERSION;
    private final Protocol protocol;
    private final Sender sender;
    private final int currentId;
    private final MinecraftVersion version;
    private final List<String> classNames;
    String[] names;
    private String name;
    private boolean deprecated;
    private boolean forceAsync;
    private boolean dynamic;
    private int hashCode;
    static Consumer<String> onDynamicCreate;

    private static PacketTypeLookup getLookup() {
        if (LOOKUP == null) {
            LOOKUP = new PacketTypeLookup().addPacketTypes(Handshake.Client.getInstance()).addPacketTypes(Handshake.Server.getInstance()).addPacketTypes(Play.Client.getInstance()).addPacketTypes(Play.Server.getInstance()).addPacketTypes(Status.Client.getInstance()).addPacketTypes(Status.Server.getInstance()).addPacketTypes(Login.Client.getInstance()).addPacketTypes(Login.Server.getInstance());
        }
        return LOOKUP;
    }

    public static Iterable<PacketType> values() {
        ArrayList sources = Lists.newArrayList();
        sources.add(Handshake.Client.getInstance());
        sources.add(Handshake.Server.getInstance());
        sources.add(Play.Client.getInstance());
        sources.add(Play.Server.getInstance());
        sources.add(Status.Client.getInstance());
        sources.add(Status.Server.getInstance());
        sources.add(Login.Client.getInstance());
        sources.add(Login.Server.getInstance());
        return Iterables.concat((Iterable)sources);
    }

    @Deprecated
    public static PacketType findLegacy(int packetId) {
        PacketType type = PacketType.getLookup().getFromLegacy(packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    @Deprecated
    public static PacketType findLegacy(int packetId, Sender preference) {
        if (preference == null) {
            return PacketType.findLegacy(packetId);
        }
        PacketType type = PacketType.getLookup().getFromLegacy(packetId, preference);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    @Deprecated
    public static boolean hasLegacy(int packetId) {
        return PacketType.getLookup().getFromLegacy(packetId) != null;
    }

    public static PacketType findCurrent(Protocol protocol, Sender sender, int packetId) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + packetId + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    public static PacketType findCurrent(Protocol protocol, Sender sender, String name) {
        name = PacketType.formatClassName(protocol, sender, name);
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + name + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    private static String formatMojangClassName(Protocol protocol, Sender sender, String name) {
        return "net.minecraft.network.protocol." + protocol.getMojangName() + "." + sender.getMojangName() + name + "Packet";
    }

    private static String formatClassName(Protocol protocol, Sender sender, String name) {
        if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
            return "net.minecraft.network.protocol." + protocol.getMojangName() + ".Packet" + protocol.getPacketName() + sender.getPacketName() + name;
        }
        String base = MinecraftReflection.getMinecraftPackage() + ".Packet";
        if (name.startsWith(base)) {
            return name;
        }
        if (name.contains("$")) {
            String[] split = name.split("\\$");
            String parent = split[0];
            String child = split[1];
            return base + protocol.getPacketName() + sender.getPacketName() + WordUtils.capitalize((String)parent) + "$Packet" + protocol.getPacketName() + sender.getPacketName() + WordUtils.capitalize((String)child);
        }
        return base + protocol.getPacketName() + sender.getPacketName() + WordUtils.capitalize((String)name);
    }

    private static boolean isMcpPacketName(String packetName) {
        return packetName.startsWith("C00") || packetName.startsWith("CPacket") || packetName.startsWith("SPacket");
    }

    private static String formatMcpClassName(Protocol protocol, Sender sender, String name) {
        return "net.minecraft.network." + protocol.getMcpPacketName() + "." + sender.getMcpPacketName() + "." + name;
    }

    public static boolean hasCurrent(Protocol protocol, Sender sender, int packetId) {
        return PacketType.getLookup().getFromCurrent(protocol, sender, packetId) != null;
    }

    public static PacketType fromID(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, PROTOCOL_VERSION, packetClass.getName());
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromCurrent(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        String className;
        PacketTypeLookup.ClassLookup lookup = PacketType.getLookup().getClassLookup();
        Map<String, PacketType> map = lookup.getMap(protocol, sender);
        PacketType type = PacketType.find(map, className = packetClass.getName());
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, PROTOCOL_VERSION, className);
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
            onDynamicCreate.accept(className);
        }
        return type;
    }

    private static PacketType find(Map<String, PacketType> map, String clazz) {
        PacketType ret = map.get(clazz);
        if (ret != null) {
            return ret;
        }
        for (PacketType check : map.values()) {
            List<String> aliases = check.getClassNames();
            if (aliases.size() <= 1) continue;
            for (String alias : aliases) {
                if (!alias.equals(clazz)) continue;
                return check;
            }
        }
        return null;
    }

    public static PacketType fromClass(Class<?> packetClass) {
        PacketType type = PacketRegistry.getPacketType(packetClass);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Class " + packetClass + " is not a registered packet.");
    }

    public static Collection<PacketType> fromName(String name) {
        return PacketType.getLookup().getFromName(name);
    }

    @Deprecated
    public static boolean hasClass(Class<?> packetClass) {
        return PacketRegistry.getPacketType(packetClass) != null;
    }

    public static void scheduleRegister(final PacketType type, final String name) {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                PacketTypeEnum objEnum = PacketType.getObjectEnum(type);
                if (objEnum.registerMember(type, name)) {
                    PacketType.getLookup().addPacketTypes(Collections.singletonList(type));
                }
            }
        };
        if (Bukkit.getServer() == null || Bukkit.isPrimaryThread()) {
            try {
                runnable.run();
            }
            catch (Exception exception) {}
        } else {
            runnable.runTaskLater(ProtocolLibrary.getPlugin(), 0L);
        }
    }

    public static PacketTypeEnum getObjectEnum(PacketType type) {
        switch (type.getProtocol()) {
            case HANDSHAKING: {
                return type.isClient() ? Handshake.Client.getInstance() : Handshake.Server.getInstance();
            }
            case PLAY: {
                return type.isClient() ? Play.Client.getInstance() : Play.Server.getInstance();
            }
            case STATUS: {
                return type.isClient() ? Status.Client.getInstance() : Status.Server.getInstance();
            }
            case LOGIN: {
                return type.isClient() ? Login.Client.getInstance() : Login.Server.getInstance();
            }
        }
        throw new IllegalStateException("Unexpected protocol: " + (Object)((Object)type.getProtocol()));
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, String ... names) {
        this(protocol, sender, currentId, PROTOCOL_VERSION, names);
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, MinecraftVersion version, String ... names) {
        this.protocol = (Protocol)((Object)Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol cannot be NULL"));
        this.sender = (Sender)((Object)Preconditions.checkNotNull((Object)((Object)sender), (Object)"sender cannot be NULL"));
        this.currentId = currentId;
        this.version = version;
        this.classNames = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (PacketType.isMcpPacketName(names[i])) {
                this.classNames.add(PacketType.formatMcpClassName(protocol, sender, names[i]));
                continue;
            }
            this.classNames.add(PacketType.formatClassName(protocol, sender, names[i]));
            this.classNames.add(PacketType.formatMojangClassName(protocol, sender, names[i]));
        }
        this.names = names;
    }

    public boolean isSupported() {
        return PacketRegistry.isSupported(this);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Sender getSender() {
        return this.sender;
    }

    public boolean isClient() {
        return this.sender == Sender.CLIENT;
    }

    public boolean isServer() {
        return this.sender == Sender.SERVER;
    }

    @Deprecated
    public int getCurrentId() {
        return this.currentId;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public Class<?> getPacketClass() {
        return PacketRegistry.tryGetPacketClass(this).orElse(null);
    }

    void setName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    void setDeprecated() {
        this.deprecated = true;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    void forceAsync() {
        this.forceAsync = true;
    }

    public boolean isAsyncForced() {
        return this.forceAsync;
    }

    public MinecraftVersion getCurrentVersion() {
        return this.version;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = this.protocol.hashCode();
            hash = 31 * hash + this.sender.hashCode();
            this.hashCode = hash = 31 * hash + Integer.hashCode(this.currentId);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PacketType) {
            PacketType other = (PacketType)obj;
            return this.protocol == other.protocol && this.sender == other.sender && this.currentId == other.currentId;
        }
        return false;
    }

    @Override
    public int compareTo(PacketType other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.protocol), (Comparable)((Object)other.getProtocol())).compare((Comparable)((Object)this.sender), (Comparable)((Object)other.getSender())).compare(this.currentId, other.getCurrentId()).result();
    }

    public String toString() {
        Class<?> clazz = this.getPacketClass();
        if (clazz == null) {
            return this.name() + "[" + (Object)((Object)this.protocol) + ", " + (Object)((Object)this.sender) + ", " + this.currentId + ", classNames: " + this.classNames + " (unregistered)]";
        }
        return this.name() + "[class=" + clazz.getSimpleName() + ", id=" + this.currentId + "]";
    }

    public PacketType clone() {
        try {
            return (PacketType)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("This shouldn't happen", ex);
        }
    }

    static {
        PROTOCOL_VERSION = Constants.CURRENT_VERSION;
        onDynamicCreate = x -> {};
    }

    public static class Handshake {
        private static final Protocol PROTOCOL = Protocol.HANDSHAKING;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$000() {
            return PROTOCOL;
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Server getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType SET_PROTOCOL = new PacketType(Handshake.access$000(), SENDER, 0, "SetProtocol", "C00Handshake");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Client getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }
    }

    public static class Play {
        private static final Protocol PROTOCOL = Protocol.PLAY;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$100() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType TELEPORT_ACCEPT = new PacketType(Play.access$100(), SENDER, 0, "TeleportAccept", "CPacketConfirmTeleport");
            public static final PacketType TILE_NBT_QUERY = new PacketType(Play.access$100(), SENDER, 1, "TileNBTQuery");
            public static final PacketType DIFFICULTY_CHANGE = new PacketType(Play.access$100(), SENDER, 2, "DifficultyChange");
            public static final PacketType CHAT = new PacketType(Play.access$100(), SENDER, 3, "Chat", "CPacketChatMessage");
            public static final PacketType CLIENT_COMMAND = new PacketType(Play.access$100(), SENDER, 4, "ClientCommand", "CPacketClientStatus");
            public static final PacketType SETTINGS = new PacketType(Play.access$100(), SENDER, 5, "Settings", "CPacketClientSettings");
            public static final PacketType TAB_COMPLETE = new PacketType(Play.access$100(), SENDER, 6, "TabComplete", "CPacketTabComplete");
            public static final PacketType ENCHANT_ITEM = new PacketType(Play.access$100(), SENDER, 7, "EnchantItem", "CPacketEnchantItem");
            public static final PacketType WINDOW_CLICK = new PacketType(Play.access$100(), SENDER, 8, "WindowClick", "CPacketClickWindow");
            public static final PacketType CLOSE_WINDOW = new PacketType(Play.access$100(), SENDER, 9, "CloseWindow", "CPacketCloseWindow");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Play.access$100(), SENDER, 10, "CustomPayload", "CPacketCustomPayload");
            public static final PacketType B_EDIT = new PacketType(Play.access$100(), SENDER, 11, "BEdit");
            public static final PacketType ENTITY_NBT_QUERY = new PacketType(Play.access$100(), SENDER, 12, "EntityNBTQuery");
            public static final PacketType USE_ENTITY = new PacketType(Play.access$100(), SENDER, 13, "UseEntity", "CPacketUseEntity");
            public static final PacketType JIGSAW_GENERATE = new PacketType(Play.access$100(), SENDER, 14, "JigsawGenerate");
            public static final PacketType KEEP_ALIVE = new PacketType(Play.access$100(), SENDER, 15, "KeepAlive", "CPacketKeepAlive");
            public static final PacketType DIFFICULTY_LOCK = new PacketType(Play.access$100(), SENDER, 16, "DifficultyLock");
            public static final PacketType POSITION = new PacketType(Play.access$100(), SENDER, 17, "Flying$PacketPlayInPosition", "Flying$Position", "CPacketPlayer$Position");
            public static final PacketType POSITION_LOOK = new PacketType(Play.access$100(), SENDER, 18, "Flying$PacketPlayInPositionLook", "Flying$PositionLook", "CPacketPlayer$PositionRotation");
            public static final PacketType LOOK = new PacketType(Play.access$100(), SENDER, 19, "Flying$PacketPlayInLook", "Flying$Look", "CPacketPlayer$Rotation");
            public static final PacketType GROUND = new PacketType(Play.access$100(), SENDER, 20, "Flying$d");
            public static final PacketType VEHICLE_MOVE = new PacketType(Play.access$100(), SENDER, 21, "VehicleMove", "CPacketVehicleMove");
            public static final PacketType BOAT_MOVE = new PacketType(Play.access$100(), SENDER, 22, "BoatMove", "CPacketSteerBoat");
            public static final PacketType PICK_ITEM = new PacketType(Play.access$100(), SENDER, 23, "PickItem");
            public static final PacketType AUTO_RECIPE = new PacketType(Play.access$100(), SENDER, 24, "AutoRecipe", "CPacketPlaceRecipe");
            public static final PacketType ABILITIES = new PacketType(Play.access$100(), SENDER, 25, "Abilities", "CPacketPlayerAbilities");
            public static final PacketType BLOCK_DIG = new PacketType(Play.access$100(), SENDER, 26, "BlockDig", "CPacketPlayerDigging");
            public static final PacketType ENTITY_ACTION = new PacketType(Play.access$100(), SENDER, 27, "EntityAction", "CPacketEntityAction");
            public static final PacketType STEER_VEHICLE = new PacketType(Play.access$100(), SENDER, 28, "SteerVehicle", "CPacketInput");
            public static final PacketType PONG = new PacketType(Play.access$100(), SENDER, 29, "Pong", "ServerboundPongPacket");
            public static final PacketType RECIPE_SETTINGS = new PacketType(Play.access$100(), SENDER, 30, "RecipeSettings");
            public static final PacketType RECIPE_DISPLAYED = new PacketType(Play.access$100(), SENDER, 31, "RecipeDisplayed", "CPacketRecipeInfo");
            public static final PacketType ITEM_NAME = new PacketType(Play.access$100(), SENDER, 32, "ItemName");
            public static final PacketType RESOURCE_PACK_STATUS = new PacketType(Play.access$100(), SENDER, 33, "ResourcePackStatus", "CPacketResourcePackStatus");
            public static final PacketType ADVANCEMENTS = new PacketType(Play.access$100(), SENDER, 34, "Advancements", "CPacketSeenAdvancements");
            public static final PacketType TR_SEL = new PacketType(Play.access$100(), SENDER, 35, "TrSel");
            public static final PacketType BEACON = new PacketType(Play.access$100(), SENDER, 36, "Beacon");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(Play.access$100(), SENDER, 37, "HeldItemSlot", "CPacketHeldItemChange");
            public static final PacketType SET_COMMAND_BLOCK = new PacketType(Play.access$100(), SENDER, 38, "SetCommandBlock");
            public static final PacketType SET_COMMAND_MINECART = new PacketType(Play.access$100(), SENDER, 39, "SetCommandMinecart");
            public static final PacketType SET_CREATIVE_SLOT = new PacketType(Play.access$100(), SENDER, 40, "SetCreativeSlot", "CPacketCreativeInventoryAction");
            public static final PacketType SET_JIGSAW = new PacketType(Play.access$100(), SENDER, 41, "SetJigsaw");
            public static final PacketType STRUCT = new PacketType(Play.access$100(), SENDER, 42, "Struct");
            public static final PacketType UPDATE_SIGN = new PacketType(Play.access$100(), SENDER, 43, "UpdateSign", "CPacketUpdateSign");
            public static final PacketType ARM_ANIMATION = new PacketType(Play.access$100(), SENDER, 44, "ArmAnimation", "CPacketAnimation");
            public static final PacketType SPECTATE = new PacketType(Play.access$100(), SENDER, 45, "Spectate", "CPacketSpectate");
            public static final PacketType USE_ITEM = new PacketType(Play.access$100(), SENDER, 46, "UseItem", "CPacketPlayerTryUseItemOnBlock");
            public static final PacketType BLOCK_PLACE = new PacketType(Play.access$100(), SENDER, 47, "BlockPlace", "CPacketPlayerTryUseItem");
            @Deprecated
            public static final PacketType TRANSACTION = new PacketType(Play.access$100(), SENDER, 255, "Transaction", "CPacketConfirmTransaction");
            @Deprecated
            public static final PacketType FLYING = new PacketType(Play.access$100(), SENDER, 254, "Flying", "CPacketPlayer");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType SPAWN_ENTITY = new PacketType(Play.access$100(), SENDER, 0, "SpawnEntity", "SPacketSpawnObject");
            public static final PacketType SPAWN_ENTITY_EXPERIENCE_ORB = new PacketType(Play.access$100(), SENDER, 1, "SpawnEntityExperienceOrb", "SPacketSpawnExperienceOrb");
            public static final PacketType SPAWN_ENTITY_LIVING = new PacketType(Play.access$100(), SENDER, 2, "SpawnEntityLiving", "SPacketSpawnMob");
            public static final PacketType SPAWN_ENTITY_PAINTING = new PacketType(Play.access$100(), SENDER, 3, "SpawnEntityPainting", "SPacketSpawnPainting");
            public static final PacketType NAMED_ENTITY_SPAWN = new PacketType(Play.access$100(), SENDER, 4, "NamedEntitySpawn", "SPacketSpawnPlayer");
            public static final PacketType ADD_VIBRATION_SIGNAL = new PacketType(Play.access$100(), SENDER, 5, "AddVibrationSignal");
            public static final PacketType ANIMATION = new PacketType(Play.access$100(), SENDER, 6, "Animation", "SPacketAnimation");
            public static final PacketType STATISTIC = new PacketType(Play.access$100(), SENDER, 7, "Statistic", "SPacketStatistics");
            public static final PacketType BLOCK_BREAK = new PacketType(Play.access$100(), SENDER, 8, "BlockBreak");
            public static final PacketType BLOCK_BREAK_ANIMATION = new PacketType(Play.access$100(), SENDER, 9, "BlockBreakAnimation", "SPacketBlockBreakAnim");
            public static final PacketType TILE_ENTITY_DATA = new PacketType(Play.access$100(), SENDER, 10, "TileEntityData", "SPacketUpdateTileEntity");
            public static final PacketType BLOCK_ACTION = new PacketType(Play.access$100(), SENDER, 11, "BlockAction", "SPacketBlockAction");
            public static final PacketType BLOCK_CHANGE = new PacketType(Play.access$100(), SENDER, 12, "BlockChange", "SPacketBlockChange");
            public static final PacketType BOSS = new PacketType(Play.access$100(), SENDER, 13, "Boss", "SPacketUpdateBossInfo");
            public static final PacketType SERVER_DIFFICULTY = new PacketType(Play.access$100(), SENDER, 14, "ServerDifficulty", "SPacketServerDifficulty");
            public static final PacketType CHAT = new PacketType(Play.access$100(), SENDER, 15, "Chat", "SPacketChat");
            public static final PacketType CLEAR_TITLES = new PacketType(Play.access$100(), SENDER, 16, "ClearTitles");
            public static final PacketType TAB_COMPLETE = new PacketType(Play.access$100(), SENDER, 17, "TabComplete", "SPacketTabComplete");
            public static final PacketType COMMANDS = new PacketType(Play.access$100(), SENDER, 18, "Commands");
            public static final PacketType CLOSE_WINDOW = new PacketType(Play.access$100(), SENDER, 19, "CloseWindow", "SPacketCloseWindow");
            public static final PacketType WINDOW_ITEMS = new PacketType(Play.access$100(), SENDER, 20, "WindowItems", "SPacketWindowItems");
            public static final PacketType WINDOW_DATA = new PacketType(Play.access$100(), SENDER, 21, "WindowData", "SPacketWindowProperty");
            public static final PacketType SET_SLOT = new PacketType(Play.access$100(), SENDER, 22, "SetSlot", "SPacketSetSlot");
            public static final PacketType SET_COOLDOWN = new PacketType(Play.access$100(), SENDER, 23, "SetCooldown", "SPacketCooldown");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Play.access$100(), SENDER, 24, "CustomPayload", "SPacketCustomPayload");
            public static final PacketType CUSTOM_SOUND_EFFECT = new PacketType(Play.access$100(), SENDER, 25, "CustomSoundEffect", "SPacketCustomSound");
            public static final PacketType KICK_DISCONNECT = new PacketType(Play.access$100(), SENDER, 26, "KickDisconnect", "SPacketDisconnect");
            public static final PacketType ENTITY_STATUS = new PacketType(Play.access$100(), SENDER, 27, "EntityStatus", "SPacketEntityStatus");
            public static final PacketType EXPLOSION = new PacketType(Play.access$100(), SENDER, 28, "Explosion", "SPacketExplosion");
            public static final PacketType UNLOAD_CHUNK = new PacketType(Play.access$100(), SENDER, 29, "UnloadChunk", "SPacketUnloadChunk");
            public static final PacketType GAME_STATE_CHANGE = new PacketType(Play.access$100(), SENDER, 30, "GameStateChange", "SPacketChangeGameState");
            public static final PacketType OPEN_WINDOW_HORSE = new PacketType(Play.access$100(), SENDER, 31, "OpenWindowHorse");
            public static final PacketType INITIALIZE_BORDER = new PacketType(Play.access$100(), SENDER, 32, "InitializeBorder");
            public static final PacketType KEEP_ALIVE = new PacketType(Play.access$100(), SENDER, 33, "KeepAlive", "SPacketKeepAlive");
            public static final PacketType MAP_CHUNK = new PacketType(Play.access$100(), SENDER, 34, "MapChunk", "SPacketChunkData");
            public static final PacketType WORLD_EVENT = new PacketType(Play.access$100(), SENDER, 35, "WorldEvent", "SPacketEffect");
            public static final PacketType WORLD_PARTICLES = new PacketType(Play.access$100(), SENDER, 36, "WorldParticles", "SPacketParticles");
            public static final PacketType LIGHT_UPDATE = new PacketType(Play.access$100(), SENDER, 37, "LightUpdate");
            public static final PacketType LOGIN = new PacketType(Play.access$100(), SENDER, 38, "Login", "SPacketJoinGame");
            public static final PacketType MAP = new PacketType(Play.access$100(), SENDER, 39, "Map", "SPacketMaps");
            public static final PacketType OPEN_WINDOW_MERCHANT = new PacketType(Play.access$100(), SENDER, 40, "OpenWindowMerchant");
            public static final PacketType REL_ENTITY_MOVE = new PacketType(Play.access$100(), SENDER, 41, "Entity$PacketPlayOutRelEntityMove", "Entity$RelEntityMove");
            public static final PacketType REL_ENTITY_MOVE_LOOK = new PacketType(Play.access$100(), SENDER, 42, "Entity$PacketPlayOutRelEntityMoveLook", "Entity$RelEntityMoveLook");
            public static final PacketType ENTITY_LOOK = new PacketType(Play.access$100(), SENDER, 43, "Entity$PacketPlayOutEntityLook", "Entity$EntityLook");
            public static final PacketType VEHICLE_MOVE = new PacketType(Play.access$100(), SENDER, 44, "VehicleMove", "SPacketMoveVehicle");
            public static final PacketType OPEN_BOOK = new PacketType(Play.access$100(), SENDER, 45, "OpenBook");
            public static final PacketType OPEN_WINDOW = new PacketType(Play.access$100(), SENDER, 46, "OpenWindow", "SPacketOpenWindow");
            public static final PacketType OPEN_SIGN_EDITOR = new PacketType(Play.access$100(), SENDER, 47, "OpenSignEditor", "SPacketSignEditorOpen");
            public static final PacketType PING = new PacketType(Play.access$100(), SENDER, 48, "Ping");
            public static final PacketType AUTO_RECIPE = new PacketType(Play.access$100(), SENDER, 49, "AutoRecipe", "SPacketPlaceGhostRecipe");
            public static final PacketType ABILITIES = new PacketType(Play.access$100(), SENDER, 50, "Abilities", "SPacketPlayerAbilities");
            public static final PacketType PLAYER_COMBAT_END = new PacketType(Play.access$100(), SENDER, 51, "PlayerCombatEnd");
            public static final PacketType PLAYER_COMBAT_ENTER = new PacketType(Play.access$100(), SENDER, 52, "PlayerCombatEnter");
            public static final PacketType PLAYER_COMBAT_KILL = new PacketType(Play.access$100(), SENDER, 53, "PlayerCombatKill");
            public static final PacketType PLAYER_INFO = new PacketType(Play.access$100(), SENDER, 54, "PlayerInfo", "SPacketPlayerListItem");
            public static final PacketType LOOK_AT = new PacketType(Play.access$100(), SENDER, 55, "LookAt", "SPacketPlayerPosLook");
            public static final PacketType POSITION = new PacketType(Play.access$100(), SENDER, 56, "Position");
            public static final PacketType RECIPES = new PacketType(Play.access$100(), SENDER, 57, "Recipes", "SPacketRecipeBook");
            public static final PacketType ENTITY_DESTROY = new PacketType(Play.access$100(), SENDER, 58, "EntityDestroy", "SPacketDestroyEntities");
            public static final PacketType REMOVE_ENTITY_EFFECT = new PacketType(Play.access$100(), SENDER, 59, "RemoveEntityEffect", "SPacketRemoveEntityEffect");
            public static final PacketType RESOURCE_PACK_SEND = new PacketType(Play.access$100(), SENDER, 60, "ResourcePackSend", "SPacketResourcePackSend");
            public static final PacketType RESPAWN = new PacketType(Play.access$100(), SENDER, 61, "Respawn", "SPacketRespawn");
            public static final PacketType ENTITY_HEAD_ROTATION = new PacketType(Play.access$100(), SENDER, 62, "EntityHeadRotation", "SPacketEntityHeadLook");
            public static final PacketType MULTI_BLOCK_CHANGE = new PacketType(Play.access$100(), SENDER, 63, "MultiBlockChange", "SPacketMultiBlockChange");
            public static final PacketType SELECT_ADVANCEMENT_TAB = new PacketType(Play.access$100(), SENDER, 64, "SelectAdvancementTab", "SPacketSelectAdvancementsTab");
            public static final PacketType SET_ACTION_BAR_TEXT = new PacketType(Play.access$100(), SENDER, 65, "SetActionBarText");
            public static final PacketType SET_BORDER_CENTER = new PacketType(Play.access$100(), SENDER, 66, "SetBorderCenter");
            public static final PacketType SET_BORDER_LERP_SIZE = new PacketType(Play.access$100(), SENDER, 67, "SetBorderLerpSize");
            public static final PacketType SET_BORDER_SIZE = new PacketType(Play.access$100(), SENDER, 68, "SetBorderSize");
            public static final PacketType SET_BORDER_WARNING_DELAY = new PacketType(Play.access$100(), SENDER, 69, "SetBorderWarningDelay");
            public static final PacketType SET_BORDER_WARNING_DISTANCE = new PacketType(Play.access$100(), SENDER, 70, "SetBorderWarningDistance");
            public static final PacketType CAMERA = new PacketType(Play.access$100(), SENDER, 71, "Camera", "SPacketCamera");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(Play.access$100(), SENDER, 72, "HeldItemSlot", "SPacketHeldItemChange");
            public static final PacketType VIEW_CENTRE = new PacketType(Play.access$100(), SENDER, 73, "ViewCentre");
            public static final PacketType VIEW_DISTANCE = new PacketType(Play.access$100(), SENDER, 74, "ViewDistance");
            public static final PacketType SPAWN_POSITION = new PacketType(Play.access$100(), SENDER, 75, "SpawnPosition", "SPacketSpawnPosition");
            public static final PacketType SCOREBOARD_DISPLAY_OBJECTIVE = new PacketType(Play.access$100(), SENDER, 76, "ScoreboardDisplayObjective", "SPacketDisplayObjective");
            public static final PacketType ENTITY_METADATA = new PacketType(Play.access$100(), SENDER, 77, "EntityMetadata", "SPacketEntityMetadata");
            public static final PacketType ATTACH_ENTITY = new PacketType(Play.access$100(), SENDER, 78, "AttachEntity", "SPacketEntityAttach");
            public static final PacketType ENTITY_VELOCITY = new PacketType(Play.access$100(), SENDER, 79, "EntityVelocity", "SPacketEntityVelocity");
            public static final PacketType ENTITY_EQUIPMENT = new PacketType(Play.access$100(), SENDER, 80, "EntityEquipment", "SPacketEntityEquipment");
            public static final PacketType EXPERIENCE = new PacketType(Play.access$100(), SENDER, 81, "Experience", "SPacketSetExperience");
            public static final PacketType UPDATE_HEALTH = new PacketType(Play.access$100(), SENDER, 82, "UpdateHealth", "SPacketUpdateHealth");
            public static final PacketType SCOREBOARD_OBJECTIVE = new PacketType(Play.access$100(), SENDER, 83, "ScoreboardObjective", "SPacketScoreboardObjective");
            public static final PacketType MOUNT = new PacketType(Play.access$100(), SENDER, 84, "Mount", "SPacketSetPassengers");
            public static final PacketType SCOREBOARD_TEAM = new PacketType(Play.access$100(), SENDER, 85, "ScoreboardTeam", "SPacketTeams");
            public static final PacketType SCOREBOARD_SCORE = new PacketType(Play.access$100(), SENDER, 86, "ScoreboardScore", "SPacketUpdateScore");
            public static final PacketType SET_SUBTITLE_TEXT = new PacketType(Play.access$100(), SENDER, 87, "SetSubtitleText");
            public static final PacketType UPDATE_TIME = new PacketType(Play.access$100(), SENDER, 88, "UpdateTime", "SPacketTimeUpdate");
            public static final PacketType SET_TITLE_TEXT = new PacketType(Play.access$100(), SENDER, 89, "SetTitleText");
            public static final PacketType SET_TITLES_ANIMATION = new PacketType(Play.access$100(), SENDER, 90, "SetTitlesAnimation");
            public static final PacketType ENTITY_SOUND = new PacketType(Play.access$100(), SENDER, 91, "EntitySound", "SPacketSoundEffect");
            public static final PacketType NAMED_SOUND_EFFECT = new PacketType(Play.access$100(), SENDER, 92, "NamedSoundEffect");
            public static final PacketType STOP_SOUND = new PacketType(Play.access$100(), SENDER, 93, "StopSound");
            public static final PacketType PLAYER_LIST_HEADER_FOOTER = new PacketType(Play.access$100(), SENDER, 94, "PlayerListHeaderFooter", "SPacketPlayerListHeaderFooter");
            public static final PacketType NBT_QUERY = new PacketType(Play.access$100(), SENDER, 95, "NBTQuery");
            public static final PacketType COLLECT = new PacketType(Play.access$100(), SENDER, 96, "Collect", "SPacketCollectItem");
            public static final PacketType ENTITY_TELEPORT = new PacketType(Play.access$100(), SENDER, 97, "EntityTeleport", "SPacketEntityTeleport");
            public static final PacketType ADVANCEMENTS = new PacketType(Play.access$100(), SENDER, 98, "Advancements", "SPacketAdvancementInfo");
            public static final PacketType UPDATE_ATTRIBUTES = new PacketType(Play.access$100(), SENDER, 99, "UpdateAttributes", "SPacketEntityProperties");
            public static final PacketType ENTITY_EFFECT = new PacketType(Play.access$100(), SENDER, 100, "EntityEffect", "SPacketEntityEffect");
            public static final PacketType RECIPE_UPDATE = new PacketType(Play.access$100(), SENDER, 101, "RecipeUpdate");
            public static final PacketType TAGS = new PacketType(Play.access$100(), SENDER, 102, "Tags");
            @Deprecated
            public static final PacketType MAP_CHUNK_BULK = new PacketType(Play.access$100(), SENDER, 255, "MapChunkBulk");
            @Deprecated
            public static final PacketType SET_COMPRESSION = new PacketType(Play.access$100(), SENDER, 254, "SetCompression");
            @Deprecated
            public static final PacketType UPDATE_ENTITY_NBT = new PacketType(Play.access$100(), SENDER, 253, "UpdateEntityNBT");
            @Deprecated
            public static final PacketType CRAFT_PROGRESS_BAR = WINDOW_DATA.clone();
            @Deprecated
            public static final PacketType ENTITY_MOVE_LOOK = REL_ENTITY_MOVE_LOOK.clone();
            @Deprecated
            public static final PacketType STATISTICS = STATISTIC.clone();
            @Deprecated
            public static final PacketType OPEN_SIGN_ENTITY = OPEN_SIGN_EDITOR.clone();
            @Deprecated
            public static final PacketType UPDATE_SIGN = MinecraftReflection.signUpdateExists() ? new PacketType(Play.access$100(), SENDER, 252, "UpdateSign") : TILE_ENTITY_DATA.clone();
            @Deprecated
            public static final PacketType BED = new PacketType(Play.access$100(), SENDER, 251, "Bed", "SPacketUseBed");
            @Deprecated
            public static final PacketType USE_BED = BED.clone();
            @Deprecated
            public static final PacketType SPAWN_ENTITY_WEATHER = new PacketType(Play.access$100(), SENDER, 250, "SpawnEntityWeather", "SPacketSpawnGlobalEntity");
            @Deprecated
            public static final PacketType TITLE = new PacketType(Play.access$100(), SENDER, 249, "Title");
            @Deprecated
            public static final PacketType WORLD_BORDER = new PacketType(Play.access$100(), SENDER, 248, "WorldBorder");
            @Deprecated
            public static final PacketType COMBAT_EVENT = new PacketType(Play.access$100(), SENDER, 247, "CombatEvent");
            @Deprecated
            public static final PacketType TRANSACTION = new PacketType(Play.access$100(), SENDER, 246, "Transaction", "SPacketConfirmTransaction");
            @Deprecated
            public static final PacketType ENTITY = new PacketType(Play.access$100(), SENDER, 245, "Entity", "SPacketEntity");
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Status {
        private static final Protocol PROTOCOL = Protocol.STATUS;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$200() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(Status.access$200(), SENDER, 0, "Start", "CPacketServerQuery");
            public static final PacketType PING = new PacketType(Status.access$200(), SENDER, 1, "Ping", "CPacketPing");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            @ForceAsync
            public static final PacketType SERVER_INFO = new PacketType(Status.access$200(), SENDER, 0, "ServerInfo", "SPacketServerInfo");
            public static final PacketType PONG = new PacketType(Status.access$200(), SENDER, 1, "Pong", "SPacketPong");
            @Deprecated
            @ForceAsync
            public static final PacketType OUT_SERVER_INFO = SERVER_INFO.clone();
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Login {
        private static final Protocol PROTOCOL = Protocol.LOGIN;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$300() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(Login.access$300(), SENDER, 0, "Start", "CPacketLoginStart");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(Login.access$300(), SENDER, 1, "EncryptionBegin", "CPacketEncryptionResponse");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Login.access$300(), SENDER, 2, "CustomPayload", "CPacketCustomPayload");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType DISCONNECT = new PacketType(Login.access$300(), SENDER, 0, "Disconnect", "SPacketDisconnect");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(Login.access$300(), SENDER, 1, "EncryptionBegin", "SPacketEncryptionRequest");
            public static final PacketType SUCCESS = new PacketType(Login.access$300(), SENDER, 2, "Success", "SPacketLoginSuccess");
            public static final PacketType SET_COMPRESSION = new PacketType(Login.access$300(), SENDER, 3, "SetCompression", "SPacketEnableCompression");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Login.access$300(), SENDER, 4, "CustomPayload", "SPacketCustomPayload");
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static enum Sender {
        CLIENT("Serverbound", "In", "client"),
        SERVER("Clientbound", "Out", "server");

        private String mojangName;
        private String packetName;
        private String mcpName;

        private Sender(String mojangName, String packetName, String mcpName) {
            this.mojangName = mojangName;
            this.packetName = packetName;
            this.mcpName = mcpName;
        }

        public ConnectionSide toSide() {
            return this == CLIENT ? ConnectionSide.CLIENT_SIDE : ConnectionSide.SERVER_SIDE;
        }

        public String getPacketName() {
            return this.packetName;
        }

        public String getMcpPacketName() {
            return this.mcpName;
        }

        public String getMojangName() {
            return this.mojangName;
        }
    }

    public static enum Protocol {
        HANDSHAKING("Handshaking", "handshake"),
        PLAY("Play", "game"),
        STATUS("Status", "status"),
        LOGIN("Login", "login"),
        LEGACY("", "");

        private String packetName;
        private String mojangName;

        private Protocol(String packetName, String mojangName) {
            this.packetName = packetName;
            this.mojangName = mojangName;
        }

        public static Protocol fromVanilla(Enum<?> vanilla) {
            String name = vanilla.name();
            if ("HANDSHAKING".equals(name)) {
                return HANDSHAKING;
            }
            if ("PLAY".equals(name)) {
                return PLAY;
            }
            if ("STATUS".equals(name)) {
                return STATUS;
            }
            if ("LOGIN".equals(name)) {
                return LOGIN;
            }
            throw new IllegalArgumentException("Unrecognized vanilla enum " + vanilla);
        }

        public String getPacketName() {
            return this.packetName;
        }

        public String getMojangName() {
            return this.mojangName;
        }

        public String getMcpPacketName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForceAsync {
    }
}

