/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrency;

import com.comphenix.protocol.PacketType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class PacketTypeSet {
    private Set<PacketType> types = Collections.newSetFromMap(Maps.newConcurrentMap());
    private Set<Class<?>> classes = Collections.newSetFromMap(Maps.newConcurrentMap());

    public PacketTypeSet() {
    }

    public PacketTypeSet(Collection<? extends PacketType> values) {
        for (PacketType packetType : values) {
            this.addType(packetType);
        }
    }

    public synchronized void addType(PacketType type) {
        Class<?> packetClass = type.getPacketClass();
        this.types.add((PacketType)Preconditions.checkNotNull((Object)type, (Object)"type cannot be NULL."));
        if (packetClass != null) {
            this.classes.add(type.getPacketClass());
        }
    }

    public synchronized void addAll(Iterable<? extends PacketType> types) {
        for (PacketType packetType : types) {
            this.addType(packetType);
        }
    }

    public synchronized void removeType(PacketType type) {
        Class<?> packetClass = type.getPacketClass();
        this.types.remove(Preconditions.checkNotNull((Object)type, (Object)"type cannot be NULL."));
        if (packetClass != null) {
            this.classes.remove(packetClass);
        }
    }

    public synchronized void removeAll(Iterable<? extends PacketType> types) {
        for (PacketType packetType : types) {
            this.removeType(packetType);
        }
    }

    public boolean contains(PacketType type) {
        return this.types.contains(type);
    }

    public boolean contains(Class<?> packetClass) {
        return this.classes.contains(packetClass);
    }

    public boolean containsPacket(Object packet) {
        if (packet == null) {
            return false;
        }
        return this.classes.contains(packet.getClass());
    }

    public Set<PacketType> values() {
        return this.types;
    }

    public int size() {
        return this.types.size();
    }

    public synchronized void clear() {
        this.types.clear();
        this.classes.clear();
    }
}

