/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.utility.StreamSerializer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkCoordIntPair;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.comphenix.protocol.wrappers.Converters;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.MovingObjectPositionBlock;
import com.comphenix.protocol.wrappers.MultiBlockChangeInfo;
import com.comphenix.protocol.wrappers.Pair;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedEnumEntityUseAction;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedStatistic;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public abstract class AbstractStructure {
    protected transient Object handle;
    protected transient StructureModifier<Object> structureModifier;

    protected AbstractStructure() {
    }

    protected AbstractStructure(Object handle, StructureModifier<Object> modifier) {
        Validate.notNull((Object)handle, (String)"handle cannot be null");
        Validate.notNull(modifier, (String)"modifier cannot be null");
        this.handle = handle;
        this.structureModifier = modifier;
    }

    public Object getHandle() {
        return this.handle;
    }

    public StructureModifier<Object> getModifier() {
        return this.structureModifier;
    }

    public <T> StructureModifier<T> getSpecificModifier(Class<T> primitiveType) {
        return this.structureModifier.withType(primitiveType);
    }

    public StructureModifier<Byte> getBytes() {
        return this.structureModifier.withType(Byte.TYPE);
    }

    public StructureModifier<Boolean> getBooleans() {
        return this.structureModifier.withType(Boolean.TYPE);
    }

    public StructureModifier<Short> getShorts() {
        return this.structureModifier.withType(Short.TYPE);
    }

    public StructureModifier<Integer> getIntegers() {
        return this.structureModifier.withType(Integer.TYPE);
    }

    public StructureModifier<Long> getLongs() {
        return this.structureModifier.withType(Long.TYPE);
    }

    public StructureModifier<Float> getFloat() {
        return this.structureModifier.withType(Float.TYPE);
    }

    public StructureModifier<Double> getDoubles() {
        return this.structureModifier.withType(Double.TYPE);
    }

    public StructureModifier<String> getStrings() {
        return this.structureModifier.withType(String.class);
    }

    public StructureModifier<UUID> getUUIDs() {
        return this.structureModifier.withType(UUID.class);
    }

    public StructureModifier<String[]> getStringArrays() {
        return this.structureModifier.withType(String[].class);
    }

    public StructureModifier<byte[]> getByteArrays() {
        return this.structureModifier.withType(byte[].class);
    }

    public StreamSerializer getByteArraySerializer() {
        return new StreamSerializer();
    }

    public StructureModifier<int[]> getIntegerArrays() {
        return this.structureModifier.withType(int[].class);
    }

    public StructureModifier<short[]> getShortArrays() {
        return this.structureModifier.withType(short[].class);
    }

    public StructureModifier<ItemStack> getItemModifier() {
        return this.structureModifier.withType(MinecraftReflection.getItemStackClass(), BukkitConverters.getItemStackConverter());
    }

    public StructureModifier<ItemStack[]> getItemArrayModifier() {
        return this.structureModifier.withType(MinecraftReflection.getItemStackArrayClass(), Converters.ignoreNull(new ItemStackArrayConverter()));
    }

    public StructureModifier<List<ItemStack>> getItemListModifier() {
        return this.structureModifier.withType(List.class, BukkitConverters.getListConverter(BukkitConverters.getItemStackConverter()));
    }

    public StructureModifier<Map<WrappedStatistic, Integer>> getStatisticMaps() {
        return this.getMaps(BukkitConverters.getWrappedStatisticConverter(), Converters.passthrough(Integer.class));
    }

    public StructureModifier<WorldType> getWorldTypeModifier() {
        return this.structureModifier.withType(MinecraftReflection.getWorldTypeClass(), BukkitConverters.getWorldTypeConverter());
    }

    public StructureModifier<WrappedDataWatcher> getDataWatcherModifier() {
        return this.structureModifier.withType(MinecraftReflection.getDataWatcherClass(), BukkitConverters.getDataWatcherConverter());
    }

    public StructureModifier<Entity> getEntityModifier(@Nonnull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"world cannot be NULL.");
        return this.structureModifier.withType(Integer.TYPE, BukkitConverters.getEntityConverter(world));
    }

    public StructureModifier<Entity> getEntityModifier(@Nonnull PacketEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be NULL.");
        return this.getEntityModifier(event.getPlayer().getWorld());
    }

    public StructureModifier<EntityType> getEntityTypeModifier() {
        return this.structureModifier.withType(MinecraftReflection.getEntityTypes(), BukkitConverters.getEntityTypeConverter());
    }

    public StructureModifier<ChunkPosition> getPositionModifier() {
        return this.structureModifier.withType(MinecraftReflection.getChunkPositionClass(), ChunkPosition.getConverter());
    }

    public StructureModifier<BlockPosition> getBlockPositionModifier() {
        return this.structureModifier.withType(MinecraftReflection.getBlockPositionClass(), BlockPosition.getConverter());
    }

    public StructureModifier<ChunkCoordIntPair> getChunkCoordIntPairs() {
        return this.structureModifier.withType(MinecraftReflection.getChunkCoordIntPair(), ChunkCoordIntPair.getConverter());
    }

    public StructureModifier<NbtBase<?>> getNbtModifier() {
        return this.structureModifier.withType(MinecraftReflection.getNBTBaseClass(), BukkitConverters.getNbtConverter());
    }

    public StructureModifier<List<NbtBase<?>>> getListNbtModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(BukkitConverters.getNbtConverter()));
    }

    public StructureModifier<Vector> getVectors() {
        return this.structureModifier.withType(MinecraftReflection.getVec3DClass(), BukkitConverters.getVectorConverter());
    }

    public StructureModifier<List<WrappedAttribute>> getAttributeCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(BukkitConverters.getWrappedAttributeConverter()));
    }

    public StructureModifier<List<ChunkPosition>> getPositionCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(ChunkPosition.getConverter()));
    }

    public StructureModifier<List<BlockPosition>> getBlockPositionCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(BlockPosition.getConverter()));
    }

    public StructureModifier<List<WrappedWatchableObject>> getWatchableCollectionModifier() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(BukkitConverters.getWatchableObjectConverter()));
    }

    public StructureModifier<Material> getBlocks() {
        return this.structureModifier.withType(MinecraftReflection.getBlockClass(), BukkitConverters.getBlockConverter());
    }

    public StructureModifier<WrappedGameProfile> getGameProfiles() {
        return this.structureModifier.withType(MinecraftReflection.getGameProfileClass(), BukkitConverters.getWrappedGameProfileConverter());
    }

    public StructureModifier<WrappedBlockData> getBlockData() {
        return this.structureModifier.withType(MinecraftReflection.getIBlockDataClass(), BukkitConverters.getWrappedBlockDataConverter());
    }

    public StructureModifier<WrappedBlockData[]> getBlockDataArrays() {
        return this.structureModifier.withType(MinecraftReflection.getArrayClass(MinecraftReflection.getIBlockDataClass()), Converters.array(MinecraftReflection.getIBlockDataClass(), BukkitConverters.getWrappedBlockDataConverter()));
    }

    public StructureModifier<MultiBlockChangeInfo[]> getMultiBlockChangeInfoArrays() {
        ChunkCoordIntPair chunk = this.getChunkCoordIntPairs().read(0);
        return this.structureModifier.withType(MinecraftReflection.getMultiBlockChangeInfoArrayClass(), Converters.array(MinecraftReflection.getMultiBlockChangeInfoClass(), MultiBlockChangeInfo.getConverter(chunk)));
    }

    public StructureModifier<WrappedChatComponent> getChatComponents() {
        return this.structureModifier.withType(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
    }

    public StructureModifier<WrappedChatComponent[]> getChatComponentArrays() {
        return this.structureModifier.withType(ComponentArrayConverter.getGenericType(), Converters.ignoreNull(new ComponentArrayConverter()));
    }

    public StructureModifier<WrappedServerPing> getServerPings() {
        return this.structureModifier.withType(MinecraftReflection.getServerPingClass(), BukkitConverters.getWrappedServerPingConverter());
    }

    public StructureModifier<List<PlayerInfoData>> getPlayerInfoDataLists() {
        return this.structureModifier.withType(Collection.class, BukkitConverters.getListConverter(PlayerInfoData.getConverter()));
    }

    public StructureModifier<PacketType.Protocol> getProtocols() {
        return this.structureModifier.withType(EnumWrappers.getProtocolClass(), EnumWrappers.getProtocolConverter());
    }

    public StructureModifier<EnumWrappers.ClientCommand> getClientCommands() {
        return this.structureModifier.withType(EnumWrappers.getClientCommandClass(), EnumWrappers.getClientCommandConverter());
    }

    public StructureModifier<EnumWrappers.ChatVisibility> getChatVisibilities() {
        return this.structureModifier.withType(EnumWrappers.getChatVisibilityClass(), EnumWrappers.getChatVisibilityConverter());
    }

    public StructureModifier<EnumWrappers.Difficulty> getDifficulties() {
        return this.structureModifier.withType(EnumWrappers.getDifficultyClass(), EnumWrappers.getDifficultyConverter());
    }

    public StructureModifier<EnumWrappers.EntityUseAction> getEntityUseActions() {
        return this.structureModifier.withType(EnumWrappers.getEntityUseActionClass(), EnumWrappers.getEntityUseActionConverter());
    }

    public StructureModifier<WrappedEnumEntityUseAction> getEnumEntityUseActions() {
        return this.structureModifier.withType(MinecraftReflection.getEnumEntityUseActionClass(), WrappedEnumEntityUseAction.CONVERTER);
    }

    public StructureModifier<EnumWrappers.NativeGameMode> getGameModes() {
        return this.structureModifier.withType(EnumWrappers.getGameModeClass(), EnumWrappers.getGameModeConverter());
    }

    public StructureModifier<EnumWrappers.ResourcePackStatus> getResourcePackStatus() {
        return this.structureModifier.withType(EnumWrappers.getResourcePackStatusClass(), EnumWrappers.getResourcePackStatusConverter());
    }

    public StructureModifier<EnumWrappers.PlayerInfoAction> getPlayerInfoAction() {
        return this.structureModifier.withType(EnumWrappers.getPlayerInfoActionClass(), EnumWrappers.getPlayerInfoActionConverter());
    }

    public StructureModifier<EnumWrappers.TitleAction> getTitleActions() {
        return this.structureModifier.withType(EnumWrappers.getTitleActionClass(), EnumWrappers.getTitleActionConverter());
    }

    public StructureModifier<EnumWrappers.WorldBorderAction> getWorldBorderActions() {
        return this.structureModifier.withType(EnumWrappers.getWorldBorderActionClass(), EnumWrappers.getWorldBorderActionConverter());
    }

    public StructureModifier<EnumWrappers.CombatEventType> getCombatEvents() {
        return this.structureModifier.withType(EnumWrappers.getCombatEventTypeClass(), EnumWrappers.getCombatEventTypeConverter());
    }

    public StructureModifier<EnumWrappers.PlayerDigType> getPlayerDigTypes() {
        return this.structureModifier.withType(EnumWrappers.getPlayerDigTypeClass(), EnumWrappers.getPlayerDiggingActionConverter());
    }

    public StructureModifier<EnumWrappers.PlayerAction> getPlayerActions() {
        return this.structureModifier.withType(EnumWrappers.getPlayerActionClass(), EnumWrappers.getEntityActionConverter());
    }

    public StructureModifier<EnumWrappers.ScoreboardAction> getScoreboardActions() {
        return this.structureModifier.withType(EnumWrappers.getScoreboardActionClass(), EnumWrappers.getUpdateScoreActionConverter());
    }

    public StructureModifier<EnumWrappers.Particle> getParticles() {
        return this.structureModifier.withType(EnumWrappers.getParticleClass(), EnumWrappers.getParticleConverter());
    }

    public StructureModifier<WrappedParticle> getNewParticles() {
        return this.structureModifier.withType(MinecraftReflection.getParticleParam(), BukkitConverters.getParticleConverter());
    }

    public StructureModifier<PotionEffectType> getEffectTypes() {
        return this.structureModifier.withType(MinecraftReflection.getMobEffectListClass(), BukkitConverters.getEffectTypeConverter());
    }

    public StructureModifier<EnumWrappers.SoundCategory> getSoundCategories() {
        return this.structureModifier.withType(EnumWrappers.getSoundCategoryClass(), EnumWrappers.getSoundCategoryConverter());
    }

    public StructureModifier<Sound> getSoundEffects() {
        return this.structureModifier.withType(MinecraftReflection.getSoundEffectClass(), BukkitConverters.getSoundConverter());
    }

    public StructureModifier<EnumWrappers.ItemSlot> getItemSlots() {
        return this.structureModifier.withType(EnumWrappers.getItemSlotClass(), EnumWrappers.getItemSlotConverter());
    }

    public StructureModifier<EnumWrappers.Hand> getHands() {
        return this.structureModifier.withType(EnumWrappers.getHandClass(), EnumWrappers.getHandConverter());
    }

    public StructureModifier<EnumWrappers.Direction> getDirections() {
        return this.structureModifier.withType(EnumWrappers.getDirectionClass(), EnumWrappers.getDirectionConverter());
    }

    public StructureModifier<EnumWrappers.ChatType> getChatTypes() {
        return this.structureModifier.withType(EnumWrappers.getChatTypeClass(), EnumWrappers.getChatTypeConverter());
    }

    public StructureModifier<MinecraftKey> getMinecraftKeys() {
        return this.structureModifier.withType(MinecraftReflection.getMinecraftKeyClass(), MinecraftKey.getConverter());
    }

    @Deprecated
    public StructureModifier<Integer> getDimensions() {
        if (MinecraftVersion.NETHER_UPDATE.atOrAbove() && !MinecraftVersion.NETHER_UPDATE_2.atOrAbove()) {
            return this.structureModifier.withParamType(MinecraftReflection.getResourceKey(), BukkitConverters.getDimensionIDConverter(), MinecraftReflection.getDimensionManager());
        }
        return this.structureModifier.withType(MinecraftReflection.getDimensionManager(), BukkitConverters.getDimensionIDConverter());
    }

    public StructureModifier<World> getDimensionTypes() {
        return this.structureModifier.withType(MinecraftReflection.getDimensionManager(), BukkitConverters.getDimensionConverter());
    }

    public StructureModifier<List<MerchantRecipe>> getMerchantRecipeLists() {
        return this.structureModifier.withType(MinecraftReflection.getMerchantRecipeList(), BukkitConverters.getMerchantRecipeListConverter());
    }

    public StructureModifier<List<Pair<EnumWrappers.ItemSlot, ItemStack>>> getSlotStackPairLists() {
        return this.getLists(BukkitConverters.getPairConverter(EnumWrappers.getItemSlotConverter(), BukkitConverters.getItemStackConverter()));
    }

    public StructureModifier<MovingObjectPositionBlock> getMovingBlockPositions() {
        return this.structureModifier.withType(MovingObjectPositionBlock.getNmsClass(), MovingObjectPositionBlock.getConverter());
    }

    public StructureModifier<World> getWorldKeys() {
        return this.structureModifier.withParamType(MinecraftReflection.getResourceKey(), BukkitConverters.getWorldKeyConverter(), MinecraftReflection.getNmsWorldClass());
    }

    public StructureModifier<BlockPosition> getSectionPositions() {
        return this.structureModifier.withType(MinecraftReflection.getSectionPosition(), BukkitConverters.getSectionPositionConverter());
    }

    public StructureModifier<Integer> getGameStateIDs() {
        return this.structureModifier.withType(MinecraftReflection.getGameStateClass(), BukkitConverters.getGameStateConverter());
    }

    public StructureModifier<List<Integer>> getIntLists() {
        return this.structureModifier.withType(List.class, BukkitConverters.getListConverter(MinecraftReflection.getIntArrayListClass(), Converters.passthrough(Integer.TYPE)));
    }

    public <K, V> StructureModifier<Map<K, V>> getMaps(EquivalentConverter<K> keyConverter, EquivalentConverter<V> valConverter) {
        return this.structureModifier.withType(Map.class, BukkitConverters.getMapConverter(keyConverter, valConverter));
    }

    public <E> StructureModifier<Set<E>> getSets(EquivalentConverter<E> converter) {
        return this.structureModifier.withType(Set.class, BukkitConverters.getSetConverter(converter));
    }

    public <E> StructureModifier<List<E>> getLists(EquivalentConverter<E> converter) {
        return this.structureModifier.withType(List.class, BukkitConverters.getListConverter(converter));
    }

    public <T extends Enum<T>> StructureModifier<T> getEnumModifier(Class<T> enumClass, Class<?> nmsClass) {
        return this.structureModifier.withType(nmsClass, new EnumWrappers.EnumConverter<T>(nmsClass, enumClass));
    }

    public <T extends Enum<T>> StructureModifier<T> getEnumModifier(Class<T> enumClass, int index) {
        return this.getEnumModifier(enumClass, this.structureModifier.getField(index).getType());
    }

    private static class ItemStackArrayConverter
    implements EquivalentConverter<ItemStack[]> {
        final EquivalentConverter<ItemStack> stackConverter = BukkitConverters.getItemStackConverter();

        private ItemStackArrayConverter() {
        }

        @Override
        public Object getGeneric(ItemStack[] specific) {
            Class<?> nmsStack = MinecraftReflection.getItemStackClass();
            Object[] result = (Object[])Array.newInstance(nmsStack, specific.length);
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.stackConverter.getGeneric(specific[i]);
            }
            return result;
        }

        @Override
        public ItemStack[] getSpecific(Object generic) {
            Object[] input = (Object[])generic;
            ItemStack[] result = new ItemStack[input.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.stackConverter.getSpecific(input[i]);
            }
            return result;
        }

        @Override
        public Class<ItemStack[]> getSpecificType() {
            return ItemStack[].class;
        }
    }

    private static class ComponentArrayConverter
    implements EquivalentConverter<WrappedChatComponent[]> {
        private static final EquivalentConverter<WrappedChatComponent[]> DELEGATE = MinecraftReflection.signUpdateExists() ? new LegacyComponentConverter() : new NBTComponentConverter();

        private ComponentArrayConverter() {
        }

        @Override
        public WrappedChatComponent[] getSpecific(Object generic) {
            return DELEGATE.getSpecific(generic);
        }

        @Override
        public Object getGeneric(WrappedChatComponent[] specific) {
            return DELEGATE.getGeneric(specific);
        }

        @Override
        public Class<WrappedChatComponent[]> getSpecificType() {
            return DELEGATE.getSpecificType();
        }

        public static Class<?> getGenericType() {
            if (DELEGATE instanceof NBTComponentConverter) {
                return MinecraftReflection.getNBTCompoundClass();
            }
            return MinecraftReflection.getIChatBaseComponentArrayClass();
        }
    }

    private static class NBTComponentConverter
    implements EquivalentConverter<WrappedChatComponent[]> {
        private EquivalentConverter<NbtBase<?>> nbtConverter = BukkitConverters.getNbtConverter();
        private final int lines = 4;

        private NBTComponentConverter() {
        }

        @Override
        public WrappedChatComponent[] getSpecific(Object generic) {
            NbtBase<?> nbtBase = this.nbtConverter.getSpecific(generic);
            NbtCompound compound = (NbtCompound)nbtBase;
            WrappedChatComponent[] components = new WrappedChatComponent[4];
            for (int i = 0; i < 4; ++i) {
                components[i] = compound.containsKey("Text" + (i + 1)) ? WrappedChatComponent.fromJson(compound.getString("Text" + (i + 1))) : WrappedChatComponent.fromText("");
            }
            return components;
        }

        @Override
        public Object getGeneric(WrappedChatComponent[] specific) {
            NbtCompound compound = NbtFactory.ofCompound("");
            for (int i = 0; i < 4; ++i) {
                WrappedChatComponent component = i < specific.length && specific[i] != null ? specific[i] : WrappedChatComponent.fromText("");
                compound.put("Text" + (i + 1), component.getJson());
            }
            return this.nbtConverter.getGeneric(compound);
        }

        @Override
        public Class<WrappedChatComponent[]> getSpecificType() {
            return WrappedChatComponent[].class;
        }
    }

    private static class LegacyComponentConverter
    implements EquivalentConverter<WrappedChatComponent[]> {
        final EquivalentConverter<WrappedChatComponent> componentConverter = BukkitConverters.getWrappedChatComponentConverter();

        private LegacyComponentConverter() {
        }

        @Override
        public Object getGeneric(WrappedChatComponent[] specific) {
            Class<?> nmsComponent = MinecraftReflection.getIChatBaseComponentClass();
            Object[] result = (Object[])Array.newInstance(nmsComponent, specific.length);
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.componentConverter.getGeneric(specific[i]);
            }
            return result;
        }

        @Override
        public WrappedChatComponent[] getSpecific(Object generic) {
            Object[] input = (Object[])generic;
            WrappedChatComponent[] result = new WrappedChatComponent[input.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.componentConverter.getSpecific(input[i]);
            }
            return result;
        }

        @Override
        public Class<WrappedChatComponent[]> getSpecificType() {
            return WrappedChatComponent[].class;
        }
    }
}

