/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.WrappedIntHashMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

class EntityUtilities {
    private static final boolean NEW_TRACKER = MinecraftVersion.VILLAGE_UPDATE.atOrAbove();
    private static final EntityUtilities INSTANCE = new EntityUtilities();
    private FieldAccessor entityTrackerField;
    private FieldAccessor trackedEntitiesField;
    private FieldAccessor trackedPlayersField;
    private Map<Class<?>, MethodAccessor> scanPlayersMethods = new HashMap();
    private MethodAccessor getChunkProvider;
    private FieldAccessor chunkMapField;
    private Map<Class<?>, FieldAccessor> trackerFields = new ConcurrentHashMap();
    private MethodAccessor getEntityFromId;

    public static EntityUtilities getInstance() {
        return INSTANCE;
    }

    private EntityUtilities() {
    }

    public void updateEntity(Entity entity, List<Player> observers) {
        if (entity == null || !entity.isValid()) {
            return;
        }
        Collection<Object> trackedPlayers = this.getTrackedPlayers(entity);
        List<Object> nmsPlayers = this.unwrapBukkit(observers);
        trackedPlayers.removeAll(nmsPlayers);
        Object trackerEntry = this.getEntityTrackerEntry(entity.getWorld(), entity.getEntityId());
        this.scanPlayersMethods.computeIfAbsent(trackerEntry.getClass(), this::findScanPlayers).invoke(trackerEntry, nmsPlayers);
    }

    private MethodAccessor findScanPlayers(Class<?> trackerClass) {
        MethodAccessor candidate = Accessors.getMethodAcccessorOrNull(trackerClass, "scanPlayers");
        if (candidate != null) {
            return candidate;
        }
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(trackerClass, true);
        return Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().returnTypeVoid().parameterExactArray(List.class).build()));
    }

    public List<Player> getEntityTrackers(Entity entity) {
        if (entity == null || !entity.isValid()) {
            return new ArrayList<Player>();
        }
        ArrayList<Player> result = new ArrayList<Player>();
        Collection<?> trackedPlayers = this.getTrackedPlayers(entity);
        for (Object tracker : trackedPlayers) {
            if (!MinecraftReflection.isMinecraftPlayer(tracker)) continue;
            result.add((Player)MinecraftReflection.getBukkitEntity(tracker));
        }
        return result;
    }

    private Collection<?> getTrackedPlayers(Entity entity) {
        Validate.notNull((Object)entity, (String)"entity cannot be null");
        Object trackerEntry = this.getEntityTrackerEntry(entity.getWorld(), entity.getEntityId());
        Validate.notNull((Object)trackerEntry, (String)("Could not find entity trackers for " + entity));
        if (this.trackedPlayersField == null) {
            this.trackedPlayersField = Accessors.getFieldAccessor(FuzzyReflection.fromObject(trackerEntry).getFieldByType("java\\.util\\..*"));
        }
        Validate.notNull((Object)this.trackedPlayersField, (String)"Could not find trackedPlayers field");
        Object value = this.trackedPlayersField.get(trackerEntry);
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Map) {
            return ((Map)value).keySet();
        }
        throw new IllegalStateException("trackedPlayers field was an unknown type: expected Collection or Map, but got " + value.getClass());
    }

    private Object getNewEntityTracker(Object worldServer, int entityId) {
        if (this.getChunkProvider == null) {
            Class<?> chunkProviderClass = MinecraftReflection.getChunkProviderServer();
            this.getChunkProvider = Accessors.getMethodAccessor(FuzzyReflection.fromClass(worldServer.getClass(), false).getMethod(FuzzyMethodContract.newBuilder().parameterCount(0).returnTypeExact(chunkProviderClass).build()));
        }
        Object chunkProvider = this.getChunkProvider.invoke(worldServer, new Object[0]);
        if (this.chunkMapField == null) {
            Class<?> chunkMapClass = MinecraftReflection.getPlayerChunkMap();
            this.chunkMapField = Accessors.getFieldAccessor(FuzzyReflection.fromClass(chunkProvider.getClass(), false).getField(FuzzyFieldContract.newBuilder().typeExact(chunkMapClass).build()));
        }
        Object playerChunkMap = this.chunkMapField.get(chunkProvider);
        if (this.trackedEntitiesField == null) {
            this.trackedEntitiesField = MinecraftVersion.CAVES_CLIFFS_1.atOrAbove() ? Accessors.getFieldAccessor(FuzzyReflection.fromClass(playerChunkMap.getClass(), true).getField(FuzzyFieldContract.newBuilder().banModifier(8).requirePublic().typeExact(MinecraftReflection.getInt2ObjectMapClass()).build())) : Accessors.getFieldAccessor(FuzzyReflection.fromClass(playerChunkMap.getClass(), false).getField(FuzzyFieldContract.newBuilder().typeDerivedOf(Map.class).nameExact("trackedEntities").build()));
        }
        Map trackedEntities = (Map)this.trackedEntitiesField.get(playerChunkMap);
        return trackedEntities.get(entityId);
    }

    private Object getEntityTrackerEntry(World world, int entityID) {
        BukkitUnwrapper unwrapper = new BukkitUnwrapper();
        Object worldServer = unwrapper.unwrapItem(world);
        if (NEW_TRACKER) {
            return this.getNewEntityTracker(worldServer, entityID);
        }
        if (this.entityTrackerField == null) {
            this.entityTrackerField = Accessors.getFieldAccessor(FuzzyReflection.fromObject(worldServer).getFieldByType("tracker", MinecraftReflection.getEntityTrackerClass()));
        }
        Object tracker = this.entityTrackerField.get(worldServer);
        if (this.trackedEntitiesField == null) {
            this.trackedEntitiesField = Accessors.getFieldAccessor(FuzzyReflection.fromObject(tracker, false).getFieldByType("trackedEntities", MinecraftReflection.getIntHashMapClass()));
        }
        Object trackedEntities = this.trackedEntitiesField.get(tracker);
        return WrappedIntHashMap.fromHandle(trackedEntities).get(entityID);
    }

    public Entity getEntityFromID(World world, int entityID) {
        Validate.notNull((Object)world, (String)"world cannot be null");
        Validate.isTrue((entityID >= 0 ? 1 : 0) != 0, (String)"entityID cannot be negative");
        try {
            if (NEW_TRACKER) {
                Object entity;
                Object worldServer = BukkitUnwrapper.getInstance().unwrapItem(world);
                if (this.getEntityFromId == null) {
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(worldServer.getClass(), false);
                    this.getEntityFromId = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactArray(Integer.TYPE).returnTypeExact(MinecraftReflection.getEntityClass()).build()));
                }
                if ((entity = this.getEntityFromId.invoke(worldServer, entityID)) != null) {
                    return (Entity)MinecraftReflection.getBukkitEntity(entity);
                }
            }
            Object trackerEntry = this.getEntityTrackerEntry(world, entityID);
            Object tracker = null;
            if (trackerEntry != null) {
                FieldAccessor trackerField = this.trackerFields.computeIfAbsent(trackerEntry.getClass(), x -> {
                    try {
                        return Accessors.getFieldAccessor(FuzzyReflection.fromClass(trackerEntry.getClass(), true).getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getEntityClass()).build()));
                    }
                    catch (Exception ex) {
                        Class<?> trackerEntryClass = MinecraftReflection.getEntityTrackerClass();
                        return Accessors.getFieldAccessor(FuzzyReflection.fromClass(trackerEntryClass, true).getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getEntityClass()).build()));
                    }
                });
                tracker = trackerField.get(trackerEntry);
            }
            return tracker != null ? (Entity)MinecraftReflection.getBukkitEntity(tracker) : null;
        }
        catch (Exception e) {
            throw new FieldAccessException("Cannot find entity from ID " + entityID + ".", e);
        }
    }

    private List<Object> unwrapBukkit(List<Player> players) {
        ArrayList output = Lists.newArrayList();
        BukkitUnwrapper unwrapper = new BukkitUnwrapper();
        for (Player player : players) {
            Object result = unwrapper.unwrapItem(player);
            if (result != null) {
                output.add(result);
                continue;
            }
            throw new IllegalArgumentException("Cannot unwrap item " + player);
        }
        return output;
    }
}

