/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class ObjectReconstructor<T> {
    private final Class<T> clz;
    private final Field[] fields;
    private final Constructor<?> ctor;

    public ObjectReconstructor(Class<T> clz) {
        this.clz = clz;
        for (Field field : this.fields = clz.getDeclaredFields()) {
            field.setAccessible(true);
        }
        this.ctor = clz.getDeclaredConstructors()[0];
        this.ctor.setAccessible(true);
    }

    public Object[] getValues(Object instance) {
        Object[] values = new Object[this.fields.length];
        for (int idx = 0; idx < this.fields.length; ++idx) {
            try {
                values[idx] = this.fields[idx].get(instance);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access field: " + this.fields[idx].getName() + " for class: " + this.clz.getName(), e);
            }
        }
        return values;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public T reconstruct(Object[] values) {
        if (values.length != this.fields.length) {
            throw new RuntimeException("Mismatched number of arguments for class: " + this.clz.getName());
        }
        try {
            return (T)this.ctor.newInstance(values);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to reconstruct object of type: " + this.clz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to access constructor of type: " + this.clz.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke constructor of type: " + this.clz.getName(), e);
        }
    }
}

