/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.google.common.base.Objects;
import java.lang.reflect.Field;
import java.util.List;

public class ChunkCoordIntPair {
    private static Class<?> COORD_PAIR_CLASS = MinecraftReflection.getChunkCoordIntPair();
    private static ConstructorAccessor COORD_CONSTRUCTOR;
    private static FieldAccessor COORD_X;
    private static FieldAccessor COORD_Z;
    protected final int chunkX;
    protected final int chunkZ;

    public ChunkCoordIntPair(int x, int z) {
        this.chunkX = x;
        this.chunkZ = z;
    }

    public ChunkPosition getPosition(int y) {
        return new ChunkPosition((this.chunkX << 4) + 8, y, (this.chunkZ << 4) + 8);
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public static EquivalentConverter<ChunkCoordIntPair> getConverter() {
        return new EquivalentConverter<ChunkCoordIntPair>(){

            @Override
            public Object getGeneric(ChunkCoordIntPair specific) {
                if (COORD_CONSTRUCTOR == null) {
                    COORD_CONSTRUCTOR = Accessors.getConstructorAccessor(COORD_PAIR_CLASS, Integer.TYPE, Integer.TYPE);
                }
                return COORD_CONSTRUCTOR.invoke(specific.chunkX, specific.chunkZ);
            }

            @Override
            public ChunkCoordIntPair getSpecific(Object generic) {
                if (MinecraftReflection.isChunkCoordIntPair(generic)) {
                    if (COORD_X == null || COORD_Z == null) {
                        FuzzyReflection fuzzy = FuzzyReflection.fromClass(COORD_PAIR_CLASS, true);
                        List<Field> fields = fuzzy.getFieldList(FuzzyFieldContract.newBuilder().banModifier(8).typeExact(Integer.TYPE).build());
                        COORD_X = Accessors.getFieldAccessor(fields.get(0));
                        COORD_Z = Accessors.getFieldAccessor(fields.get(1));
                    }
                    return new ChunkCoordIntPair((Integer)COORD_X.get(generic), (Integer)COORD_Z.get(generic));
                }
                return null;
            }

            @Override
            public Class<ChunkCoordIntPair> getSpecificType() {
                return ChunkCoordIntPair.class;
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChunkCoordIntPair) {
            ChunkCoordIntPair other = (ChunkCoordIntPair)obj;
            return this.chunkX == other.chunkX && this.chunkZ == other.chunkZ;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.chunkX, this.chunkZ});
    }

    public String toString() {
        return "ChunkCoordIntPair [x=" + this.chunkX + ", z=" + this.chunkZ + "]";
    }
}

