/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class PlayerInfoData {
    private static Constructor<?> constructor;
    private final int latency;
    private final EnumWrappers.NativeGameMode gameMode;
    private final WrappedGameProfile profile;
    private final WrappedChatComponent displayName;

    public PlayerInfoData(WrappedGameProfile profile, int latency, EnumWrappers.NativeGameMode gameMode, WrappedChatComponent displayName) {
        this.profile = profile;
        this.latency = latency;
        this.gameMode = gameMode;
        this.displayName = displayName;
    }

    public WrappedGameProfile getProfile() {
        return this.profile;
    }

    @Deprecated
    public int getPing() {
        return this.latency;
    }

    public int getLatency() {
        return this.latency;
    }

    public EnumWrappers.NativeGameMode getGameMode() {
        return this.gameMode;
    }

    public WrappedChatComponent getDisplayName() {
        return this.displayName;
    }

    public static EquivalentConverter<PlayerInfoData> getConverter() {
        return new EquivalentConverter<PlayerInfoData>(){

            @Override
            public Object getGeneric(PlayerInfoData specific) {
                if (constructor == null) {
                    try {
                        ArrayList args = new ArrayList();
                        if (!MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                            args.add(PacketType.Play.Server.PLAYER_INFO.getPacketClass());
                        }
                        args.add(MinecraftReflection.getGameProfileClass());
                        args.add(Integer.TYPE);
                        args.add(EnumWrappers.getGameModeClass());
                        args.add(MinecraftReflection.getIChatBaseComponentClass());
                        constructor = MinecraftReflection.getPlayerInfoDataClass().getConstructor(args.toArray(new Class[0]));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find PlayerInfoData constructor.", e);
                    }
                }
                try {
                    Object displayName;
                    Object gameMode = EnumWrappers.getGameModeConverter().getGeneric(specific.gameMode);
                    Object object = displayName = specific.displayName != null ? ((PlayerInfoData)specific).displayName.handle : null;
                    if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                        return constructor.newInstance(((PlayerInfoData)specific).profile.handle, specific.latency, gameMode, displayName);
                    }
                    return constructor.newInstance(null, ((PlayerInfoData)specific).profile.handle, specific.latency, gameMode, displayName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to construct PlayerInfoData.", e);
                }
            }

            @Override
            public PlayerInfoData getSpecific(Object generic) {
                if (MinecraftReflection.isPlayerInfoData(generic)) {
                    StructureModifier modifier = new StructureModifier(generic.getClass(), null, false).withTarget(generic);
                    StructureModifier<WrappedGameProfile> gameProfiles = modifier.withType(MinecraftReflection.getGameProfileClass(), BukkitConverters.getWrappedGameProfileConverter());
                    WrappedGameProfile gameProfile = gameProfiles.read(0);
                    StructureModifier ints = modifier.withType(Integer.TYPE);
                    int latency = (Integer)ints.read(0);
                    StructureModifier<EnumWrappers.NativeGameMode> gameModes = modifier.withType(EnumWrappers.getGameModeClass(), EnumWrappers.getGameModeConverter());
                    EnumWrappers.NativeGameMode gameMode = gameModes.read(0);
                    StructureModifier<WrappedChatComponent> displayNames = modifier.withType(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
                    WrappedChatComponent displayName = displayNames.read(0);
                    return new PlayerInfoData(gameProfile, latency, gameMode, displayName);
                }
                return null;
            }

            @Override
            public Class<PlayerInfoData> getSpecificType() {
                return PlayerInfoData.class;
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PlayerInfoData) {
            PlayerInfoData other = (PlayerInfoData)obj;
            return this.profile.equals(other.profile) && this.latency == other.latency && this.gameMode == other.gameMode && this.displayName.equals(other.displayName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.latency, this.gameMode, this.profile, this.displayName});
    }

    public String toString() {
        return String.format("PlayerInfoData[latency=%s, gameMode=%s, profile=%s, displayName=%s", new Object[]{this.latency, this.gameMode, this.profile, this.displayName});
    }
}

