/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.CommandBase;
import com.comphenix.protocol.CommandFilter;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.PacketTypeParser;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.concurrency.PacketTypeSet;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.utility.ChatExtensions;
import com.comphenix.protocol.utility.HexDumper;
import com.google.common.collect.MapMaker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class CommandPacket
extends CommandBase {
    public static final ReportType REPORT_CANNOT_SEND_MESSAGE = new ReportType("Cannot send chat message.");
    public static final String NAME = "packet";
    public static final int PAGE_LINE_COUNT = 9;
    private Plugin plugin;
    private Logger logger;
    private ProtocolManager manager;
    private ChatExtensions chatter;
    private PacketTypeParser typeParser = new PacketTypeParser();
    private Map<CommandSender, List<String>> pagedMessage = new WeakHashMap<CommandSender, List<String>>();
    private PacketTypeSet packetTypes = new PacketTypeSet();
    private PacketTypeSet extendedTypes = new PacketTypeSet();
    private PacketTypeSet compareTypes = new PacketTypeSet();
    private Map<PacketEvent, String> originalPackets = new MapMaker().weakKeys().makeMap();
    private PacketListener listener;
    private PacketListener compareListener;
    private CommandFilter filter;

    public CommandPacket(ErrorReporter reporter, Plugin plugin, Logger logger, CommandFilter filter, ProtocolManager manager) {
        super(reporter, "protocol.admin", NAME, 1);
        this.plugin = plugin;
        this.logger = logger;
        this.manager = manager;
        this.filter = filter;
        this.chatter = new ChatExtensions(manager);
    }

    public void sendMessageSilently(CommandSender receiver, String message) {
        this.chatter.sendMessageSilently(receiver, message);
    }

    public void broadcastMessageSilently(String message, String permission) {
        this.chatter.broadcastMessageSilently(message, permission);
    }

    private void printPage(CommandSender sender, int pageIndex) {
        List<String> paged = this.pagedMessage.get(sender);
        if (paged != null) {
            int lastPage = (paged.size() - 1) / 9 + 1;
            for (int i = 9 * (pageIndex - 1); i < 9 * pageIndex; ++i) {
                if (i >= paged.size()) continue;
                this.sendMessageSilently(sender, " " + paged.get(i));
            }
            if (pageIndex < lastPage) {
                this.sendMessageSilently(sender, "Send /packet page " + (pageIndex + 1) + " for the next page.");
            }
        } else {
            this.sendMessageSilently(sender, ChatColor.RED + "No pages found.");
        }
    }

    @Override
    protected boolean handleCommand(CommandSender sender, String[] args) {
        try {
            ArrayDeque<String> arguments = new ArrayDeque<String>(Arrays.asList(args));
            SubCommand subCommand = this.parseCommand(arguments);
            if (subCommand == SubCommand.PAGE) {
                if (args.length <= 1) {
                    this.sendMessageSilently(sender, ChatColor.RED + "Must specify a page index.");
                    return true;
                }
                int page = Integer.parseInt(args[1]);
                if (page > 0) {
                    this.printPage(sender, page);
                } else {
                    this.sendMessageSilently(sender, ChatColor.RED + "Page index must be greater than zero.");
                }
                return true;
            }
            Set<PacketType> types = this.typeParser.parseTypes(arguments, PacketTypeParser.DEFAULT_MAX_RANGE);
            Boolean detailed = this.parseBoolean(arguments, "detailed");
            Boolean compare = this.parseBoolean(arguments, "compare");
            if (this.typeParser.getLastProtocol() == null) {
                sender.sendMessage(ChatColor.YELLOW + "Warning: Missing protocol (PLAY, etc) - assuming legacy IDs.");
            }
            if (arguments.size() > 0) {
                throw new IllegalArgumentException("Cannot parse " + arguments);
            }
            if (detailed == null) {
                detailed = false;
            }
            if (compare == null) {
                compare = false;
            } else {
                detailed = true;
            }
            if (subCommand == SubCommand.ADD) {
                if (args.length == 1) {
                    sender.sendMessage(ChatColor.RED + "Please specify a connection side.");
                    return false;
                }
                this.executeAddCommand(sender, types, detailed, compare);
            } else if (subCommand == SubCommand.REMOVE) {
                this.executeRemoveCommand(sender, types);
            } else if (subCommand == SubCommand.NAMES) {
                this.executeNamesCommand(sender, types);
            }
        }
        catch (NumberFormatException e) {
            this.sendMessageSilently(sender, ChatColor.RED + "Cannot parse number: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.sendMessageSilently(sender, ChatColor.RED + e.getMessage());
        }
        return true;
    }

    private void executeAddCommand(CommandSender sender, Set<PacketType> addition, boolean detailed, boolean compare) {
        this.packetTypes.addAll(addition);
        if (detailed) {
            this.extendedTypes.addAll(addition);
        }
        if (compare) {
            this.compareTypes.addAll(addition);
        }
        this.updatePacketListener();
        this.sendMessageSilently(sender, ChatColor.YELLOW + "Added listener " + this.getWhitelistInfo(this.listener));
    }

    private void executeRemoveCommand(CommandSender sender, Set<PacketType> removal) {
        this.packetTypes.removeAll(removal);
        this.extendedTypes.removeAll(removal);
        this.compareTypes.removeAll(removal);
        this.updatePacketListener();
        this.sendMessageSilently(sender, ChatColor.YELLOW + "Removing packet types.");
    }

    private void executeNamesCommand(CommandSender sender, Set<PacketType> types) {
        ArrayList<String> messages = new ArrayList<String>();
        for (PacketType type : types) {
            messages.add(ChatColor.YELLOW + type.toString());
        }
        if (sender instanceof Player && messages.size() > 0 && messages.size() > 9) {
            this.pagedMessage.put(sender, messages);
            this.printPage(sender, 1);
        } else {
            for (String message : messages) {
                this.sendMessageSilently(sender, message);
            }
        }
    }

    private String getWhitelistInfo(PacketListener listener) {
        boolean sendingEmpty = ListeningWhitelist.isEmpty(listener.getSendingWhitelist());
        boolean receivingEmpty = ListeningWhitelist.isEmpty(listener.getReceivingWhitelist());
        if (!sendingEmpty && !receivingEmpty) {
            return String.format("Sending: %s, Receiving: %s", listener.getSendingWhitelist(), listener.getReceivingWhitelist());
        }
        if (!sendingEmpty) {
            return listener.getSendingWhitelist().toString();
        }
        if (!receivingEmpty) {
            return listener.getReceivingWhitelist().toString();
        }
        return "[None]";
    }

    private Set<PacketType> filterTypes(Set<PacketType> types, PacketType.Sender sender) {
        HashSet<PacketType> result = new HashSet<PacketType>();
        for (PacketType type : types) {
            if (type.getSender() != sender) continue;
            result.add(type);
        }
        return result;
    }

    public PacketListener createPacketListener(Set<PacketType> type) {
        final ListeningWhitelist serverList = ListeningWhitelist.newBuilder().types(this.filterTypes(type, PacketType.Sender.SERVER)).gamePhaseBoth().monitor().build();
        final ListeningWhitelist clientList = ListeningWhitelist.newBuilder(serverList).types(this.filterTypes(type, PacketType.Sender.CLIENT)).monitor().build();
        return new PacketListener(){

            @Override
            public void onPacketSending(PacketEvent event) {
                if (CommandPacket.this.filter.filterEvent(event)) {
                    this.printInformation(event);
                }
            }

            @Override
            public void onPacketReceiving(PacketEvent event) {
                if (CommandPacket.this.filter.filterEvent(event)) {
                    this.printInformation(event);
                }
            }

            private void printInformation(PacketEvent event) {
                String verb = event.isServerPacket() ? "Sent" : "Received";
                String format = event.isServerPacket() ? "%s %s to %s" : "%s %s from %s";
                String shortDescription = String.format(format, event.isCancelled() ? "Cancelled" : verb, event.getPacketType(), event.getPlayer().getName());
                if (CommandPacket.this.extendedTypes.contains(event.getPacketType())) {
                    try {
                        String original = (String)CommandPacket.this.originalPackets.remove(event);
                        if (original != null) {
                            CommandPacket.this.logger.info("Initial packet:\n" + original + " -> ");
                        }
                        CommandPacket.this.logger.info(shortDescription + ":\n" + HexDumper.getPacketDescription(event.getPacket()));
                    }
                    catch (IllegalAccessException e) {
                        CommandPacket.this.logger.log(Level.WARNING, "Unable to use reflection.", e);
                    }
                } else {
                    CommandPacket.this.logger.info(shortDescription + ".");
                }
            }

            @Override
            public ListeningWhitelist getSendingWhitelist() {
                return serverList;
            }

            @Override
            public ListeningWhitelist getReceivingWhitelist() {
                return clientList;
            }

            @Override
            public Plugin getPlugin() {
                return CommandPacket.this.plugin;
            }
        };
    }

    public PacketListener createCompareListener(Set<PacketType> type) {
        final ListeningWhitelist serverList = ListeningWhitelist.newBuilder().types(this.filterTypes(type, PacketType.Sender.SERVER)).gamePhaseBoth().lowest().build();
        final ListeningWhitelist clientList = ListeningWhitelist.newBuilder(serverList).types(this.filterTypes(type, PacketType.Sender.CLIENT)).lowest().build();
        return new PacketListener(){

            @Override
            public void onPacketSending(PacketEvent event) {
                this.savePacketState(event);
            }

            @Override
            public void onPacketReceiving(PacketEvent event) {
                this.savePacketState(event);
            }

            private void savePacketState(PacketEvent event) {
                try {
                    CommandPacket.this.originalPackets.put(event, HexDumper.getPacketDescription(event.getPacket()));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Cannot read packet.", e);
                }
            }

            @Override
            public ListeningWhitelist getSendingWhitelist() {
                return serverList;
            }

            @Override
            public ListeningWhitelist getReceivingWhitelist() {
                return clientList;
            }

            @Override
            public Plugin getPlugin() {
                return CommandPacket.this.plugin;
            }
        };
    }

    public PacketListener updatePacketListener() {
        if (this.listener != null) {
            this.manager.removePacketListener(this.listener);
        }
        if (this.compareListener != null) {
            this.manager.removePacketListener(this.compareListener);
        }
        this.listener = this.createPacketListener(this.packetTypes.values());
        this.compareListener = this.createCompareListener(this.compareTypes.values());
        this.manager.addPacketListener(this.listener);
        this.manager.addPacketListener(this.compareListener);
        return this.listener;
    }

    private SubCommand parseCommand(Deque<String> arguments) {
        String text = arguments.remove().toLowerCase();
        switch (arguments.remove().toLowerCase()) {
            case "add": {
                return SubCommand.ADD;
            }
            case "remove": {
                return SubCommand.REMOVE;
            }
            case "names": {
                return SubCommand.NAMES;
            }
            case "page": {
                return SubCommand.PAGE;
            }
        }
        throw new IllegalArgumentException(text + " is not a valid sub command. Must be add or remove.");
    }

    private static enum SubCommand {
        ADD,
        REMOVE,
        NAMES,
        PAGE;

    }
}

