/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.net.bytebuddy.dynamic.DynamicType;
import com.comphenix.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import com.comphenix.net.bytebuddy.implementation.FixedValue;
import com.comphenix.net.bytebuddy.matcher.ElementMatchers;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.utility.ZeroBuffer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class StructureCache {
    private static final Map<Class<?>, Supplier<Object>> PACKET_INSTANCE_CREATORS = new ConcurrentHashMap();
    private static final Map<PacketType, StructureModifier<Object>> STRUCTURE_MODIFIER_CACHE = new ConcurrentHashMap<PacketType, StructureModifier<Object>>();
    private static boolean TRICK_TRIED = false;
    private static ConstructorAccessor TRICKED_DATA_SERIALIZER_BASE;
    private static ConstructorAccessor TRICKED_DATA_SERIALIZER_JSON;

    public static Object newPacket(Class<?> packetClass) {
        Supplier packetConstructor = PACKET_INSTANCE_CREATORS.computeIfAbsent(packetClass, clazz -> {
            ConstructorAccessor serializerAccessor;
            if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove() && (serializerAccessor = Accessors.getConstructorAccessorOrNull(clazz, MinecraftReflection.getPacketDataSerializerClass())) != null && StructureCache.tryInitTrickDataSerializer()) {
                try {
                    Object serializer = TRICKED_DATA_SERIALIZER_BASE.invoke(new Object[]{new ZeroBuffer()});
                    serializerAccessor.invoke(serializer);
                    return () -> serializerAccessor.invoke(serializer);
                }
                catch (Exception exception) {
                    try {
                        Object serializer = TRICKED_DATA_SERIALIZER_JSON.invoke(new Object[]{new ZeroBuffer()});
                        serializerAccessor.invoke(serializer);
                        return () -> serializerAccessor.invoke(serializer);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            return () -> {
                Object packetInstance = DefaultInstances.DEFAULT.create((Class<?>)clazz);
                Objects.requireNonNull(packetInstance, "Unable to create packet instance for class " + clazz);
                return packetInstance;
            };
        });
        return packetConstructor.get();
    }

    public static Object newPacket(PacketType type) {
        return StructureCache.newPacket(PacketRegistry.getPacketClassFromType(type));
    }

    public static StructureModifier<Object> getStructure(Class<?> packetType) {
        PacketType type = PacketRegistry.getPacketType(packetType);
        Preconditions.checkNotNull((Object)type, (Object)("No packet type associated with " + packetType));
        return StructureCache.getStructure(type);
    }

    public static StructureModifier<Object> getStructure(PacketType packetType) {
        Preconditions.checkNotNull((Object)packetType, (Object)"type cannot be null");
        return STRUCTURE_MODIFIER_CACHE.computeIfAbsent(packetType, type -> {
            Class<?> packetClass = PacketRegistry.getPacketClassFromType(type);
            return new StructureModifier(packetClass, MinecraftReflection.getPacketClass(), true);
        });
    }

    public static Object newNullDataSerializer() {
        StructureCache.tryInitTrickDataSerializer();
        return TRICKED_DATA_SERIALIZER_BASE.invoke(new Object[]{new ZeroBuffer()});
    }

    public static boolean tryInitTrickDataSerializer() {
        if (TRICK_TRIED) {
            return TRICKED_DATA_SERIALIZER_BASE != null;
        }
        TRICK_TRIED = true;
        try {
            Object textCompound = WrappedChatComponent.fromText("").getHandle();
            Object compound = Accessors.getConstructorAccessor(MinecraftReflection.getNBTCompoundClass(), new Class[0]).invoke(new Object[0]);
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition baseBuilder = ByteBuddyFactory.getInstance().createSubclass(MinecraftReflection.getPacketDataSerializerClass()).name(MinecraftMethods.class.getPackage().getName() + ".ProtocolLibTricksNmsDataSerializerBase").method(ElementMatchers.returns(MinecraftReflection.getNBTCompoundClass()).and(ElementMatchers.takesArguments(MinecraftReflection.getNBTReadLimiterClass()))).intercept(FixedValue.value(compound)).method(ElementMatchers.returns(MinecraftReflection.getIChatBaseComponentClass())).intercept(FixedValue.value(textCompound)).method(ElementMatchers.returns(PublicKey.class).and(ElementMatchers.takesNoArguments())).intercept(FixedValue.nullValue());
            Class serializerBase = baseBuilder.make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded();
            TRICKED_DATA_SERIALIZER_BASE = Accessors.getConstructorAccessor(serializerBase, ByteBuf.class);
            Class withStringIntercept = baseBuilder.name(MinecraftMethods.class.getPackage().getName() + ".ProtocolLibTricksNmsDataSerializerJson").method(ElementMatchers.returns(String.class).and(ElementMatchers.takesArguments(Integer.TYPE))).intercept(FixedValue.value("{}")).make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded();
            TRICKED_DATA_SERIALIZER_JSON = Accessors.getConstructorAccessor(withStringIntercept, ByteBuf.class);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

