/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.instances.BannedGenerator;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.reflect.instances.InstanceProvider;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class StructureModifier<T> {
    private static final DefaultInstances DEFAULT_GENERATOR = StructureModifier.getDefaultGenerator();
    private static final StructureModifier<Object> NO_OP_MODIFIER = new StructureModifier<Object>(){

        @Override
        public Object read(int fieldIndex) throws FieldAccessException {
            return null;
        }

        @Override
        public StructureModifier<Object> write(int fieldIndex, Object value) throws FieldAccessException {
            return this;
        }

        @Override
        protected FieldAccessor findFieldAccessor(int fieldIndex) {
            return null;
        }
    };
    protected Object target;
    protected Class<?> targetType;
    protected Class<?> fieldType;
    protected List<FieldAccessor> accessors = new ArrayList<FieldAccessor>();
    protected EquivalentConverter<T> converter;
    protected Map<FieldAccessor, Integer> defaultFields;
    protected Map<Class<?>, StructureModifier<?>> subtypeCache;
    protected boolean customConvertHandling;
    private static final ThreadLocal<Table<Class<?>, Class<?>, Reference<List<FieldAccessor>>>> fieldCacheLocal = ThreadLocal.withInitial(HashBasedTable::create);
    private static final Class<?> NULL_CACHE_CLASS_REPLACEMENT = Void.class;

    public StructureModifier(Class<?> targetType) {
        this(targetType, Object.class, true);
    }

    public StructureModifier(Class<?> targetType, Class<?> superclassExclude, boolean requireDefault) {
        List<FieldAccessor> fields = StructureModifier.getFields(targetType, superclassExclude);
        HashMap<FieldAccessor, Integer> defaults = requireDefault ? StructureModifier.generateDefaultFields(fields) : new HashMap<FieldAccessor, Integer>();
        this.initialize(targetType, Object.class, fields, defaults, null, new HashMap());
    }

    protected StructureModifier() {
    }

    private static DefaultInstances getDefaultGenerator() {
        ArrayList<InstanceProvider> providers = new ArrayList<InstanceProvider>();
        providers.add(new BannedGenerator(MinecraftReflection.getItemStackClass(), MinecraftReflection.getBlockClass()));
        providers.addAll((Collection<InstanceProvider>)DefaultInstances.DEFAULT.getRegistered());
        return DefaultInstances.fromCollection(providers);
    }

    private static Map<FieldAccessor, Integer> generateDefaultFields(Collection<FieldAccessor> fields) {
        int currentFieldIndex = 0;
        HashMap<FieldAccessor, Integer> requireDefaults = new HashMap<FieldAccessor, Integer>();
        for (FieldAccessor accessor : fields) {
            Object defaultInstance;
            Field field = accessor.getField();
            if (!field.getType().isPrimitive() && !Modifier.isFinal(field.getModifiers()) && (defaultInstance = DEFAULT_GENERATOR.getDefault(field.getType())) != null) {
                requireDefaults.put(accessor, currentFieldIndex);
            }
            ++currentFieldIndex;
        }
        return requireDefaults;
    }

    private static List<FieldAccessor> getFields(Class<?> type, Class<?> superclassExclude) {
        List cacheEntry;
        Class<?> superclassKey;
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be NULL.");
        }
        Table<Class<?>, Class<?>, Reference<List<FieldAccessor>>> fieldCache = fieldCacheLocal.get();
        Reference cacheEntryReference = (Reference)fieldCache.get(type, superclassKey = superclassExclude == null ? NULL_CACHE_CLASS_REPLACEMENT : superclassExclude);
        if (cacheEntryReference != null && (cacheEntry = (List)cacheEntryReference.get()) != null) {
            return cacheEntry;
        }
        List<FieldAccessor> accessors = FuzzyReflection.fromClass(type, true).getDeclaredFields(superclassExclude).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).map(Accessors::getFieldAccessor).collect(Collectors.toList());
        fieldCache.put(type, superclassKey, new SoftReference(accessors));
        fieldCache.cellSet().removeIf(entry -> ((Reference)entry.getValue()).get() == null);
        return accessors;
    }

    protected void initialize(StructureModifier<T> other) {
        this.initialize(other.targetType, other.fieldType, other.accessors, other.defaultFields, other.converter, other.subtypeCache);
    }

    protected void initialize(Class<?> targetType, Class<?> fieldType, List<FieldAccessor> data, Map<FieldAccessor, Integer> defaultFields, EquivalentConverter<T> converter, Map<Class<?>, StructureModifier<?>> subTypeCache) {
        this.targetType = targetType;
        this.fieldType = fieldType;
        this.accessors = data;
        this.defaultFields = defaultFields;
        this.converter = converter;
        this.subtypeCache = subTypeCache;
    }

    public T read(int fieldIndex) throws FieldAccessException {
        FieldAccessor accessor = this.findFieldAccessor(fieldIndex);
        if (accessor == null) {
            throw FieldAccessException.fromFormat("Field index %d is out of bounds for length %s", fieldIndex, this.accessors.size());
        }
        return this.readInternal(accessor);
    }

    public T readSafely(int fieldIndex) throws FieldAccessException {
        return this.readInternal(this.findFieldAccessor(fieldIndex));
    }

    public Optional<T> optionRead(int fieldIndex) {
        return Optional.ofNullable(this.readSafely(fieldIndex));
    }

    private T readInternal(FieldAccessor accessor) {
        if (accessor == null) {
            return null;
        }
        Object fieldValue = accessor.get(this.target);
        return (T)(this.needConversion() ? this.converter.getSpecific(fieldValue) : fieldValue);
    }

    public StructureModifier<T> write(int fieldIndex, T value) throws FieldAccessException {
        FieldAccessor accessor = this.findFieldAccessor(fieldIndex);
        if (accessor == null) {
            throw FieldAccessException.fromFormat("Field index %d is out of bounds for length %s", fieldIndex, this.accessors.size());
        }
        return this.writeInternal(accessor, value);
    }

    public StructureModifier<T> writeSafely(int fieldIndex, T value) throws FieldAccessException {
        FieldAccessor accessor = this.findFieldAccessor(fieldIndex);
        return this.writeInternal(accessor, value);
    }

    public StructureModifier<T> modify(int fieldIndex, UnaryOperator<T> select) throws FieldAccessException {
        T value = this.read(fieldIndex);
        return this.write(fieldIndex, select.apply(value));
    }

    private StructureModifier<T> writeInternal(FieldAccessor accessor, T value) throws FieldAccessException {
        if (accessor == null) {
            return this;
        }
        T fieldValue = this.needConversion() ? this.converter.getGeneric(value) : value;
        accessor.set(this.target, fieldValue);
        return this;
    }

    protected FieldAccessor findFieldAccessor(int fieldIndex) {
        if (this.target == null) {
            throw new IllegalStateException("Cannot read from modifier which has no target!");
        }
        if (fieldIndex < 0 || fieldIndex >= this.accessors.size()) {
            return null;
        }
        return this.accessors.get(fieldIndex);
    }

    private boolean needConversion() {
        return this.converter != null && !this.customConvertHandling;
    }

    public StructureModifier<T> writeDefaults() throws FieldAccessException {
        for (FieldAccessor accessor : this.defaultFields.keySet()) {
            Field field = accessor.getField();
            if (field.getType().getCanonicalName().equals("net.md_5.bungee.api.chat.BaseComponent[]")) {
                accessor.set(this.target, null);
                continue;
            }
            Object defaultValue = DEFAULT_GENERATOR.getDefault(field.getType());
            accessor.set(this.target, defaultValue);
        }
        return this;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public Object getTarget() {
        return this.target;
    }

    public int size() {
        return this.accessors.size();
    }

    public List<FieldAccessor> getFields() {
        return Collections.unmodifiableList(this.accessors);
    }

    public Field getField(int fieldIndex) {
        FieldAccessor accessor = this.findFieldAccessor(fieldIndex);
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Field index %d is out of bounds for length %s", fieldIndex, this.accessors.size()));
        }
        return accessor.getField();
    }

    public List<T> getValues() throws FieldAccessException {
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < this.size(); ++i) {
            values.add(this.readSafely(i));
        }
        return values;
    }

    public <R> StructureModifier<R> withType(Class<?> fieldType) {
        return this.withType(fieldType, null);
    }

    public <R> StructureModifier<R> withType(Class<?> fieldType, EquivalentConverter<R> converter) {
        return this.withParamType(fieldType, converter, new Class[0]);
    }

    public <R> StructureModifier<R> withParamType(Class<?> fieldType, EquivalentConverter<R> converter, Class<?> ... paramTypes) {
        if (fieldType == null) {
            return NO_OP_MODIFIER;
        }
        StructureModifier<Object> result = this.subtypeCache.get(fieldType);
        if (result == null) {
            ArrayList<FieldAccessor> fields = new ArrayList<FieldAccessor>();
            HashMap<FieldAccessor, Integer> defaults = new HashMap<FieldAccessor, Integer>();
            for (int i = 0; i < this.accessors.size(); ++i) {
                ParameterizedType parameterized;
                Type generic;
                FieldAccessor accessor = this.accessors.get(i);
                Field field = accessor.getField();
                if (!fieldType.isAssignableFrom(field.getType()) || paramTypes.length > 0 && (!((generic = field.getGenericType()) instanceof ParameterizedType) || !Arrays.equals((parameterized = (ParameterizedType)generic).getActualTypeArguments(), paramTypes))) continue;
                fields.add(accessor);
                if (!this.defaultFields.containsKey(accessor)) continue;
                defaults.put(accessor, i);
            }
            result = this.withFieldType(fieldType, fields, defaults);
            this.subtypeCache.put(fieldType, result);
        }
        result = result.withTarget(this.target);
        result.converter = converter;
        return result;
    }

    protected <V> StructureModifier<V> withFieldType(Class<?> fieldType, List<FieldAccessor> filtered, Map<FieldAccessor, Integer> defaults) {
        return this.withFieldType(fieldType, filtered, defaults, null);
    }

    protected <V> StructureModifier<V> withFieldType(Class<?> fieldType, List<FieldAccessor> filtered, Map<FieldAccessor, Integer> defaults, EquivalentConverter<V> converter) {
        StructureModifier<V> result = new StructureModifier<V>();
        result.initialize(this.targetType, fieldType, filtered, defaults, converter, new HashMap());
        return result;
    }

    public StructureModifier<T> withTarget(Object target) {
        StructureModifier<T> copy = new StructureModifier<T>();
        copy.initialize(this);
        copy.target = target;
        return copy;
    }

    private <V> StructureModifier<V> withConverter(EquivalentConverter<V> converter) {
        StructureModifier<V> copy = this.withTarget(this.target);
        copy.setConverter(converter);
        return copy;
    }

    protected void setConverter(EquivalentConverter<T> converter) {
        this.converter = converter;
    }

    public String toString() {
        return "StructureModifier[fieldType=" + this.fieldType + ", data=" + this.accessors + "]";
    }
}

