/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import java.util.Collections;
import java.util.Map;

@FunctionalInterface
public interface ClassSource {
    public static ClassSource fromClassLoader() {
        return ClassSource.fromClassLoader(ClassSource.class.getClassLoader());
    }

    public static ClassSource fromPackage(String packageName) {
        return ClassSource.fromClassLoader().usingPackage(packageName);
    }

    public static ClassSource fromClassLoader(ClassLoader loader) {
        return loader::loadClass;
    }

    public static ClassSource fromMap(Map<String, Class<?>> map) {
        return canonicalName -> {
            Class loaded;
            Class clazz = loaded = map == null ? null : (Class)map.get(canonicalName);
            if (loaded == null) {
                throw new ClassNotFoundException("The specified class could not be found by this ClassLoader.");
            }
            return loaded;
        };
    }

    public static ClassSource empty() {
        return ClassSource.fromMap(Collections.emptyMap());
    }

    public static String append(String a, String b) {
        boolean left = a.endsWith(".");
        boolean right = b.endsWith(".");
        if (left && right) {
            return a.substring(0, a.length() - 1) + b;
        }
        if (left != right) {
            return a + b;
        }
        return a + "." + b;
    }

    default public ClassSource retry(ClassSource other) {
        return canonicalName -> {
            try {
                return this.loadClass(canonicalName);
            }
            catch (ClassNotFoundException e) {
                return other.loadClass(canonicalName);
            }
        };
    }

    default public ClassSource usingPackage(String packageName) {
        return canonicalName -> this.loadClass(ClassSource.append(packageName, canonicalName));
    }

    public Class<?> loadClass(String var1) throws ClassNotFoundException;
}

