/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyClassContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.CachedPackage;
import com.comphenix.protocol.utility.ClassSource;
import com.comphenix.protocol.utility.MinecraftFields;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.EnumWrappers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class MinecraftReflection {
    private static final ClassSource CLASS_SOURCE = ClassSource.fromClassLoader();
    private static final String CANONICAL_REGEX = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String MINECRAFT_CLASS_NAME_REGEX = "net\\.minecraft\\.(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern PACKAGE_VERSION_MATCHER = Pattern.compile(".*\\.(v\\d+_\\d+_\\w*\\d+)");
    private static final Map<Class<?>, MethodAccessor> BUKKIT_ENTITY_CACHE = new HashMap();
    private static final String FORGE_ENTITY_PACKAGE = "net.minecraft.entity";
    static CachedPackage minecraftPackage;
    static CachedPackage craftbukkitPackage;
    static CachedPackage libraryPackage;
    private static String DYNAMIC_PACKAGE_MATCHER;
    private static String MINECRAFT_PREFIX_PACKAGE;
    private static String MINECRAFT_FULL_PACKAGE;
    private static String CRAFTBUKKIT_PACKAGE;
    private static AbstractFuzzyMatcher<Class<?>> fuzzyMatcher;
    private static String packageVersion;
    private static Class<?> itemStackArrayClass;
    private static Boolean cachedWatcherObject;
    private static Object itemStackAir;
    private static Boolean nullEnforced;
    private static MethodAccessor asNMSCopy;
    private static MethodAccessor asCraftMirror;
    private static MethodAccessor isEmpty;

    private MinecraftReflection() {
    }

    public static String getMinecraftObjectRegex() {
        if (DYNAMIC_PACKAGE_MATCHER == null) {
            MinecraftReflection.getMinecraftPackage();
        }
        return DYNAMIC_PACKAGE_MATCHER;
    }

    public static AbstractFuzzyMatcher<Class<?>> getMinecraftObjectMatcher() {
        if (fuzzyMatcher == null) {
            fuzzyMatcher = FuzzyMatchers.matchRegex(MinecraftReflection.getMinecraftObjectRegex());
        }
        return fuzzyMatcher;
    }

    public static String getMinecraftPackage() {
        if (MINECRAFT_FULL_PACKAGE != null) {
            return MINECRAFT_FULL_PACKAGE;
        }
        try {
            Server craftServer = Bukkit.getServer();
            CRAFTBUKKIT_PACKAGE = craftServer.getClass().getPackage().getName();
            Matcher packageMatcher = PACKAGE_VERSION_MATCHER.matcher(CRAFTBUKKIT_PACKAGE);
            if (packageMatcher.matches()) {
                packageVersion = packageMatcher.group(1);
            } else {
                MinecraftVersion version = new MinecraftVersion(craftServer);
                packageVersion = "v" + version.getMajor() + "_" + version.getMinor() + "_R1";
                ProtocolLogger.log(Level.SEVERE, "Assuming package version: " + packageVersion, new Object[0]);
            }
            if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                MINECRAFT_PREFIX_PACKAGE = "net.minecraft";
                MINECRAFT_FULL_PACKAGE = "net.minecraft";
                MinecraftReflection.setDynamicPackageMatcher(MINECRAFT_CLASS_NAME_REGEX);
            } else {
                Method getHandle = MinecraftReflection.getCraftEntityClass().getMethod("getHandle", new Class[0]);
                MINECRAFT_FULL_PACKAGE = getHandle.getReturnType().getPackage().getName();
                if (!MINECRAFT_FULL_PACKAGE.startsWith(MINECRAFT_PREFIX_PACKAGE)) {
                    if (MINECRAFT_FULL_PACKAGE.equals(FORGE_ENTITY_PACKAGE)) {
                        MINECRAFT_FULL_PACKAGE = CachedPackage.combine(MINECRAFT_PREFIX_PACKAGE, packageVersion);
                    } else {
                        MINECRAFT_PREFIX_PACKAGE = MINECRAFT_FULL_PACKAGE;
                    }
                    String matcher = (MINECRAFT_PREFIX_PACKAGE.length() > 0 ? Pattern.quote(MINECRAFT_PREFIX_PACKAGE + ".") : "") + CANONICAL_REGEX;
                    MinecraftReflection.setDynamicPackageMatcher("(" + matcher + ")|(" + MINECRAFT_CLASS_NAME_REGEX + ")");
                } else {
                    MinecraftReflection.setDynamicPackageMatcher(MINECRAFT_CLASS_NAME_REGEX);
                }
            }
            return MINECRAFT_FULL_PACKAGE;
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Cannot find getHandle() in CraftEntity", exception);
        }
    }

    public static String getPackageVersion() {
        MinecraftReflection.getMinecraftPackage();
        return packageVersion;
    }

    private static void setDynamicPackageMatcher(String regex) {
        DYNAMIC_PACKAGE_MATCHER = regex;
        fuzzyMatcher = null;
    }

    static void setMinecraftPackage(String minecraftPackage, String craftBukkitPackage) {
        MINECRAFT_FULL_PACKAGE = minecraftPackage;
        CRAFTBUKKIT_PACKAGE = craftBukkitPackage;
        if (MinecraftReflection.getMinecraftServerClass() == null) {
            throw new IllegalArgumentException("Cannot find MinecraftServer for package " + minecraftPackage);
        }
        MinecraftReflection.setDynamicPackageMatcher(MINECRAFT_CLASS_NAME_REGEX);
    }

    public static String getCraftBukkitPackage() {
        if (CRAFTBUKKIT_PACKAGE == null) {
            MinecraftReflection.getMinecraftPackage();
        }
        return CRAFTBUKKIT_PACKAGE;
    }

    public static Object getBukkitEntity(Object nmsObject) {
        if (nmsObject == null) {
            return null;
        }
        try {
            MethodAccessor created;
            Class<?> clazz = nmsObject.getClass();
            MethodAccessor accessor = BUKKIT_ENTITY_CACHE.get(clazz);
            if (accessor == null && (accessor = BUKKIT_ENTITY_CACHE.putIfAbsent(clazz, created = Accessors.getMethodAccessor(clazz, "getBukkitEntity", new Class[0]))) == null) {
                accessor = created;
            }
            return accessor.invoke(nmsObject, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot get Bukkit entity from " + nmsObject, e);
        }
    }

    public static Player getBukkitPlayerFromConnection(Object playerConnection) {
        try {
            return (Player)MinecraftReflection.getBukkitEntity(MinecraftFields.getPlayerFromConnection(playerConnection));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot get Bukkit entity from connection " + playerConnection, e);
        }
    }

    public static boolean isMinecraftObject(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().getName().startsWith(MINECRAFT_PREFIX_PACKAGE);
    }

    public static boolean isMinecraftClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be NULL.");
        }
        return MinecraftReflection.getMinecraftObjectMatcher().isMatch(clazz, null);
    }

    public static boolean isMinecraftObject(Object obj, String className) {
        if (obj == null) {
            return false;
        }
        String javaName = obj.getClass().getName();
        return javaName.startsWith(MINECRAFT_PREFIX_PACKAGE) && javaName.endsWith(className);
    }

    public static boolean is(Class<?> clazz, Object object) {
        if (clazz == null || object == null) {
            return false;
        }
        return clazz.isAssignableFrom(object.getClass());
    }

    public static boolean is(Class<?> clazz, Class<?> test) {
        if (clazz == null || test == null) {
            return false;
        }
        return clazz.isAssignableFrom(test);
    }

    public static boolean isBlockPosition(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getBlockPositionClass(), obj);
    }

    public static boolean isChunkCoordIntPair(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getChunkCoordIntPair(), obj);
    }

    public static boolean isPacketClass(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getPacketClass(), obj);
    }

    public static boolean isServerHandler(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getPlayerConnectionClass(), obj);
    }

    public static boolean isMinecraftEntity(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getEntityClass(), obj);
    }

    public static boolean isItemStack(Object value) {
        return MinecraftReflection.is(MinecraftReflection.getItemStackClass(), value);
    }

    public static boolean isCraftPlayer(Object value) {
        return MinecraftReflection.is(MinecraftReflection.getCraftPlayerClass(), value);
    }

    public static boolean isMinecraftPlayer(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getEntityPlayerClass(), obj);
    }

    public static boolean isDataWatcher(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getDataWatcherClass(), obj);
    }

    public static boolean isIntHashMap(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getIntHashMapClass(), obj);
    }

    public static boolean isCraftItemStack(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getCraftItemStackClass(), obj);
    }

    public static Class<?> getEntityPlayerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("server.level.EntityPlayer", "server.level.ServerPlayer", "EntityPlayer");
        }
        catch (RuntimeException e) {
            try {
                Method getHandle = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass("entity.CraftPlayer")).getMethodByName("getHandle");
                return MinecraftReflection.setMinecraftClass("EntityPlayer", getHandle.getReturnType());
            }
            catch (IllegalArgumentException e1) {
                throw new RuntimeException("Could not find EntityPlayer class.", e1);
            }
        }
    }

    public static Class<?> getEntityHumanClass() {
        return MinecraftReflection.getEntityPlayerClass().getSuperclass();
    }

    public static Class<?> getGameProfileClass() {
        return MinecraftReflection.getClass("com.mojang.authlib.GameProfile");
    }

    public static Class<?> getEntityClass() {
        try {
            return MinecraftReflection.getMinecraftClass("world.entity.Entity", "Entity");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.fallbackMethodReturn("Entity", "entity.CraftEntity", "getHandle");
        }
    }

    public static Class<?> getCraftChatMessage() {
        return MinecraftReflection.getCraftBukkitClass("util.CraftChatMessage");
    }

    public static Class<?> getWorldServerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("server.level.WorldServer", "server.level.ServerLevel", "WorldServer");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.fallbackMethodReturn("WorldServer", "CraftWorld", "getHandle");
        }
    }

    public static Class<?> getNmsWorldClass() {
        try {
            return MinecraftReflection.getMinecraftClass("world.level.World", "world.level.Level", "World");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.setMinecraftClass("World", MinecraftReflection.getWorldServerClass().getSuperclass());
        }
    }

    private static Class<?> fallbackMethodReturn(String nmsClass, String craftClass, String methodName) {
        Class<?> result = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass(craftClass)).getMethodByName(methodName).getReturnType();
        return MinecraftReflection.setMinecraftClass(nmsClass, result);
    }

    public static Class<?> getPacketClass() {
        return MinecraftReflection.getMinecraftClass("network.protocol.Packet", "Packet");
    }

    public static Class<?> getByteBufClass() {
        return MinecraftReflection.getClass("io.netty.buffer.ByteBuf");
    }

    public static Class<?> getEnumProtocolClass() {
        return MinecraftReflection.getMinecraftClass("network.EnumProtocol", "network.ConnectionProtocol", "EnumProtocol");
    }

    public static Class<?> getIChatBaseComponentClass() {
        return MinecraftReflection.getMinecraftClass("network.chat.IChatBaseComponent", "network.chat.IChatbaseComponent", "network.chat.Component", "IChatBaseComponent");
    }

    public static Class<?> getIChatBaseComponentArrayClass() {
        return MinecraftReflection.getArrayClass(MinecraftReflection.getIChatBaseComponentClass());
    }

    public static Class<?> getChatComponentTextClass() {
        return MinecraftReflection.getMinecraftClass("network.chat.ChatComponentText", "network.chat.TextComponent", "ChatComponentText");
    }

    public static Class<?> getChatSerializerClass() {
        return MinecraftReflection.getMinecraftClass("network.chat.IChatBaseComponent$ChatSerializer", "network.chat.Component$Serializer", "IChatBaseComponent$ChatSerializer");
    }

    public static Class<?> getServerPingClass() {
        return MinecraftReflection.getMinecraftClass("network.protocol.status.ServerPing", "network.protocol.status.ServerStatus", "ServerPing");
    }

    public static Class<?> getServerPingServerDataClass() {
        return MinecraftReflection.getMinecraftClass("network.protocol.status.ServerPing$ServerData", "network.protocol.status.ServerStatus$Version", "ServerPing$ServerData");
    }

    public static Class<?> getServerPingPlayerSampleClass() {
        return MinecraftReflection.getMinecraftClass("network.protocol.status.ServerPing$ServerPingPlayerSample", "network.protocol.status.ServerStatus$Players", "ServerPing$ServerPingPlayerSample");
    }

    public static Class<?> getMinecraftServerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("server.MinecraftServer", "MinecraftServer");
        }
        catch (RuntimeException e) {
            MinecraftReflection.setMinecraftClass("MinecraftServer", null);
            MinecraftReflection.useFallbackServer();
            return MinecraftReflection.getMinecraftClass("MinecraftServer");
        }
    }

    public static Class<?> getStatisticClass() {
        return MinecraftReflection.getMinecraftClass("stats.Statistic", "stats.Stat", "Statistic");
    }

    public static Class<?> getStatisticListClass() {
        return MinecraftReflection.getMinecraftClass("stats.StatisticList", "stats.Stats", "StatisticList");
    }

    public static Class<?> getPlayerListClass() {
        try {
            return MinecraftReflection.getMinecraftClass("server.players.PlayerList", "PlayerList");
        }
        catch (RuntimeException e) {
            MinecraftReflection.setMinecraftClass("PlayerList", null);
            MinecraftReflection.useFallbackServer();
            return MinecraftReflection.getMinecraftClass("PlayerList");
        }
    }

    public static Class<?> getPlayerConnectionClass() {
        return MinecraftReflection.getMinecraftClass("server.network.PlayerConnection", "server.network.ServerGamePacketListenerImpl", "PlayerConnection");
    }

    public static Class<?> getNetworkManagerClass() {
        return MinecraftReflection.getMinecraftClass("network.NetworkManager", "network.Connection", "NetworkManager");
    }

    public static Class<?> getItemStackClass() {
        try {
            return MinecraftReflection.getMinecraftClass("world.item.ItemStack", "ItemStack");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.setMinecraftClass("ItemStack", FuzzyReflection.fromClass(MinecraftReflection.getCraftItemStackClass(), true).getFieldByName("handle").getType());
        }
    }

    public static Class<?> getBlockClass() {
        return MinecraftReflection.getMinecraftClass("world.level.block.Block", "Block");
    }

    public static Class<?> getItemClass() {
        return MinecraftReflection.getNullableNMS("world.item.Item", "Item");
    }

    public static Class<?> getFluidTypeClass() {
        return MinecraftReflection.getNullableNMS("world.level.material.FluidType", "world.level.material.Fluid", "FluidType");
    }

    public static Class<?> getParticleTypeClass() {
        return MinecraftReflection.getNullableNMS("core.particles.ParticleType", "core.particles.SimpleParticleType", "ParticleType");
    }

    public static Class<?> getWorldTypeClass() {
        return MinecraftReflection.getMinecraftClass("WorldType");
    }

    public static Class<?> getDataWatcherClass() {
        return MinecraftReflection.getMinecraftClass("network.syncher.DataWatcher", "network.syncher.SynchedEntityData", "DataWatcher");
    }

    public static Class<?> getBlockPositionClass() {
        return MinecraftReflection.getMinecraftClass("core.BlockPosition", "core.BlockPos", "BlockPosition");
    }

    public static Class<?> getVec3DClass() {
        return MinecraftReflection.getMinecraftClass("world.phys.Vec3D", "world.phys.Vec3", "Vec3D");
    }

    public static Class<?> getChunkCoordIntPair() {
        return MinecraftReflection.getMinecraftClass("world.level.ChunkCoordIntPair", "world.level.ChunkPos", "ChunkCoordIntPair");
    }

    public static Class<?> getDataWatcherItemClass() {
        return MinecraftReflection.getMinecraftClass("network.syncher.DataWatcher$Item", "network.syncher.SynchedEntityData$DataItem", "DataWatcher$Item", "DataWatcher$WatchableObject");
    }

    public static Class<?> getDataWatcherObjectClass() {
        return MinecraftReflection.getNullableNMS("network.syncher.DataWatcherObject", "network.syncher.EntityDataAccessor", "DataWatcherObject");
    }

    public static boolean watcherObjectExists() {
        if (cachedWatcherObject == null) {
            cachedWatcherObject = MinecraftReflection.getDataWatcherObjectClass() != null;
        }
        return cachedWatcherObject;
    }

    public static Class<?> getDataWatcherSerializerClass() {
        return MinecraftReflection.getNullableNMS("network.syncher.DataWatcherSerializer", "network.syncher.EntityDataSerializer", "DataWatcherSerializer");
    }

    public static Class<?> getDataWatcherRegistryClass() {
        return MinecraftReflection.getMinecraftClass("network.syncher.DataWatcherRegistry", "network.syncher.EntityDataSerializers", "DataWatcherRegistry");
    }

    public static Class<?> getMinecraftKeyClass() {
        return MinecraftReflection.getMinecraftClass("resources.MinecraftKey", "resources.ResourceLocation", "MinecraftKey");
    }

    public static Class<?> getMobEffectListClass() {
        return MinecraftReflection.getMinecraftClass("world.effect.MobEffectList", "MobEffectList", "world.effect.MobEffect");
    }

    public static Class<?> getSoundEffectClass() {
        return MinecraftReflection.getNullableNMS("sounds.SoundEffect", "sounds.SoundEvent", "SoundEffect");
    }

    public static Class<?> getServerConnectionClass() {
        return MinecraftReflection.getMinecraftClass("server.network.ServerConnection", "server.network.ServerConnectionListener", "ServerConnection");
    }

    public static Class<?> getNBTBaseClass() {
        return MinecraftReflection.getMinecraftClass("nbt.NBTBase", "nbt.Tag", "NBTBase");
    }

    public static Class<?> getNBTReadLimiterClass() {
        return MinecraftReflection.getMinecraftClass("nbt.NBTReadLimiter", "nbt.NbtAccounter", "NBTReadLimiter");
    }

    public static Class<?> getNBTCompoundClass() {
        return MinecraftReflection.getMinecraftClass("nbt.NBTTagCompound", "nbt.CompoundTag", "NBTTagCompound");
    }

    public static Class<?> getEntityTrackerClass() {
        return MinecraftReflection.getMinecraftClass("server.level.PlayerChunkMap$EntityTracker", "server.level.ChunkMap$TrackedEntity", "EntityTracker");
    }

    public static Class<?> getAttributeSnapshotClass() {
        return MinecraftReflection.getMinecraftClass("network.protocol.game.PacketPlayOutUpdateAttributes$AttributeSnapshot", "network.protocol.game.ClientboundUpdateAttributesPacket$AttributeSnapshot", "AttributeSnapshot", "PacketPlayOutUpdateAttributes$AttributeSnapshot");
    }

    public static Class<?> getIntHashMapClass() {
        return MinecraftReflection.getNullableNMS("IntHashMap", new String[0]);
    }

    public static Class<?> getAttributeModifierClass() {
        return MinecraftReflection.getMinecraftClass("world.entity.ai.attributes.AttributeModifier", "AttributeModifier");
    }

    public static Class<?> getMobEffectClass() {
        return MinecraftReflection.getMinecraftClass("world.effect.MobEffect", "world.effect.MobEffectInstance", "MobEffect");
    }

    public static Class<?> getPacketDataSerializerClass() {
        return MinecraftReflection.getMinecraftClass("network.PacketDataSerializer", "network.FriendlyByteBuf", "PacketDataSerializer");
    }

    public static Class<?> getNbtCompressedStreamToolsClass() {
        return MinecraftReflection.getMinecraftClass("nbt.NBTCompressedStreamTools", "nbt.NbtIo", "NBTCompressedStreamTools");
    }

    public static Class<?> getTileEntityClass() {
        return MinecraftReflection.getMinecraftClass("world.level.block.entity.TileEntity", "world.level.block.entity.BlockEntity", "TileEntity");
    }

    public static Class<?> getMinecraftGsonClass() {
        return MinecraftReflection.getMinecraftLibraryClass("com.google.gson.Gson");
    }

    public static Class<?> getItemStackArrayClass() {
        if (itemStackArrayClass == null) {
            itemStackArrayClass = MinecraftReflection.getArrayClass(MinecraftReflection.getItemStackClass());
        }
        return itemStackArrayClass;
    }

    public static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Class<?> getCraftItemStackClass() {
        return MinecraftReflection.getCraftBukkitClass("inventory.CraftItemStack");
    }

    public static Class<?> getCraftPlayerClass() {
        return MinecraftReflection.getCraftBukkitClass("entity.CraftPlayer");
    }

    public static Class<?> getCraftWorldClass() {
        return MinecraftReflection.getCraftBukkitClass("CraftWorld");
    }

    public static Class<?> getCraftEntityClass() {
        return MinecraftReflection.getCraftBukkitClass("entity.CraftEntity");
    }

    public static Class<?> getCraftMessageClass() {
        return MinecraftReflection.getCraftBukkitClass("util.CraftChatMessage");
    }

    public static Class<?> getPlayerInfoDataClass() {
        try {
            return MinecraftReflection.getMinecraftClass("network.protocol.game.PacketPlayOutPlayerInfo$PlayerInfoData", "network.protocol.game.ClientboundPlayerInfoPacket$PlayerUpdate", "PacketPlayOutPlayerInfo$PlayerInfoData", "PlayerInfoData");
        }
        catch (Exception ex) {
            return MinecraftReflection.setMinecraftClass("network.protocol.game.PacketPlayOutPlayerInfo$PlayerInfoData", PacketType.Play.Server.PLAYER_INFO.getPacketClass().getClasses()[0]);
        }
    }

    public static Class<?> getEnumEntityUseActionClass() {
        Class<?> packetClass = PacketType.Play.Client.USE_ENTITY.getPacketClass();
        FuzzyReflection fuzzyReflection = FuzzyReflection.fromClass(packetClass, true);
        try {
            return fuzzyReflection.getFieldByType("^.*(EnumEntityUseAction)").getType();
        }
        catch (IllegalArgumentException ignored) {
            return fuzzyReflection.getFieldByType("^.*(Action)").getType();
        }
    }

    public static MethodAccessor getEntityUseActionEnumMethodAccessor() {
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(MinecraftReflection.getEnumEntityUseActionClass(), true);
        return Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().returnTypeExact(EnumWrappers.getEntityUseActionClass()).build()));
    }

    public static FieldAccessor getHandEntityUseActionEnumFieldAccessor(Object enumEntityUseAction) {
        FuzzyReflection fuzzy = FuzzyReflection.fromObject(enumEntityUseAction, true);
        return Accessors.getFieldAccessor(fuzzy.getField(FuzzyFieldContract.newBuilder().typeExact(EnumWrappers.getHandClass()).build()));
    }

    public static FieldAccessor getVec3EntityUseActionEnumFieldAccessor(Object enumEntityUseAction) {
        FuzzyReflection fuzzy = FuzzyReflection.fromObject(enumEntityUseAction, true);
        return Accessors.getFieldAccessor(fuzzy.getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getVec3DClass()).build()));
    }

    public static boolean isPlayerInfoData(Object obj) {
        return MinecraftReflection.is(MinecraftReflection.getPlayerInfoDataClass(), obj);
    }

    public static Class<?> getIBlockDataClass() {
        return MinecraftReflection.getMinecraftClass("world.level.block.state.IBlockData", "world.level.block.state.BlockState", "IBlockData");
    }

    public static Class<?> getMultiBlockChangeInfoClass() {
        return MinecraftReflection.getMinecraftClass("MultiBlockChangeInfo", "PacketPlayOutMultiBlockChange$MultiBlockChangeInfo");
    }

    public static Class<?> getMultiBlockChangeInfoArrayClass() {
        return MinecraftReflection.getArrayClass(MinecraftReflection.getMultiBlockChangeInfoClass());
    }

    public static Class<?> getGameStateClass() {
        Class<?> packetClass = PacketType.Play.Server.GAME_STATE_CHANGE.getPacketClass();
        return packetClass.getClasses()[0];
    }

    public static boolean signUpdateExists() {
        return MinecraftReflection.getNullableNMS("PacketPlayOutUpdateSign", new String[0]) != null;
    }

    public static Class<?> getNonNullListClass() {
        return MinecraftReflection.getMinecraftClass("core.NonNullList", "NonNullList");
    }

    public static MethodAccessor getNonNullListCreateAccessor() {
        try {
            Class<?> nonNullListType = MinecraftReflection.getNonNullListClass();
            Method method = FuzzyReflection.fromClass(nonNullListType).getMethod(FuzzyMethodContract.newBuilder().returnTypeExact(nonNullListType).requireModifier(8).build());
            return Accessors.getMethodAccessor(method);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Class<?> getCraftSoundClass() {
        return MinecraftReflection.getCraftBukkitClass("CraftSound");
    }

    public static Class<?> getSectionPositionClass() {
        return MinecraftReflection.getMinecraftClass("core.SectionPosition", "core.SectionPos", "SectionPosition");
    }

    public static ItemStack getBukkitItemStack(Object generic) {
        if (generic == null) {
            return new ItemStack(Material.AIR);
        }
        if (generic instanceof ItemStack) {
            ItemStack bukkit = (ItemStack)generic;
            if (MinecraftReflection.is(MinecraftReflection.getCraftItemStackClass(), generic)) {
                return bukkit;
            }
            Object nmsStack = MinecraftReflection.getMinecraftItemStack(bukkit);
            return MinecraftReflection.getBukkitItemStack(nmsStack);
        }
        if (!MinecraftReflection.is(MinecraftReflection.getItemStackClass(), generic)) {
            throw new IllegalArgumentException(generic + " is not an ItemStack!");
        }
        try {
            if (nullEnforced == null) {
                isEmpty = Accessors.getMethodAccessor(MinecraftReflection.getItemStackClass().getMethod("isEmpty", new Class[0]));
                nullEnforced = true;
            }
            if (nullEnforced.booleanValue() && ((Boolean)isEmpty.invoke(generic, new Object[0])).booleanValue()) {
                return new ItemStack(Material.AIR);
            }
        }
        catch (ReflectiveOperationException ex) {
            nullEnforced = false;
        }
        if (asCraftMirror == null) {
            try {
                Method asMirrorMethod = MinecraftReflection.getCraftItemStackClass().getMethod("asCraftMirror", MinecraftReflection.getItemStackClass());
                asCraftMirror = Accessors.getMethodAccessor(asMirrorMethod);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to obtain CraftItemStack.asCraftMirror", ex);
            }
        }
        try {
            return (ItemStack)asCraftMirror.invoke(nullEnforced, generic);
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException("Failed to obtain craft mirror of " + generic, ex);
        }
    }

    public static Object getMinecraftItemStack(ItemStack specific) {
        if (asNMSCopy == null) {
            try {
                Method asNmsCopyMethod = MinecraftReflection.getCraftItemStackClass().getMethod("asNMSCopy", ItemStack.class);
                asNMSCopy = Accessors.getMethodAccessor(asNmsCopyMethod);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to obtain CraftItemStack.asNMSCopy", ex);
            }
        }
        if (MinecraftReflection.is(MinecraftReflection.getCraftItemStackClass(), specific)) {
            Object unwrapped = BukkitUnwrapper.getInstance().unwrapItem(specific);
            if (unwrapped != null) {
                return unwrapped;
            }
            if (itemStackAir == null) {
                itemStackAir = MinecraftReflection.getMinecraftItemStack(new ItemStack(Material.AIR));
            }
            return itemStackAir;
        }
        try {
            return asNMSCopy.invoke(null, specific);
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException("Failed to make NMS copy of " + specific, ex);
        }
    }

    private static Class<?> getClass(String className) {
        try {
            return MinecraftReflection.getClassSource().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find class " + className, e);
        }
    }

    public static Class<?> getCraftBukkitClass(String className) {
        if (craftbukkitPackage == null) {
            craftbukkitPackage = new CachedPackage(MinecraftReflection.getCraftBukkitPackage(), MinecraftReflection.getClassSource());
        }
        return craftbukkitPackage.getPackageClass(className).orElseThrow(() -> new RuntimeException("Failed to find CraftBukkit class: " + className));
    }

    public static Class<?> getMinecraftClass(String className) {
        if (minecraftPackage == null) {
            minecraftPackage = new CachedPackage(MinecraftReflection.getMinecraftPackage(), MinecraftReflection.getClassSource());
        }
        return minecraftPackage.getPackageClass(className).orElseThrow(() -> new RuntimeException("Failed to find NMS class: " + className));
    }

    public static Class<?> getNullableNMS(String className, String ... aliases) {
        try {
            return MinecraftReflection.getMinecraftClass(className, aliases);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private static Class<?> setMinecraftClass(String className, Class<?> clazz) {
        if (minecraftPackage == null) {
            minecraftPackage = new CachedPackage(MinecraftReflection.getMinecraftPackage(), MinecraftReflection.getClassSource());
        }
        minecraftPackage.setPackageClass(className, clazz);
        return clazz;
    }

    private static ClassSource getClassSource() {
        return CLASS_SOURCE;
    }

    public static Class<?> getMinecraftClass(String className, String ... aliases) {
        if (minecraftPackage == null) {
            minecraftPackage = new CachedPackage(MinecraftReflection.getMinecraftPackage(), MinecraftReflection.getClassSource());
        }
        return minecraftPackage.getPackageClass(className).orElseGet(() -> {
            String alias;
            Class resolved = null;
            String[] stringArray = aliases;
            int n = stringArray.length;
            for (int i = 0; i < n && (resolved = (Class)minecraftPackage.getPackageClass(alias = stringArray[i]).orElse(null)) == null; ++i) {
            }
            if (resolved != null) {
                minecraftPackage.setPackageClass(className, resolved);
                return resolved;
            }
            throw new RuntimeException(String.format("Unable to find %s (%s)", className, String.join((CharSequence)", ", aliases)));
        });
    }

    public static Class<?> getMinecraftLibraryClass(String className) {
        if (libraryPackage == null) {
            libraryPackage = new CachedPackage("", MinecraftReflection.getClassSource());
        }
        return libraryPackage.getPackageClass(className).orElseThrow(() -> new RuntimeException("Failed to find class: " + className));
    }

    private static Class<?> setMinecraftLibraryClass(String className, Class<?> clazz) {
        if (libraryPackage == null) {
            libraryPackage = new CachedPackage("", MinecraftReflection.getClassSource());
        }
        libraryPackage.setPackageClass(className, clazz);
        return clazz;
    }

    public static String getNetworkManagerName() {
        return MinecraftReflection.getNetworkManagerClass().getSimpleName();
    }

    public static Object getPacketDataSerializer(Object buffer) {
        try {
            Class<?> packetSerializer = MinecraftReflection.getPacketDataSerializerClass();
            return packetSerializer.getConstructor(MinecraftReflection.getByteBufClass()).newInstance(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct packet serializer.", e);
        }
    }

    public static Object createPacketDataSerializer(int initialSize) {
        if (initialSize <= 0) {
            initialSize = 256;
        }
        ByteBuf buffer = Unpooled.buffer((int)initialSize);
        return MinecraftReflection.getPacketDataSerializer(buffer);
    }

    public static Class<?> getNbtTagTypes() {
        return MinecraftReflection.getMinecraftClass("nbt.NBTTagTypes", "nbt.TagTypes", "NBTTagTypes");
    }

    public static Class<?> getChatDeserializer() {
        return MinecraftReflection.getMinecraftClass("util.ChatDeserializer", "util.GsonHelper", "ChatDeserializer");
    }

    public static Class<?> getChatMutableComponentClass() {
        return MinecraftReflection.getMinecraftClass("network.chat.IChatMutableComponent", "network.chat.MutableComponent");
    }

    public static Class<?> getDimensionManager() {
        return MinecraftReflection.getMinecraftClass("world.level.dimension.DimensionManager", "world.level.dimension.DimensionType", "DimensionManager");
    }

    public static Class<?> getMerchantRecipeList() {
        return MinecraftReflection.getMinecraftClass("world.item.trading.MerchantRecipeList", "world.item.trading.MerchantOffers", "MerchantRecipeList");
    }

    public static Class<?> getResourceKey() {
        return MinecraftReflection.getMinecraftClass("resources.ResourceKey", "ResourceKey");
    }

    public static Class<?> getEntityTypes() {
        return MinecraftReflection.getMinecraftClass("world.entity.EntityTypes", "world.entity.EntityType", "EntityTypes");
    }

    public static Class<?> getParticleParam() {
        return MinecraftReflection.getMinecraftClass("core.particles.ParticleParam", "core.particles.ParticleOptions", "ParticleParam");
    }

    public static Class<?> getSectionPosition() {
        return MinecraftReflection.getMinecraftClass("core.SectionPosition", "core.SectionPos", "SectionPosition");
    }

    public static Class<?> getChunkProviderServer() {
        return MinecraftReflection.getMinecraftClass("server.level.ChunkProviderServer", "server.level.ServerChunkCache", "ChunkProviderServer");
    }

    public static Class<?> getPlayerChunkMap() {
        return MinecraftReflection.getMinecraftClass("server.level.PlayerChunkMap", "server.level.ChunkMap", "PlayerChunkMap");
    }

    public static Class<?> getIRegistry() {
        return MinecraftReflection.getNullableNMS("core.IRegistry", "core.Registry", "IRegistry");
    }

    public static Class<?> getBuiltInRegistries() {
        return MinecraftReflection.getNullableNMS("core.registries.BuiltInRegistries", new String[0]);
    }

    public static Class<?> getAttributeBase() {
        return MinecraftReflection.getMinecraftClass("world.entity.ai.attributes.AttributeBase", "world.entity.ai.attributes.Attribute", "AttributeBase");
    }

    public static Class<?> getProfilePublicKeyClass() {
        return MinecraftReflection.getMinecraftClass("world.entity.player.ProfilePublicKey");
    }

    public static Class<?> getSaltedSignatureClass() {
        try {
            return MinecraftReflection.getMinecraftClass("SaltedSignature");
        }
        catch (RuntimeException runtimeException) {
            Class<?> minecraftEncryption = MinecraftReflection.getMinecraftClass("util.MinecraftEncryption", "util.Crypt", "MinecraftEncryption");
            FuzzyMethodContract constructorContract = FuzzyMethodContract.newBuilder().parameterCount(2).parameterExactType(Long.TYPE, 0).parameterExactType(byte[].class, 1).build();
            for (Class<?> subclass : minecraftEncryption.getClasses()) {
                FuzzyReflection fuzzyReflection = FuzzyReflection.fromClass(subclass, true);
                List<Constructor<?>> constructors = fuzzyReflection.getConstructorList(constructorContract);
                if (constructors.isEmpty()) continue;
                return MinecraftReflection.setMinecraftClass("SaltedSignature", subclass);
            }
            Class<?> messageSigClass = MinecraftReflection.getMinecraftClass("network.chat.MessageSignature", "MessageSignature");
            FuzzyClassContract signatureContract = FuzzyClassContract.newBuilder().constructor(FuzzyMethodContract.newBuilder().parameterCount(2).parameterSuperOf(Long.TYPE, 0).parameterSuperOf(byte[].class, 1).build()).build();
            FuzzyFieldContract fuzzyFieldContract = FuzzyFieldContract.newBuilder().typeMatches(MinecraftReflection.getMinecraftObjectMatcher().and(signatureContract)).build();
            Class<?> signatureClass = FuzzyReflection.fromClass(messageSigClass, true).getField(fuzzyFieldContract).getType();
            return MinecraftReflection.setMinecraftClass("SaltedSignature", signatureClass);
        }
    }

    public static Class<?> getProfilePublicKeyDataClass() {
        return MinecraftReflection.getProfilePublicKeyClass().getClasses()[0];
    }

    public static Class<?> getRemoteChatSessionClass() {
        return MinecraftReflection.getMinecraftClass("network.chat.RemoteChatSession");
    }

    public static Class<?> getFastUtilClass(String className) {
        return MinecraftReflection.getLibraryClass("it.unimi.dsi.fastutil." + className);
    }

    public static Class<?> getInt2ObjectMapClass() {
        return MinecraftReflection.getFastUtilClass("ints.Int2ObjectMap");
    }

    public static Class<?> getIntArrayListClass() {
        return MinecraftReflection.getFastUtilClass("ints.IntArrayList");
    }

    public static Class<?> getLibraryClass(String classname) {
        try {
            return MinecraftReflection.getMinecraftLibraryClass(classname);
        }
        catch (RuntimeException ex) {
            Class<?> clazz = MinecraftReflection.getMinecraftLibraryClass("org.bukkit.craftbukkit.libs." + classname);
            MinecraftReflection.setMinecraftLibraryClass(classname, clazz);
            return clazz;
        }
    }

    private static void useFallbackServer() {
        Constructor<?> selected = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass("CraftServer")).getConstructor(FuzzyMethodContract.newBuilder().parameterMatches(MinecraftReflection.getMinecraftObjectMatcher(), 0).parameterCount(2).build());
        Class<?>[] params = selected.getParameterTypes();
        MinecraftReflection.setMinecraftClass("MinecraftServer", params[0]);
        MinecraftReflection.setMinecraftClass("PlayerList", params[1]);
    }

    public static Class<?> getLevelChunkPacketDataClass() {
        return MinecraftReflection.getNullableNMS("network.protocol.game.ClientboundLevelChunkPacketData", new String[0]);
    }

    public static Class<?> getLightUpdatePacketDataClass() {
        return MinecraftReflection.getNullableNMS("network.protocol.game.ClientboundLightUpdatePacketData", new String[0]);
    }

    public static Class<?> getBlockEntityTypeClass() {
        return MinecraftReflection.getMinecraftClass("world.level.block.entity.BlockEntityType", "world.level.block.entity.TileEntityTypes", "TileEntityTypes");
    }

    public static Class<?> getBlockEntityInfoClass() {
        try {
            return MinecraftReflection.getMinecraftClass("BlockEntityInfo");
        }
        catch (RuntimeException expected) {
            Class infoClass = (Class)((ParameterizedType)FuzzyReflection.fromClass(MinecraftReflection.getLevelChunkPacketDataClass(), true).getFieldListByType(List.class).get(0).getGenericType()).getActualTypeArguments()[0];
            MinecraftReflection.setMinecraftClass("BlockEntityInfo", infoClass);
            return infoClass;
        }
    }

    public static Class<?> getHolderClass() {
        return MinecraftReflection.getMinecraftClass("core.Holder");
    }

    static {
        DYNAMIC_PACKAGE_MATCHER = null;
        MINECRAFT_PREFIX_PACKAGE = "net.minecraft.server";
        MINECRAFT_FULL_PACKAGE = null;
        CRAFTBUKKIT_PACKAGE = null;
        itemStackAir = null;
        nullEnforced = null;
        asNMSCopy = null;
        asCraftMirror = null;
        isEmpty = null;
    }
}

