/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.base.Defaults;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AutoWrapper<T>
implements EquivalentConverter<T> {
    private static final Object[] NO_ARGS = new Object[0];
    private Map<Integer, Function<Object, Object>> wrappers = new HashMap<Integer, Function<Object, Object>>();
    private Map<Integer, Function<Object, Object>> unwrappers = new HashMap<Integer, Function<Object, Object>>();
    private FieldAccessor[] nmsAccessors;
    private FieldAccessor[] wrapperAccessors;
    private Object[] nmsDefaultArgs;
    private ConstructorAccessor nmsInstanceCreator;
    private Class<T> wrapperClass;
    private Class<?> nmsClass;

    private AutoWrapper(Class<T> wrapperClass, Class<?> nmsClass) {
        this.wrapperClass = wrapperClass;
        this.nmsClass = nmsClass;
    }

    public static <T> AutoWrapper<T> wrap(Class<T> wrapperClass, Class<?> nmsClass) {
        return new AutoWrapper<T>(wrapperClass, nmsClass);
    }

    public static <T> AutoWrapper<T> wrap(Class<T> wrapperClass, String nmsClassName) {
        return AutoWrapper.wrap(wrapperClass, MinecraftReflection.getMinecraftClass(nmsClassName));
    }

    public static <T> AutoWrapper<T> wrap(Class<T> wrapperClass, String nmsClassName, String ... aliases) {
        return AutoWrapper.wrap(wrapperClass, MinecraftReflection.getMinecraftClass(nmsClassName, aliases));
    }

    public AutoWrapper<T> field(int index, Function<Object, Object> wrapper, Function<Object, Object> unwrapper) {
        this.wrappers.put(index, wrapper);
        this.unwrappers.put(index, unwrapper);
        return this;
    }

    public AutoWrapper<T> field(int index, EquivalentConverter converter) {
        return this.field(index, converter::getSpecific, specific -> converter.getGeneric(specific));
    }

    public T wrap(Object nmsObject) {
        T instance;
        try {
            instance = this.wrapperClass.newInstance();
        }
        catch (ReflectiveOperationException ex) {
            throw new InvalidWrapperException(this.wrapperClass.getSimpleName() + " is not accessible!", ex);
        }
        this.computeFieldAccessors();
        for (int i = 0; i < this.wrapperAccessors.length; ++i) {
            FieldAccessor source = this.nmsAccessors[i];
            FieldAccessor target = this.wrapperAccessors[i];
            Object value = source.get(nmsObject);
            if (this.wrappers.containsKey(i)) {
                value = this.wrappers.get(i).apply(value);
            }
            target.set(instance, value);
        }
        return instance;
    }

    public Object unwrap(Object wrapper) {
        this.computeFieldAccessors();
        this.computeNmsConstructorAccess();
        Object instance = this.nmsInstanceCreator.invoke(this.nmsDefaultArgs);
        for (int i = 0; i < this.wrapperAccessors.length; ++i) {
            FieldAccessor source = this.wrapperAccessors[i];
            FieldAccessor target = this.nmsAccessors[i];
            Object value = source.get(wrapper);
            if (this.unwrappers.containsKey(i)) {
                value = this.unwrappers.get(i).apply(value);
            }
            target.set(instance, value);
        }
        return instance;
    }

    private void computeFieldAccessors() {
        if (this.nmsAccessors == null) {
            this.nmsAccessors = (FieldAccessor[])Arrays.stream(this.nmsClass.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).map(field -> Accessors.getFieldAccessor(field)).toArray(FieldAccessor[]::new);
        }
        if (this.wrapperAccessors == null) {
            this.wrapperAccessors = (FieldAccessor[])Arrays.stream(this.wrapperClass.getDeclaredFields()).map(field -> Accessors.getFieldAccessor(field)).toArray(FieldAccessor[]::new);
        }
    }

    private void computeNmsConstructorAccess() {
        if (this.nmsInstanceCreator == null) {
            ConstructorAccessor noArgs = Accessors.getConstructorAccessorOrNull(this.nmsClass, new Class[0]);
            if (noArgs != null) {
                this.nmsInstanceCreator = noArgs;
                this.nmsDefaultArgs = NO_ARGS;
            } else {
                this.nmsInstanceCreator = Accessors.getConstructorAccessor(this.nmsClass.getDeclaredConstructors()[0]);
                this.nmsDefaultArgs = Arrays.stream(this.nmsInstanceCreator.getConstructor().getParameterTypes()).map(type -> type.isPrimitive() ? Defaults.defaultValue((Class)type) : null).toArray(Object[]::new);
            }
        }
    }

    @Override
    public T getSpecific(Object generic) {
        return this.wrap(generic);
    }

    @Override
    public Object getGeneric(Object specific) {
        return this.unwrap(specific);
    }

    @Override
    public Class<T> getSpecificType() {
        return this.wrapperClass;
    }

    public static class InvalidWrapperException
    extends RuntimeException {
        private InvalidWrapperException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

