/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedProfilePublicKey;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;

public class PlayerInfoData {
    private static Constructor<?> constructor;
    private final UUID profileId;
    private final int latency;
    private final boolean listed;
    private final EnumWrappers.NativeGameMode gameMode;
    private final WrappedGameProfile profile;
    private final WrappedChatComponent displayName;
    private final WrappedProfilePublicKey.WrappedProfileKeyData profileKeyData;

    public PlayerInfoData(WrappedGameProfile profile, int latency, EnumWrappers.NativeGameMode gameMode, WrappedChatComponent displayName) {
        this(profile, latency, gameMode, displayName, null);
    }

    public PlayerInfoData(WrappedGameProfile profile, int latency, EnumWrappers.NativeGameMode gameMode, WrappedChatComponent displayName, WrappedProfilePublicKey.WrappedProfileKeyData keyData) {
        this(profile.getUUID(), latency, true, gameMode, profile, displayName, keyData);
    }

    public PlayerInfoData(UUID profileId, int latency, boolean listed, EnumWrappers.NativeGameMode gameMode, WrappedGameProfile profile, WrappedChatComponent displayName, WrappedProfilePublicKey.WrappedProfileKeyData profileKeyData) {
        this.profileId = profileId;
        this.latency = latency;
        this.listed = listed;
        this.gameMode = gameMode;
        this.profile = profile;
        this.displayName = displayName;
        this.profileKeyData = profileKeyData;
    }

    public UUID getProfileId() {
        return this.profileId;
    }

    public WrappedGameProfile getProfile() {
        return this.profile;
    }

    @Deprecated
    public int getPing() {
        return this.latency;
    }

    public int getLatency() {
        return this.latency;
    }

    public boolean isListed() {
        return this.listed;
    }

    public EnumWrappers.NativeGameMode getGameMode() {
        return this.gameMode;
    }

    public WrappedChatComponent getDisplayName() {
        return this.displayName;
    }

    public WrappedProfilePublicKey.WrappedProfileKeyData getProfileKeyData() {
        return this.profileKeyData;
    }

    public static EquivalentConverter<PlayerInfoData> getConverter() {
        return new EquivalentConverter<PlayerInfoData>(){

            @Override
            public Object getGeneric(PlayerInfoData specific) {
                if (constructor == null) {
                    try {
                        ArrayList args = new ArrayList();
                        if (!MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                            args.add(PacketType.Play.Server.PLAYER_INFO.getPacketClass());
                        }
                        if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                            args.add(UUID.class);
                        }
                        args.add(MinecraftReflection.getGameProfileClass());
                        if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                            args.add(Boolean.TYPE);
                        }
                        args.add(Integer.TYPE);
                        args.add(EnumWrappers.getGameModeClass());
                        args.add(MinecraftReflection.getIChatBaseComponentClass());
                        if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                            args.add(MinecraftReflection.getRemoteChatSessionClass().getClasses()[0]);
                        } else if (MinecraftVersion.WILD_UPDATE.atOrAbove()) {
                            args.add(MinecraftReflection.getProfilePublicKeyDataClass());
                        }
                        constructor = MinecraftReflection.getPlayerInfoDataClass().getConstructor(args.toArray(new Class[0]));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find PlayerInfoData constructor.", e);
                    }
                }
                try {
                    Object displayName;
                    Object gameMode = EnumWrappers.getGameModeConverter().getGeneric(specific.gameMode);
                    Object object = displayName = specific.displayName != null ? ((PlayerInfoData)specific).displayName.handle : null;
                    if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                        return constructor.newInstance(specific.profileId, ((PlayerInfoData)specific).profile.handle, specific.listed, specific.latency, gameMode, displayName, null);
                    }
                    if (MinecraftVersion.WILD_UPDATE.atOrAbove()) {
                        return constructor.newInstance(((PlayerInfoData)specific).profile.handle, specific.latency, gameMode, displayName, specific.profileKeyData == null ? null : ((PlayerInfoData)specific).profileKeyData.handle);
                    }
                    if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                        return constructor.newInstance(((PlayerInfoData)specific).profile.handle, specific.latency, gameMode, displayName);
                    }
                    return constructor.newInstance(null, ((PlayerInfoData)specific).profile.handle, specific.latency, gameMode, displayName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to construct PlayerInfoData.", e);
                }
            }

            @Override
            public PlayerInfoData getSpecific(Object generic) {
                if (MinecraftReflection.isPlayerInfoData(generic)) {
                    StructureModifier modifier = new StructureModifier(generic.getClass(), null, false).withTarget(generic);
                    StructureModifier<WrappedGameProfile> gameProfiles = modifier.withType(MinecraftReflection.getGameProfileClass(), BukkitConverters.getWrappedGameProfileConverter());
                    WrappedGameProfile gameProfile = gameProfiles.read(0);
                    StructureModifier ints = modifier.withType(Integer.TYPE);
                    int latency = (Integer)ints.read(0);
                    StructureModifier<EnumWrappers.NativeGameMode> gameModes = modifier.withType(EnumWrappers.getGameModeClass(), EnumWrappers.getGameModeConverter());
                    EnumWrappers.NativeGameMode gameMode = gameModes.read(0);
                    StructureModifier<WrappedChatComponent> displayNames = modifier.withType(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
                    WrappedChatComponent displayName = displayNames.read(0);
                    WrappedProfilePublicKey.WrappedProfileKeyData key = null;
                    if (MinecraftVersion.WILD_UPDATE.atOrAbove() && !MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                        StructureModifier<WrappedProfilePublicKey.WrappedProfileKeyData> keyData = modifier.withType(MinecraftReflection.getProfilePublicKeyDataClass(), BukkitConverters.getWrappedPublicKeyDataConverter());
                        key = keyData.read(0);
                    }
                    return new PlayerInfoData(gameProfile, latency, gameMode, displayName, key);
                }
                return null;
            }

            @Override
            public Class<PlayerInfoData> getSpecificType() {
                return PlayerInfoData.class;
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PlayerInfoData) {
            PlayerInfoData other = (PlayerInfoData)obj;
            return this.profile.equals(other.profile) && this.latency == other.latency && this.gameMode == other.gameMode && Objects.equals(this.displayName, other.displayName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.latency, this.gameMode, this.profile, this.displayName});
    }

    public String toString() {
        return String.format("PlayerInfoData[latency=%s, gameMode=%s, profile=%s, displayName=%s]", new Object[]{this.latency, this.gameMode, this.profile, this.displayName});
    }
}

