/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WrappedRegistry {
    private static final Map<Class<?>, WrappedRegistry> REGISTRY;
    private static final MethodAccessor GET;
    private static final MethodAccessor GET_ID;
    private static final MethodAccessor GET_KEY;
    private static final MethodAccessor GET_HOLDER;
    private final Object handle;

    private WrappedRegistry(Object handle) {
        this.handle = handle;
    }

    public Object get(MinecraftKey key) {
        return GET.invoke(this.handle, MinecraftKey.getConverter().getGeneric(key));
    }

    public Object get(String key) {
        return this.get(new MinecraftKey(key));
    }

    public MinecraftKey getKey(Object generic) {
        return MinecraftKey.getConverter().getSpecific(GET_KEY.invoke(this.handle, generic));
    }

    public int getId(MinecraftKey key) {
        return this.getId(this.get(key));
    }

    public int getId(String key) {
        return this.getId(new MinecraftKey(key));
    }

    public int getId(Object entry) {
        return (Integer)GET_ID.invoke(this.handle, entry);
    }

    public Object getHolder(Object generic) {
        return GET_HOLDER.invoke(this.handle, generic);
    }

    public static WrappedRegistry getAttributeRegistry() {
        return WrappedRegistry.getRegistry(MinecraftReflection.getAttributeBase());
    }

    public static WrappedRegistry getDimensionRegistry() {
        return WrappedRegistry.getRegistry(MinecraftReflection.getDimensionManager());
    }

    public static WrappedRegistry getSoundRegistry() {
        return WrappedRegistry.getRegistry(MinecraftReflection.getSoundEffectClass());
    }

    public static WrappedRegistry getRegistry(Class<?> type) {
        return REGISTRY.get(type);
    }

    static {
        MethodAccessor getHolder;
        HashMap<Class, WrappedRegistry> regMap = new HashMap<Class, WrappedRegistry>();
        Class<?> iRegistry = MinecraftReflection.getIRegistry();
        Class<?> builtInRegistries = MinecraftReflection.getBuiltInRegistries();
        Set<Field> registries = FuzzyReflection.combineArrays(iRegistry == null ? null : iRegistry.getFields(), builtInRegistries == null ? null : builtInRegistries.getFields());
        if (iRegistry != null && !registries.isEmpty()) {
            for (Field field : registries) {
                try {
                    WildcardType wildcard;
                    Type genType;
                    if (!iRegistry.isAssignableFrom(field.getType()) || !((genType = field.getGenericType()) instanceof ParameterizedType)) continue;
                    ParameterizedType par = (ParameterizedType)genType;
                    Type paramType = par.getActualTypeArguments()[0];
                    if (paramType instanceof Class) {
                        regMap.put((Class)paramType, new WrappedRegistry(field.get(null)));
                        continue;
                    }
                    if (!(paramType instanceof ParameterizedType) || (paramType = (par = (ParameterizedType)paramType).getActualTypeArguments()[0]) instanceof WildcardType && ((wildcard = (WildcardType)paramType).getUpperBounds().length != 1 || wildcard.getLowerBounds().length > 0 || wildcard.getUpperBounds()[0] != Object.class) || !((paramType = par.getRawType()) instanceof Class)) continue;
                    regMap.put((Class)paramType, new WrappedRegistry(field.get(null)));
                }
                catch (ReflectiveOperationException genType) {}
            }
        }
        REGISTRY = ImmutableMap.copyOf(regMap);
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(iRegistry, false);
        GET = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).returnDerivedOf(Object.class).requireModifier(1024).parameterExactType(MinecraftReflection.getMinecraftKeyClass()).build()));
        GET_ID = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).returnTypeExact(Integer.TYPE).requireModifier(1024).parameterDerivedOf(Object.class).build()));
        GET_KEY = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).returnTypeExact(MinecraftReflection.getMinecraftKeyClass()).build()));
        try {
            getHolder = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).banModifier(8).returnTypeExact(MinecraftReflection.getHolderClass()).requireModifier(1).build()));
        }
        catch (IllegalArgumentException ignored) {
            getHolder = null;
        }
        GET_HOLDER = getHolder;
    }
}

