/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftProtocolVersion;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ClonableWrapper;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class WrappedServerPing
extends AbstractWrapper
implements ClonableWrapper {
    private static Class<?> GAME_PROFILE = MinecraftReflection.getGameProfileClass();
    private static Class<?> GAME_PROFILE_ARRAY = MinecraftReflection.getArrayClass(GAME_PROFILE);
    private static Class<?> SERVER_PING = MinecraftReflection.getServerPingClass();
    private static ConstructorAccessor SERVER_PING_CONSTRUCTOR = Accessors.getConstructorAccessor(SERVER_PING, new Class[0]);
    private static FieldAccessor DESCRIPTION = Accessors.getFieldAccessor(SERVER_PING, MinecraftReflection.getIChatBaseComponentClass(), true);
    private static FieldAccessor PLAYERS = Accessors.getFieldAccessor(SERVER_PING, MinecraftReflection.getServerPingPlayerSampleClass(), true);
    private static FieldAccessor VERSION = Accessors.getFieldAccessor(SERVER_PING, MinecraftReflection.getServerPingServerDataClass(), true);
    private static FieldAccessor FAVICON = Accessors.getFieldAccessor(SERVER_PING, String.class, true);
    private static FieldAccessor[] BOOLEAN_ACCESSORS = Accessors.getFieldAccessorArray(SERVER_PING, Boolean.TYPE, true);
    private static EquivalentConverter<Iterable<? extends WrappedGameProfile>> PROFILE_CONVERT = BukkitConverters.getArrayConverter(GAME_PROFILE, BukkitConverters.getWrappedGameProfileConverter());
    private static Class<?> PLAYERS_CLASS = MinecraftReflection.getServerPingPlayerSampleClass();
    private static ConstructorAccessor PLAYERS_CONSTRUCTOR = Accessors.getConstructorAccessor(PLAYERS_CLASS, Integer.TYPE, Integer.TYPE);
    private static FieldAccessor[] PLAYERS_INTS = Accessors.getFieldAccessorArray(PLAYERS_CLASS, Integer.TYPE, true);
    private static FieldAccessor PLAYERS_PROFILES = Accessors.getFieldAccessor(PLAYERS_CLASS, GAME_PROFILE_ARRAY, true);
    private static FieldAccessor PLAYERS_MAXIMUM = PLAYERS_INTS[0];
    private static FieldAccessor PLAYERS_ONLINE = PLAYERS_INTS[1];
    private static Class<?> GSON_CLASS = MinecraftReflection.getMinecraftGsonClass();
    private static MethodAccessor GSON_TO_JSON = Accessors.getMethodAccessor(GSON_CLASS, "toJson", Object.class);
    private static MethodAccessor GSON_FROM_JSON = Accessors.getMethodAccessor(GSON_CLASS, "fromJson", String.class, Class.class);
    private static FieldAccessor PING_GSON = Accessors.getMemorizing(Accessors.getFieldAccessor(PacketType.Status.Server.SERVER_INFO.getPacketClass(), GSON_CLASS, true));
    private static Class<?> VERSION_CLASS = MinecraftReflection.getServerPingServerDataClass();
    private static ConstructorAccessor VERSION_CONSTRUCTOR = Accessors.getConstructorAccessor(VERSION_CLASS, String.class, Integer.TYPE);
    private static FieldAccessor VERSION_NAME = Accessors.getFieldAccessor(VERSION_CLASS, String.class, true);
    private static FieldAccessor VERSION_PROTOCOL = Accessors.getFieldAccessor(VERSION_CLASS, Integer.TYPE, true);
    private static FieldAccessor ENTITY_HUMAN_PROFILE = Accessors.getFieldAccessor(MinecraftReflection.getEntityPlayerClass().getSuperclass(), GAME_PROFILE, true);
    private Object players;
    private Object version;

    public WrappedServerPing() {
        super(MinecraftReflection.getServerPingClass());
        this.setHandle(SERVER_PING_CONSTRUCTOR.invoke(new Object[0]));
        this.resetPlayers();
        this.resetVersion();
    }

    private WrappedServerPing(Object handle) {
        super(MinecraftReflection.getServerPingClass());
        this.setHandle(handle);
        this.players = PLAYERS.get(handle);
        this.version = VERSION.get(handle);
    }

    protected void resetPlayers() {
        this.players = PLAYERS_CONSTRUCTOR.invoke(0, 0);
        PLAYERS.set(this.handle, this.players);
    }

    protected void resetVersion() {
        MinecraftVersion minecraftVersion = MinecraftVersion.getCurrentVersion();
        this.version = VERSION_CONSTRUCTOR.invoke(minecraftVersion.toString(), MinecraftProtocolVersion.getCurrentVersion());
        VERSION.set(this.handle, this.version);
    }

    public static WrappedServerPing fromHandle(Object handle) {
        return new WrappedServerPing(handle);
    }

    public static WrappedServerPing fromJson(String json) {
        return WrappedServerPing.fromHandle(GSON_FROM_JSON.invoke(PING_GSON.get(null), json, SERVER_PING));
    }

    public WrappedChatComponent getMotD() {
        return WrappedChatComponent.fromHandle(DESCRIPTION.get(this.handle));
    }

    public void setMotD(WrappedChatComponent description) {
        DESCRIPTION.set(this.handle, description.getHandle());
    }

    public void setMotD(String message) {
        this.setMotD(WrappedChatComponent.fromLegacyText(message));
    }

    public CompressedImage getFavicon() {
        String favicon = (String)FAVICON.get(this.handle);
        return favicon != null ? CompressedImage.fromEncodedText(favicon) : null;
    }

    public void setFavicon(CompressedImage image) {
        FAVICON.set(this.handle, image != null ? image.toEncodedText() : null);
    }

    @Deprecated
    public boolean isChatPreviewEnabled() {
        return (Boolean)BOOLEAN_ACCESSORS[0].get(this.handle);
    }

    @Deprecated
    public void setChatPreviewEnabled(boolean chatPreviewEnabled) {
        BOOLEAN_ACCESSORS[0].set(this.handle, chatPreviewEnabled);
    }

    public boolean isEnforceSecureChat() {
        int index = MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove() ? 0 : 1;
        return (Boolean)BOOLEAN_ACCESSORS[index].get(this.handle);
    }

    public void setEnforceSecureChat(boolean enforceSecureChat) {
        int index = MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove() ? 0 : 1;
        BOOLEAN_ACCESSORS[index].set(this.handle, enforceSecureChat);
    }

    public int getPlayersOnline() {
        if (this.players == null) {
            throw new IllegalStateException("The player count has been hidden.");
        }
        return (Integer)PLAYERS_ONLINE.get(this.players);
    }

    public void setPlayersOnline(int online) {
        if (this.players == null) {
            this.resetPlayers();
        }
        PLAYERS_ONLINE.set(this.players, online);
    }

    public int getPlayersMaximum() {
        if (this.players == null) {
            throw new IllegalStateException("The player maximum has been hidden.");
        }
        return (Integer)PLAYERS_MAXIMUM.get(this.players);
    }

    public void setPlayersMaximum(int maximum) {
        if (this.players == null) {
            this.resetPlayers();
        }
        PLAYERS_MAXIMUM.set(this.players, maximum);
    }

    public void setPlayersVisible(boolean visible) {
        if (this.isPlayersVisible() != visible) {
            if (visible) {
                Server server = Bukkit.getServer();
                this.setPlayersMaximum(server.getMaxPlayers());
                this.setPlayersOnline(Bukkit.getOnlinePlayers().size());
            } else {
                this.players = null;
                PLAYERS.set(this.handle, null);
            }
        }
    }

    public boolean isPlayersVisible() {
        return this.players != null;
    }

    public ImmutableList<WrappedGameProfile> getPlayers() {
        if (this.players == null) {
            return ImmutableList.of();
        }
        Object playerProfiles = PLAYERS_PROFILES.get(this.players);
        if (playerProfiles == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(PROFILE_CONVERT.getSpecific(playerProfiles));
    }

    public void setPlayers(Iterable<? extends WrappedGameProfile> profile) {
        if (this.players == null) {
            this.resetPlayers();
        }
        PLAYERS_PROFILES.set(this.players, profile != null ? PROFILE_CONVERT.getGeneric(profile) : null);
    }

    public void setBukkitPlayers(Iterable<? extends Player> players) {
        ArrayList<WrappedGameProfile> profiles = new ArrayList<WrappedGameProfile>();
        for (Player player : players) {
            Object profile = ENTITY_HUMAN_PROFILE.get(BukkitUnwrapper.getInstance().unwrapItem(player));
            profiles.add(WrappedGameProfile.fromHandle(profile));
        }
        this.setPlayers(profiles);
    }

    public String getVersionName() {
        return (String)VERSION_NAME.get(this.version);
    }

    public void setVersionName(String name) {
        VERSION_NAME.set(this.version, name);
    }

    public int getVersionProtocol() {
        return (Integer)VERSION_PROTOCOL.get(this.version);
    }

    public void setVersionProtocol(int protocol) {
        VERSION_PROTOCOL.set(this.version, protocol);
    }

    @Override
    public WrappedServerPing deepClone() {
        WrappedServerPing copy = new WrappedServerPing();
        WrappedChatComponent motd = this.getMotD();
        copy.setPlayers((Iterable<? extends WrappedGameProfile>)this.getPlayers());
        copy.setFavicon(this.getFavicon());
        copy.setMotD(motd != null ? motd.deepClone() : null);
        copy.setVersionName(this.getVersionName());
        copy.setVersionProtocol(this.getVersionProtocol());
        if (this.isPlayersVisible()) {
            copy.setPlayersMaximum(this.getPlayersMaximum());
            copy.setPlayersOnline(this.getPlayersOnline());
        } else {
            copy.setPlayersVisible(false);
        }
        return copy;
    }

    public String toJson() {
        return (String)GSON_TO_JSON.invoke(PING_GSON.get(null), this.handle);
    }

    @Override
    public String toString() {
        return "WrappedServerPing< " + this.toJson() + ">";
    }

    public static class CompressedImage {
        protected volatile String mime;
        protected volatile byte[] data;
        protected volatile String encoded;

        protected CompressedImage() {
        }

        public CompressedImage(String mime, byte[] data) {
            this.mime = (String)Preconditions.checkNotNull((Object)mime, (Object)"mime cannot be NULL");
            this.data = (byte[])Preconditions.checkNotNull((Object)data, (Object)"data cannot be NULL");
        }

        public static CompressedImage fromPng(InputStream input) throws IOException {
            return new CompressedImage("image/png", ByteStreams.toByteArray((InputStream)input));
        }

        public static CompressedImage fromPng(byte[] data) {
            return new CompressedImage("image/png", data);
        }

        public static CompressedImage fromBase64Png(String base64) {
            try {
                return new EncodedCompressedImage("data:image/png;base64," + base64);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Must be a pure base64 encoded string. Cannot be an encoded text.", e);
            }
        }

        public static CompressedImage fromPng(RenderedImage image) throws IOException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write(image, "png", output);
            return new CompressedImage("image/png", output.toByteArray());
        }

        public static CompressedImage fromEncodedText(String text) {
            return new EncodedCompressedImage(text);
        }

        public String getMime() {
            return this.mime;
        }

        public byte[] getDataCopy() {
            return (byte[])this.getData().clone();
        }

        protected byte[] getData() {
            return this.data;
        }

        public BufferedImage getImage() throws IOException {
            return ImageIO.read(new ByteArrayInputStream(this.getData()));
        }

        public String toEncodedText() {
            if (this.encoded == null) {
                ByteBuf buffer = Unpooled.wrappedBuffer((byte[])this.getDataCopy());
                this.encoded = "data:" + this.getMime() + ";base64," + Base64.encode((ByteBuf)buffer).toString(StandardCharsets.UTF_8);
            }
            return this.encoded;
        }
    }

    private static class EncodedCompressedImage
    extends CompressedImage {
        public EncodedCompressedImage(String encoded) {
            this.encoded = (String)Preconditions.checkNotNull((Object)encoded, (Object)"encoded favicon cannot be NULL");
        }

        protected void initialize() {
            if (this.mime == null || this.data == null) {
                this.decode();
            }
        }

        protected void decode() {
            for (String segment : Splitter.on((String)";").split((CharSequence)this.encoded)) {
                if (segment.startsWith("data:")) {
                    this.mime = segment.substring(5);
                    continue;
                }
                if (!segment.startsWith("base64,")) continue;
                byte[] encoded = segment.substring(7).getBytes(StandardCharsets.UTF_8);
                ByteBuf decoded = Base64.decode((ByteBuf)Unpooled.wrappedBuffer((byte[])encoded));
                byte[] data = new byte[decoded.readableBytes()];
                decoded.readBytes(data);
                this.data = data;
            }
        }

        @Override
        protected byte[] getData() {
            this.initialize();
            return super.getData();
        }

        @Override
        public String getMime() {
            this.initialize();
            return super.getMime();
        }

        @Override
        public String toEncodedText() {
            return this.encoded;
        }
    }
}

