/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.destroystokyo.paper.VersionHistoryManager;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.StringUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class VersionCommand
extends BukkitCommand {
    private final ReentrantLock versionLock = new ReentrantLock();
    private boolean hasVersion = false;
    private String versionMessage = null;
    private final Set<CommandSender> versionWaiters = new HashSet<CommandSender>();
    private boolean versionTaskStarted = false;
    private long lastCheck = 0L;
    private static final String BRANCH = "ver/1.12.2";

    public VersionCommand(String name) {
        super(name);
        this.description = "Gets the version of this server including any plugins in use";
        this.usageMessage = "/version [plugin name]";
        this.setPermission("bukkit.command.version");
        this.setAliases(Arrays.asList("ver", "about"));
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("This server is running " + Bukkit.getName() + " version " + Bukkit.getVersion() + " (Implementing API version " + Bukkit.getBukkitVersion() + ")");
            this.tellHistory(sender);
            this.sendVersion(sender);
        } else {
            StringBuilder name = new StringBuilder();
            for (String arg : args) {
                if (name.length() > 0) {
                    name.append(' ');
                }
                name.append(arg);
            }
            String pluginName = name.toString();
            Plugin exactPlugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (exactPlugin != null) {
                this.describeToSender(exactPlugin, sender);
                return true;
            }
            boolean found = false;
            pluginName = pluginName.toLowerCase(Locale.ENGLISH);
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!plugin.getName().toLowerCase(Locale.ENGLISH).contains(pluginName)) continue;
                this.describeToSender(plugin, sender);
                found = true;
            }
            if (!found) {
                sender.sendMessage("This server is not running any plugin by that name.");
                sender.sendMessage("Use /plugins to get a list of plugins.");
            }
        }
        return true;
    }

    private void tellHistory(CommandSender sender) {
        VersionHistoryManager.VersionData data = VersionHistoryManager.INSTANCE.getVersionData();
        if (data == null) {
            return;
        }
        String oldVersion = data.getOldVersion();
        if (oldVersion == null) {
            return;
        }
        sender.sendMessage("Previous version: " + oldVersion);
    }

    private void describeToSender(Plugin plugin, CommandSender sender) {
        PluginDescriptionFile desc = plugin.getDescription();
        sender.sendMessage((Object)((Object)ChatColor.GREEN) + desc.getName() + (Object)((Object)ChatColor.WHITE) + " version " + (Object)((Object)ChatColor.GREEN) + desc.getVersion());
        if (desc.getDescription() != null) {
            sender.sendMessage(desc.getDescription());
        }
        if (desc.getWebsite() != null) {
            sender.sendMessage("Website: " + (Object)((Object)ChatColor.GREEN) + desc.getWebsite());
        }
        if (!desc.getAuthors().isEmpty()) {
            if (desc.getAuthors().size() == 1) {
                sender.sendMessage("Author: " + this.getAuthors(desc));
            } else {
                sender.sendMessage("Authors: " + this.getAuthors(desc));
            }
        }
    }

    private String getAuthors(PluginDescriptionFile desc) {
        StringBuilder result = new StringBuilder();
        List<String> authors = desc.getAuthors();
        for (int i = 0; i < authors.size(); ++i) {
            if (result.length() > 0) {
                result.append((Object)ChatColor.WHITE);
                if (i < authors.size() - 1) {
                    result.append(", ");
                } else {
                    result.append(" and ");
                }
            }
            result.append((Object)ChatColor.GREEN);
            result.append(authors.get(i));
        }
        return result.toString();
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            String toComplete = args[0].toLowerCase(Locale.ENGLISH);
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!StringUtil.startsWithIgnoreCase(plugin.getName(), toComplete)) continue;
                completions.add(plugin.getName());
            }
            return completions;
        }
        return ImmutableList.of();
    }

    private void sendVersion(CommandSender sender) {
        if (this.hasVersion) {
            if (System.currentTimeMillis() - this.lastCheck > 0x6DDD00L) {
                this.lastCheck = System.currentTimeMillis();
                this.hasVersion = false;
            } else {
                sender.sendMessage(this.versionMessage);
                return;
            }
        }
        this.versionLock.lock();
        try {
            if (this.hasVersion) {
                sender.sendMessage(this.versionMessage);
                return;
            }
            this.versionWaiters.add(sender);
            sender.sendMessage("Checking version, please wait...");
            if (!this.versionTaskStarted) {
                this.versionTaskStarted = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        VersionCommand.this.obtainVersion();
                    }
                }).start();
            }
        }
        finally {
            this.versionLock.unlock();
        }
    }

    private void obtainVersion() {
        String version = Bukkit.getVersion();
        if (version == null) {
            version = "Custom";
        }
        if (version.startsWith("git-Paper-")) {
            String[] parts = version.substring("git-Paper-".length()).split("[-\\s]");
            int distance = VersionCommand.getDistance(null, parts[0]);
            switch (distance) {
                case -1: {
                    this.setVersionMessage("Error obtaining version information");
                    break;
                }
                case 0: {
                    this.setVersionMessage("You are running the latest version");
                    break;
                }
                case -2: {
                    this.setVersionMessage("Unknown version");
                    break;
                }
                default: {
                    this.setVersionMessage("You are " + distance + " version(s) behind");
                    break;
                }
            }
        } else if (version.startsWith("git-Bukkit-")) {
            int cbVersions = VersionCommand.getDistance("craftbukkit", (version = version.substring("git-Bukkit-".length())).substring(0, version.indexOf(32)));
            if (cbVersions == -1) {
                this.setVersionMessage("Error obtaining version information");
            } else if (cbVersions == 0) {
                this.setVersionMessage("You are running the latest version");
            } else {
                this.setVersionMessage("You are " + cbVersions + " version(s) behind");
            }
        } else {
            this.setVersionMessage("Unknown version, custom build?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVersionMessage(String msg) {
        this.lastCheck = System.currentTimeMillis();
        this.versionMessage = msg;
        this.versionLock.lock();
        try {
            this.hasVersion = true;
            this.versionTaskStarted = false;
            for (CommandSender sender : this.versionWaiters) {
                sender.sendMessage(this.versionMessage);
            }
            this.versionWaiters.clear();
        }
        finally {
            this.versionLock.unlock();
        }
    }

    private static int getDistance(String repo, String verInfo) {
        try {
            int currentVer = Integer.decode(verInfo);
            return VersionCommand.getFromJenkins(currentVer);
        }
        catch (NumberFormatException ex) {
            verInfo = verInfo.replace("\"", "");
            return VersionCommand.getFromRepo("PaperMC/Paper", verInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFromJenkins(int currentVer) {
        int n;
        BufferedReader reader = Resources.asCharSource((URL)new URL("https://ci.destroystokyo.com/job/Paper/lastSuccessfulBuild/buildNumber"), (Charset)Charsets.UTF_8).openBufferedStream();
        try {
            int newVer = Integer.decode(reader.readLine());
            n = newVer - currentVer;
        }
        catch (NumberFormatException ex) {
            int n2;
            try {
                ex.printStackTrace();
                n2 = -2;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            reader.close();
            return n2;
        }
        reader.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getFromRepo(String repo, String hash) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.github.com/repos/" + repo + "/compare/" + BRANCH + "..." + hash).openConnection();
            connection.connect();
            if (connection.getResponseCode() == 404) {
                return -2;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));){
                String status;
                JSONObject obj = (JSONObject)new JSONParser().parse((Reader)reader);
                switch (status = (String)obj.get((Object)"status")) {
                    case "identical": {
                        int n = 0;
                        return n;
                    }
                    case "behind": {
                        int n = ((Number)obj.get((Object)"behind_by")).intValue();
                        return n;
                    }
                }
                int n = -1;
                return n;
            }
            catch (NumberFormatException | ParseException e) {
                e.printStackTrace();
                return -1;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

