/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public class MaterialSetTag
implements Tag<Material> {
    private final Set<Material> materials;

    public MaterialSetTag(Predicate<Material> filter) {
        this(Stream.of(Material.values()).filter(filter).collect(Collectors.toList()));
    }

    public MaterialSetTag(Collection<Material> materials) {
        this.materials = Sets.newEnumSet(materials, Material.class);
    }

    public MaterialSetTag(Material ... materials) {
        this.materials = Sets.newEnumSet((Iterable)Lists.newArrayList((Object[])materials), Material.class);
    }

    public MaterialSetTag add(Tag<Material> ... tags) {
        for (Tag<Material> tag : tags) {
            this.add(tag.getValues());
        }
        return this;
    }

    public MaterialSetTag add(MaterialSetTag ... tags) {
        for (MaterialSetTag tag : tags) {
            this.add(tag.getValues());
        }
        return this;
    }

    public MaterialSetTag add(Material ... material) {
        this.materials.addAll(Lists.newArrayList((Object[])material));
        return this;
    }

    public MaterialSetTag add(Collection<Material> materials) {
        this.materials.addAll(materials);
        return this;
    }

    public MaterialSetTag contains(String with) {
        return this.add((Material mat) -> mat.name().contains(with));
    }

    public MaterialSetTag endsWith(String with) {
        return this.add((Material mat) -> mat.name().endsWith(with));
    }

    public MaterialSetTag startsWith(String with) {
        return this.add((Material mat) -> mat.name().startsWith(with));
    }

    public MaterialSetTag add(Predicate<Material> filter) {
        this.add(Stream.of(Material.values()).filter(((Predicate<Material>)Material::isLegacy).negate()).filter(filter).collect(Collectors.toList()));
        return this;
    }

    public MaterialSetTag not(MaterialSetTag tags) {
        this.not(tags.getValues());
        return this;
    }

    public MaterialSetTag not(Material ... material) {
        this.materials.removeAll(Lists.newArrayList((Object[])material));
        return this;
    }

    public MaterialSetTag not(Collection<Material> materials) {
        this.materials.removeAll(materials);
        return this;
    }

    public MaterialSetTag not(Predicate<Material> filter) {
        this.not(Stream.of(Material.values()).filter(((Predicate<Material>)Material::isLegacy).negate()).filter(filter).collect(Collectors.toList()));
        return this;
    }

    public MaterialSetTag notEndsWith(String with) {
        return this.not((Material mat) -> mat.name().endsWith(with));
    }

    public MaterialSetTag notStartsWith(String with) {
        return this.not((Material mat) -> mat.name().startsWith(with));
    }

    @Override
    public Set<Material> getValues() {
        return this.materials;
    }

    @Override
    public boolean isTagged(BlockData block) {
        return this.isTagged(block.getMaterial());
    }

    @Override
    public boolean isTagged(BlockState block) {
        return this.isTagged(block.getType());
    }

    @Override
    public boolean isTagged(Block block) {
        return this.isTagged(block.getType());
    }

    @Override
    public boolean isTagged(ItemStack item) {
        return this.isTagged(item.getType());
    }

    @Override
    public boolean isTagged(Material material) {
        return this.materials.contains(material);
    }

    public MaterialSetTag ensureSize(String label, int size) {
        long actual = this.materials.stream().filter(((Predicate<Material>)Material::isLegacy).negate()).count();
        if ((long)size != actual) {
            throw new IllegalStateException(label + " - Expected " + size + " materials, got " + actual);
        }
        return this;
    }
}

