/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;

public enum VersionHistoryManager {
    INSTANCE;

    private final Gson gson = new Gson();
    private final Logger logger = Bukkit.getLogger();
    private VersionData currentData = null;

    private VersionHistoryManager() {
        Path path = Paths.get("version_history.json", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.logger.severe(path + " is a directory, cannot be used for version history");
                } else {
                    this.logger.severe(path + " is not a regular file, cannot be used for version history");
                }
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                this.currentData = (VersionData)this.gson.fromJson((Reader)reader, VersionData.class);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Failed to read version history file '" + path + "'", e);
                return;
            }
            catch (JsonSyntaxException e) {
                this.logger.log(Level.SEVERE, "Invalid json syntax for file '" + path + "'", e);
                return;
            }
            String version = Bukkit.getVersion();
            if (version == null) {
                this.logger.severe("Failed to retrieve current version");
                return;
            }
            if (!version.equals(this.currentData.getCurrentVersion())) {
                this.currentData.setOldVersion(this.currentData.getCurrentVersion());
                this.currentData.setCurrentVersion(version);
                this.writeFile(path);
            }
        } else {
            this.currentData = new VersionData();
            this.currentData.setCurrentVersion(Bukkit.getVersion());
            this.writeFile(path);
        }
    }

    private void writeFile(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.gson.toJson((Object)this.currentData, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to write to version history file", e);
        }
    }

    @Nullable
    public VersionData getVersionData() {
        return this.currentData;
    }

    public class VersionData {
        private String oldVersion;
        private String currentVersion;

        @Nullable
        public String getOldVersion() {
            return this.oldVersion;
        }

        public void setOldVersion(@Nullable String oldVersion) {
            this.oldVersion = oldVersion;
        }

        @Nullable
        public String getCurrentVersion() {
            return this.currentVersion;
        }

        public void setCurrentVersion(@Nullable String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("oldVersion", (Object)this.oldVersion).add("currentVersion", (Object)this.currentVersion).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionData versionData = (VersionData)o;
            return Objects.equals(this.oldVersion, versionData.oldVersion) && Objects.equals(this.currentVersion, versionData.currentVersion);
        }

        public int hashCode() {
            return Objects.hash(this.oldVersion, this.currentVersion);
        }
    }
}

