/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

public interface Pathfinder {
    public Mob getEntity();

    public void stopPathfinding();

    public boolean hasPath();

    @Nullable
    public PathResult getCurrentPath();

    @Nullable
    public PathResult findPath(Location var1);

    @Nullable
    public PathResult findPath(LivingEntity var1);

    default public boolean moveTo(@Nonnull Location loc) {
        return this.moveTo(loc, 1.0);
    }

    default public boolean moveTo(@Nonnull Location loc, double speed) {
        PathResult path = this.findPath(loc);
        return path != null && this.moveTo(path, speed);
    }

    default public boolean moveTo(@Nonnull LivingEntity target) {
        return this.moveTo(target, 1.0);
    }

    default public boolean moveTo(@Nonnull LivingEntity target, double speed) {
        PathResult path = this.findPath(target);
        return path != null && this.moveTo(path, speed);
    }

    default public boolean moveTo(@Nonnull PathResult path) {
        return this.moveTo(path, 1.0);
    }

    public boolean moveTo(@Nonnull PathResult var1, double var2);

    public static interface PathResult {
        public List<Location> getPoints();

        public int getNextPointIndex();

        @Nullable
        public Location getNextPoint();

        @Nullable
        public Location getFinalPoint();
    }
}

