/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.block;

import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;

public class AnvilDamagedEvent
extends InventoryEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancel;
    private DamageState damageState;

    public AnvilDamagedEvent(InventoryView inventory, BlockData blockData) {
        super(inventory);
        this.damageState = DamageState.getState(blockData);
    }

    @Override
    public AnvilInventory getInventory() {
        return (AnvilInventory)super.getInventory();
    }

    public DamageState getDamageState() {
        return this.damageState;
    }

    public void setDamageState(DamageState damageState) {
        this.damageState = damageState;
    }

    public boolean isBreaking() {
        return this.damageState == DamageState.BROKEN;
    }

    public void setBreaking(boolean breaking) {
        if (breaking) {
            this.damageState = DamageState.BROKEN;
        } else if (this.damageState == DamageState.BROKEN) {
            this.damageState = DamageState.DAMAGED;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum DamageState {
        FULL(Material.ANVIL),
        CHIPPED(Material.CHIPPED_ANVIL),
        DAMAGED(Material.DAMAGED_ANVIL),
        BROKEN(Material.AIR);

        private Material material;

        private DamageState(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }

        public static DamageState getState(BlockData blockData) {
            return blockData == null ? BROKEN : DamageState.getState(blockData.getMaterial());
        }

        public static DamageState getState(Material material) {
            if (material == null) {
                return BROKEN;
            }
            for (DamageState state : DamageState.values()) {
                if (state.material != material) continue;
                return state;
            }
            throw new IllegalArgumentException("Material not an anvil");
        }
    }
}

