/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.entity;

import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZapEvent
extends EntityTransformEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private final LightningStrike bolt;

    public EntityZapEvent(Entity entity, @Nonnull LightningStrike bolt, @Nonnull Entity replacementEntity) {
        super(entity, Collections.singletonList(replacementEntity), EntityTransformEvent.TransformReason.LIGHTNING);
        Validate.notNull((Object)bolt);
        Validate.notNull((Object)replacementEntity);
        this.bolt = bolt;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Nonnull
    public LightningStrike getBolt() {
        return this.bolt;
    }

    @Nonnull
    public Entity getReplacementEntity() {
        return this.getTransformedEntity();
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

