/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerArmorChangeEvent
extends PlayerEvent {
    private static final HandlerList HANDLERS = new HandlerList();
    private final SlotType slotType;
    private final ItemStack oldItem;
    private final ItemStack newItem;

    public PlayerArmorChangeEvent(Player player, SlotType slotType, ItemStack oldItem, ItemStack newItem) {
        super(player);
        this.slotType = slotType;
        this.oldItem = oldItem;
        this.newItem = newItem;
    }

    @Nonnull
    public SlotType getSlotType() {
        return this.slotType;
    }

    @Nullable
    public ItemStack getOldItem() {
        return this.oldItem;
    }

    @Nullable
    public ItemStack getNewItem() {
        return this.newItem;
    }

    public String toString() {
        return "ArmorChangeEvent{player=" + this.player + ", slotType=" + (Object)((Object)this.slotType) + ", oldItem=" + this.oldItem + ", newItem=" + this.newItem + '}';
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public static enum SlotType {
        HEAD(Material.DIAMOND_HELMET, Material.GOLDEN_HELMET, Material.IRON_HELMET, Material.CHAINMAIL_HELMET, Material.LEATHER_HELMET, Material.PUMPKIN, Material.JACK_O_LANTERN),
        CHEST(Material.DIAMOND_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.IRON_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.LEATHER_CHESTPLATE, Material.ELYTRA),
        LEGS(Material.DIAMOND_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.IRON_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.LEATHER_LEGGINGS),
        FEET(Material.DIAMOND_BOOTS, Material.GOLDEN_BOOTS, Material.IRON_BOOTS, Material.CHAINMAIL_BOOTS, Material.LEATHER_BOOTS);

        private final Set<Material> mutableTypes = new HashSet<Material>();
        private Set<Material> immutableTypes;

        private SlotType(Material ... types) {
            this.mutableTypes.addAll(Arrays.asList(types));
        }

        @Nonnull
        public Set<Material> getTypes() {
            if (this.immutableTypes == null) {
                this.immutableTypes = Collections.unmodifiableSet(this.mutableTypes);
            }
            return this.immutableTypes;
        }

        @Nullable
        public static SlotType getByMaterial(Material material) {
            for (SlotType slotType : SlotType.values()) {
                if (!slotType.getTypes().contains(material)) continue;
                return slotType;
            }
            return null;
        }

        public static boolean isEquipable(Material material) {
            return SlotType.getByMaterial(material) != null;
        }
    }
}

