/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import java.util.Date;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;

public interface OfflinePlayer
extends ServerOperator,
AnimalTamer,
ConfigurationSerializable {
    public boolean isOnline();

    @Override
    public String getName();

    @Override
    public UUID getUniqueId();

    public boolean isBanned();

    default public BanEntry banPlayer(String reason) {
        return this.banPlayer(reason, null, null);
    }

    default public BanEntry banPlayer(String reason, String source) {
        return this.banPlayer(reason, null, source);
    }

    default public BanEntry banPlayer(String reason, Date expires) {
        return this.banPlayer(reason, expires, null);
    }

    default public BanEntry banPlayer(String reason, Date expires, String source) {
        return this.banPlayer(reason, expires, source, true);
    }

    default public BanEntry banPlayer(String reason, Date expires, String source, boolean kickIfOnline) {
        BanEntry banEntry = Bukkit.getServer().getBanList(BanList.Type.NAME).addBan(this.getName(), reason, expires, source);
        if (kickIfOnline && this.isOnline()) {
            this.getPlayer().kickPlayer(reason);
        }
        return banEntry;
    }

    public boolean isWhitelisted();

    public void setWhitelisted(boolean var1);

    public Player getPlayer();

    public long getFirstPlayed();

    @Deprecated
    public long getLastPlayed();

    public boolean hasPlayedBefore();

    public Location getBedSpawnLocation();

    public long getLastLogin();

    public long getLastSeen();
}

