/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;

public class BlockPhysicsEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final BlockData changed;
    private boolean cancel = false;
    private int sourceX;
    private int sourceY;
    private int sourceZ;
    private Block sourceBlock;

    public BlockPhysicsEvent(Block block, BlockData changed, int sourceX, int sourceY, int sourceZ) {
        this(block, changed);
        this.sourceX = sourceX;
        this.sourceY = sourceY;
        this.sourceZ = sourceZ;
        this.sourceBlock = null;
    }

    public Block getSourceBlock() {
        return this.sourceBlock == null ? (this.sourceBlock = this.block.getWorld().getBlockAt(this.sourceX, this.sourceY, this.sourceZ)) : this.sourceBlock;
    }

    public BlockPhysicsEvent(Block block, BlockData changed) {
        super(block);
        this.changed = changed;
        this.sourceBlock = block;
    }

    public Material getChangedType() {
        return this.changed.getMaterial();
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

