/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.material.MaterialData;

public class FurnaceRecipe
implements Recipe,
Keyed {
    private final NamespacedKey key;
    private ItemStack output;
    private RecipeChoice ingredient;
    private float experience;
    private int cookingTime;
    private String group = "";

    @Deprecated
    public FurnaceRecipe(ItemStack result, Material source) {
        this(NamespacedKey.randomKey(), result, source, 0, 0.0f, 200);
    }

    @Deprecated
    public FurnaceRecipe(ItemStack result, MaterialData source) {
        this(NamespacedKey.randomKey(), result, source.getItemType(), source.getData(), 0.0f, 200);
    }

    @Deprecated
    public FurnaceRecipe(ItemStack result, MaterialData source, float experience) {
        this(NamespacedKey.randomKey(), result, source.getItemType(), source.getData(), experience, 200);
    }

    @Deprecated
    public FurnaceRecipe(ItemStack result, Material source, int data) {
        this(NamespacedKey.randomKey(), result, source, data, 0.0f, 200);
    }

    public FurnaceRecipe(NamespacedKey key, ItemStack result, Material source, float experience, int cookingTime) {
        this(key, result, source, 0, experience, cookingTime);
    }

    @Deprecated
    public FurnaceRecipe(NamespacedKey key, ItemStack result, Material source, int data, float experience, int cookingTime) {
        this(key, result, new RecipeChoice.MaterialChoice(Collections.singletonList(source)), experience, cookingTime);
    }

    public FurnaceRecipe(NamespacedKey key, ItemStack result, RecipeChoice input, float experience, int cookingTime) {
        this.key = key;
        this.output = new ItemStack(result);
        this.ingredient = input;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public FurnaceRecipe setInput(MaterialData input) {
        return this.setInput(input.getItemType(), input.getData());
    }

    public FurnaceRecipe setInput(Material input) {
        return this.setInput(input, 0);
    }

    @Deprecated
    public FurnaceRecipe setInput(Material input, int data) {
        this.ingredient = new RecipeChoice.MaterialChoice(Collections.singletonList(input));
        return this;
    }

    public ItemStack getInput() {
        return this.ingredient.getItemStack();
    }

    public FurnaceRecipe setInputChoice(RecipeChoice input) {
        this.ingredient = input;
        return this;
    }

    public RecipeChoice getInputChoice() {
        return this.ingredient.clone();
    }

    @Override
    public ItemStack getResult() {
        return this.output.clone();
    }

    public void setExperience(float experience) {
        this.experience = experience;
    }

    public float getExperience() {
        return this.experience;
    }

    public void setCookingTime(int cookingTime) {
        Preconditions.checkArgument((cookingTime >= 0 ? 1 : 0) != 0, (Object)"cookingTime must be >= 0");
        this.cookingTime = cookingTime;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"group");
        this.group = group;
    }
}

