/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.material.MaterialData;

public class ShapedRecipe
implements Recipe,
Keyed {
    private final NamespacedKey key;
    private final ItemStack output;
    private String[] rows;
    private Map<Character, RecipeChoice> ingredients = new HashMap<Character, RecipeChoice>();
    private String group = "";

    @Deprecated
    public ShapedRecipe(ItemStack result) {
        this.key = NamespacedKey.randomKey();
        new Throwable("Warning: A plugin is creating a recipe using a Deprecated method. This will cause you to receive warnings stating 'Tried to load unrecognized recipe: bukkit:<ID>'. Please ask the author to give their recipe a static key using NamespacedKey.").printStackTrace();
        this.output = new ItemStack(result);
    }

    public ShapedRecipe(NamespacedKey key, ItemStack result) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        this.key = key;
        this.output = new ItemStack(result);
    }

    public ShapedRecipe shape(String ... shape) {
        Validate.notNull((Object)shape, (String)"Must provide a shape");
        Validate.isTrue((shape.length > 0 && shape.length < 4 ? 1 : 0) != 0, (String)"Crafting recipes should be 1, 2, 3 rows, not ", (long)shape.length);
        int lastLen = -1;
        for (String row : shape) {
            Validate.notNull((Object)row, (String)"Shape cannot have null rows");
            Validate.isTrue((row.length() > 0 && row.length() < 4 ? 1 : 0) != 0, (String)"Crafting rows should be 1, 2, or 3 characters, not ", (long)row.length());
            Validate.isTrue((lastLen == -1 || lastLen == row.length() ? 1 : 0) != 0, (String)"Crafting recipes must be rectangular");
            lastLen = row.length();
        }
        this.rows = new String[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            this.rows[i] = shape[i];
        }
        HashMap<Character, RecipeChoice> newIngredients = new HashMap<Character, RecipeChoice>();
        for (String row : shape) {
            char[] cArray = row.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                newIngredients.put(c, this.ingredients.get(c));
            }
        }
        this.ingredients = newIngredients;
        return this;
    }

    public ShapedRecipe setIngredient(char key, MaterialData ingredient) {
        return this.setIngredient(key, ingredient.getItemType(), ingredient.getData());
    }

    public ShapedRecipe setIngredient(char key, Material ingredient) {
        return this.setIngredient(key, ingredient, 0);
    }

    @Deprecated
    public ShapedRecipe setIngredient(char key, Material ingredient, int raw) {
        Validate.isTrue((boolean)this.ingredients.containsKey(Character.valueOf(key)), (String)"Symbol does not appear in the shape:", (long)key);
        if (raw == -1) {
            raw = Short.MAX_VALUE;
        }
        this.ingredients.put(Character.valueOf(key), new RecipeChoice.MaterialChoice(Collections.singletonList(ingredient)));
        return this;
    }

    public ShapedRecipe setIngredient(char key, RecipeChoice ingredient) {
        Validate.isTrue((boolean)this.ingredients.containsKey(Character.valueOf(key)), (String)"Symbol does not appear in the shape:", (long)key);
        this.ingredients.put(Character.valueOf(key), ingredient);
        return this;
    }

    public Map<Character, ItemStack> getIngredientMap() {
        HashMap<Character, ItemStack> result = new HashMap<Character, ItemStack>();
        for (Map.Entry<Character, RecipeChoice> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().getItemStack().clone());
        }
        return result;
    }

    public Map<Character, RecipeChoice> getChoiceMap() {
        HashMap<Character, RecipeChoice> result = new HashMap<Character, RecipeChoice>();
        for (Map.Entry<Character, RecipeChoice> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().clone());
        }
        return result;
    }

    public String[] getShape() {
        return (String[])this.rows.clone();
    }

    @Override
    public ItemStack getResult() {
        return this.output.clone();
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"group");
        this.group = group;
    }
}

