/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.enchantments;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public enum EnchantmentTarget {
    ALL{

        @Override
        public boolean includes(@NotNull Material item) {
            return true;
        }
    }
    ,
    ARMOR{

        @Override
        public boolean includes(@NotNull Material item) {
            return ARMOR_FEET.includes(item) || ARMOR_LEGS.includes(item) || ARMOR_HEAD.includes(item) || ARMOR_TORSO.includes(item);
        }
    }
    ,
    ARMOR_FEET{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.LEATHER_BOOTS) || item.equals(Material.CHAINMAIL_BOOTS) || item.equals(Material.IRON_BOOTS) || item.equals(Material.DIAMOND_BOOTS) || item.equals(Material.GOLDEN_BOOTS);
        }
    }
    ,
    ARMOR_LEGS{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.LEATHER_LEGGINGS) || item.equals(Material.CHAINMAIL_LEGGINGS) || item.equals(Material.IRON_LEGGINGS) || item.equals(Material.DIAMOND_LEGGINGS) || item.equals(Material.GOLDEN_LEGGINGS);
        }
    }
    ,
    ARMOR_TORSO{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.LEATHER_CHESTPLATE) || item.equals(Material.CHAINMAIL_CHESTPLATE) || item.equals(Material.IRON_CHESTPLATE) || item.equals(Material.DIAMOND_CHESTPLATE) || item.equals(Material.GOLDEN_CHESTPLATE);
        }
    }
    ,
    ARMOR_HEAD{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.LEATHER_HELMET) || item.equals(Material.CHAINMAIL_HELMET) || item.equals(Material.DIAMOND_HELMET) || item.equals(Material.IRON_HELMET) || item.equals(Material.GOLDEN_HELMET);
        }
    }
    ,
    WEAPON{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.WOODEN_SWORD) || item.equals(Material.STONE_SWORD) || item.equals(Material.IRON_SWORD) || item.equals(Material.DIAMOND_SWORD) || item.equals(Material.GOLDEN_SWORD);
        }
    }
    ,
    TOOL{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.WOODEN_SHOVEL) || item.equals(Material.STONE_SHOVEL) || item.equals(Material.IRON_SHOVEL) || item.equals(Material.DIAMOND_SHOVEL) || item.equals(Material.GOLDEN_SHOVEL) || item.equals(Material.WOODEN_PICKAXE) || item.equals(Material.STONE_PICKAXE) || item.equals(Material.IRON_PICKAXE) || item.equals(Material.DIAMOND_PICKAXE) || item.equals(Material.GOLDEN_PICKAXE) || item.equals(Material.WOODEN_HOE) || item.equals(Material.STONE_HOE) || item.equals(Material.IRON_HOE) || item.equals(Material.DIAMOND_HOE) || item.equals(Material.GOLDEN_HOE) || item.equals(Material.WOODEN_AXE) || item.equals(Material.STONE_AXE) || item.equals(Material.IRON_AXE) || item.equals(Material.DIAMOND_AXE) || item.equals(Material.GOLDEN_AXE) || item.equals(Material.SHEARS) || item.equals(Material.FLINT_AND_STEEL);
        }
    }
    ,
    BOW{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.BOW);
        }
    }
    ,
    FISHING_ROD{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.FISHING_ROD);
        }
    }
    ,
    BREAKABLE{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.getMaxDurability() > 0 && item.getMaxStackSize() == 1;
        }
    }
    ,
    WEARABLE{

        @Override
        public boolean includes(@NotNull Material item) {
            return ARMOR.includes(item) || item.equals(Material.ELYTRA) || item.equals(Material.PUMPKIN) || item.equals(Material.CARVED_PUMPKIN) || item.equals(Material.JACK_O_LANTERN) || item.equals(Material.SKELETON_SKULL) || item.equals(Material.WITHER_SKELETON_SKULL) || item.equals(Material.ZOMBIE_HEAD) || item.equals(Material.PLAYER_HEAD) || item.equals(Material.CREEPER_HEAD) || item.equals(Material.DRAGON_HEAD);
        }
    }
    ,
    TRIDENT{

        @Override
        public boolean includes(@NotNull Material item) {
            return item.equals(Material.TRIDENT);
        }
    };


    public abstract boolean includes(@NotNull Material var1);

    public boolean includes(@NotNull ItemStack item) {
        return this.includes(item.getType());
    }
}

