/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerHandshakeEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    @NotNull
    private final String originalHandshake;
    private boolean cancelled;
    @Nullable
    private String serverHostname;
    @Nullable
    private String socketAddressHostname;
    @Nullable
    private UUID uniqueId;
    @Nullable
    private String propertiesJson;
    private boolean failed;
    private String failMessage = "If you wish to use IP forwarding, please enable it in your BungeeCord config as well!";

    public PlayerHandshakeEvent(@NotNull String originalHandshake, boolean cancelled) {
        this.originalHandshake = originalHandshake;
        this.cancelled = cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public String getOriginalHandshake() {
        return this.originalHandshake;
    }

    @Nullable
    public String getServerHostname() {
        return this.serverHostname;
    }

    public void setServerHostname(@NotNull String serverHostname) {
        this.serverHostname = serverHostname;
    }

    @Nullable
    public String getSocketAddressHostname() {
        return this.socketAddressHostname;
    }

    public void setSocketAddressHostname(@NotNull String socketAddressHostname) {
        this.socketAddressHostname = socketAddressHostname;
    }

    @Nullable
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(@NotNull UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Nullable
    public String getPropertiesJson() {
        return this.propertiesJson;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void setPropertiesJson(@NotNull String propertiesJson) {
        this.propertiesJson = propertiesJson;
    }

    @NotNull
    public String getFailMessage() {
        return this.failMessage;
    }

    public void setFailMessage(@NotNull String failMessage) {
        Validate.notEmpty((String)failMessage, (String)"fail message cannot be null or empty");
        this.failMessage = failMessage;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

