/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.player;

import io.papermc.paper.chat.ChatComposer;
import io.papermc.paper.chat.ChatFormatter;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.player.PlayerEvent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChatEvent
extends PlayerEvent
implements Cancellable {
    private final Set<Player> recipients;
    private boolean cancelled = false;
    private ChatComposer composer;
    @Deprecated
    private @Nullable ChatFormatter formatter;
    private Component message;

    AbstractChatEvent(boolean async, @NotNull Player player, @NotNull Set<Player> recipients, @NotNull ChatComposer composer, @NotNull Component message) {
        super(player, async);
        this.recipients = recipients;
        this.composer = composer;
        this.message = message;
    }

    @Deprecated
    AbstractChatEvent(boolean async, @NotNull Player player, @NotNull Set<Player> recipients, @NotNull ChatFormatter formatter, @NotNull Component message) {
        super(player, async);
        this.recipients = recipients;
        this.formatter = formatter;
        this.message = message;
    }

    @NotNull
    public final Set<Player> recipients() {
        return this.recipients;
    }

    @NotNull
    public final ChatComposer composer() {
        if (this.composer == null) {
            Objects.requireNonNull(this.formatter, "composer and formatter");
            this.composer = (source, displayName, message) -> this.formatter.chat(displayName, message);
        }
        return this.composer;
    }

    public final void composer(@NotNull ChatComposer composer) {
        this.composer = Objects.requireNonNull(composer, "composer");
        this.formatter = null;
    }

    @Deprecated
    @NotNull
    public final ChatFormatter formatter() {
        if (this.formatter == null) {
            this.formatter = (displayName, message) -> this.composer.composeChat(this.player, displayName, message);
        }
        return this.formatter;
    }

    @Deprecated
    public final void formatter(@NotNull ChatFormatter formatter) {
        this.formatter = Objects.requireNonNull(formatter, "formatter");
        this.composer = (source, displayName, message) -> formatter.chat(displayName, message);
    }

    @NotNull
    public final Component message() {
        return this.message;
    }

    public final void message(@NotNull Component message) {
        this.message = Objects.requireNonNull(message, "message");
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

