/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabCompleteEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final CommandSender sender;
    private final String buffer;
    private List<String> completions;
    private boolean cancelled;
    private final boolean isCommand;
    private final Location loc;

    public TabCompleteEvent(@NotNull CommandSender sender, @NotNull String buffer, @NotNull List<String> completions) {
        this(sender, buffer, completions, sender instanceof ConsoleCommandSender || buffer.startsWith("/"), null);
    }

    public TabCompleteEvent(@NotNull CommandSender sender, @NotNull String buffer, @NotNull List<String> completions, boolean isCommand, @Nullable Location location) {
        this.isCommand = isCommand;
        this.loc = location;
        Validate.notNull((Object)sender, (String)"sender");
        Validate.notNull((Object)buffer, (String)"buffer");
        Validate.notNull(completions, (String)"completions");
        this.sender = sender;
        this.buffer = buffer;
        this.completions = completions;
    }

    @NotNull
    public CommandSender getSender() {
        return this.sender;
    }

    @NotNull
    public String getBuffer() {
        return this.buffer;
    }

    @NotNull
    public List<String> getCompletions() {
        return this.completions;
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    @Nullable
    public Location getLocation() {
        return this.loc;
    }

    public void setCompletions(@NotNull List<String> completions) {
        Validate.notNull(completions);
        this.completions = new ArrayList<String>(completions);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

