/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BIngredients;
import com.dre.brewery.LegacyUtil;
import com.dre.brewery.P;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BCauldron {
    public static CopyOnWriteArrayList<BCauldron> bcauldrons = new CopyOnWriteArrayList();
    private BIngredients ingredients = new BIngredients();
    private Block block;
    private int state = 1;
    private boolean someRemoved = false;

    public BCauldron(Block block, ItemStack ingredient) {
        this.block = block;
        this.add(ingredient);
        bcauldrons.add(this);
    }

    public BCauldron(Block block, BIngredients ingredients, int state) {
        this.block = block;
        this.state = state;
        this.ingredients = ingredients;
        bcauldrons.add(this);
    }

    public void onUpdate() {
        if (!this.block.getChunk().isLoaded() || this.block.getRelative(BlockFace.DOWN).getType() == Material.FIRE || LegacyUtil.isLava(this.block.getRelative(BlockFace.DOWN).getType())) {
            ++this.state;
            if (this.someRemoved) {
                this.ingredients = this.ingredients.clone();
                this.someRemoved = false;
            }
        }
    }

    public void add(ItemStack ingredient) {
        if (this.someRemoved) {
            this.ingredients = this.ingredients.clone();
            this.someRemoved = false;
        }
        ingredient = new ItemStack(ingredient.getType(), 1, ingredient.getDurability());
        this.ingredients.add(ingredient);
        this.block.getWorld().playEffect(this.block.getLocation(), Effect.EXTINGUISH, 0);
        if (this.state > 1) {
            --this.state;
        }
    }

    public static BCauldron get(Block block) {
        for (BCauldron bcauldron : bcauldrons) {
            if (!bcauldron.block.equals(block)) continue;
            return bcauldron;
        }
        return null;
    }

    public static boolean ingredientAdd(Block block, ItemStack ingredient) {
        if (LegacyUtil.getFillLevel(block) != 0) {
            BCauldron bcauldron = BCauldron.get(block);
            if (bcauldron != null) {
                bcauldron.add(ingredient);
                return true;
            }
            new BCauldron(block, ingredient);
            return true;
        }
        return false;
    }

    public static boolean fill(Player player, Block block) {
        BCauldron bcauldron = BCauldron.get(block);
        if (bcauldron != null) {
            if (!player.hasPermission("brewery.cauldron.fill")) {
                P.p.msg((CommandSender)player, P.p.languageReader.get("Perms_NoCauldronFill", new String[0]));
                return true;
            }
            ItemStack potion = bcauldron.ingredients.cook(bcauldron.state);
            if (potion != null) {
                if (P.use1_13) {
                    BlockData data = block.getBlockData();
                    Levelled cauldron = (Levelled)data;
                    if (cauldron.getLevel() <= 0) {
                        bcauldrons.remove(bcauldron);
                        return false;
                    }
                    cauldron.setLevel(cauldron.getLevel() - 1);
                    block.setBlockData(data);
                    if (cauldron.getLevel() <= 0) {
                        bcauldrons.remove(bcauldron);
                    } else {
                        bcauldron.someRemoved = true;
                    }
                } else {
                    byte data = block.getData();
                    if (data > 3) {
                        data = 3;
                    } else if (data <= 0) {
                        bcauldrons.remove(bcauldron);
                        return false;
                    }
                    data = (byte)(data - 1);
                    LegacyUtil.setData(block, data);
                    if (data == 0) {
                        bcauldrons.remove(bcauldron);
                    } else {
                        bcauldron.someRemoved = true;
                    }
                }
                BCauldron.giveItem(player, potion);
                return true;
            }
        }
        return false;
    }

    public static void printTime(Player player, Block block) {
        if (!player.hasPermission("brewery.cauldron.time")) {
            P.p.msg((CommandSender)player, P.p.languageReader.get("Error_NoPermissions", new String[0]));
            return;
        }
        BCauldron bcauldron = BCauldron.get(block);
        if (bcauldron != null) {
            if (bcauldron.state > 1) {
                P.p.msg((CommandSender)player, P.p.languageReader.get("Player_CauldronInfo1", "" + bcauldron.state));
            } else {
                P.p.msg((CommandSender)player, P.p.languageReader.get("Player_CauldronInfo2", new String[0]));
            }
        }
    }

    public static void remove(Block block) {
        BCauldron bcauldron;
        if (LegacyUtil.getFillLevel(block) != 0 && (bcauldron = BCauldron.get(block)) != null) {
            bcauldrons.remove(bcauldron);
        }
    }

    public static void onUnload(String name) {
        for (BCauldron bcauldron : bcauldrons) {
            if (!bcauldron.block.getWorld().getName().equals(name)) continue;
            bcauldrons.remove(bcauldron);
        }
    }

    public static void save(ConfigurationSection config, ConfigurationSection oldData) {
        P.p.createWorldSections(config);
        if (!bcauldrons.isEmpty()) {
            int id = 0;
            for (BCauldron cauldron : bcauldrons) {
                String worldName = cauldron.block.getWorld().getName();
                String prefix = worldName.startsWith("DXL_") ? P.p.getDxlName(worldName) + "." + id : cauldron.block.getWorld().getUID().toString() + "." + id;
                config.set(prefix + ".block", (Object)(cauldron.block.getX() + "/" + cauldron.block.getY() + "/" + cauldron.block.getZ()));
                if (cauldron.state != 1) {
                    config.set(prefix + ".state", (Object)cauldron.state);
                }
                config.set(prefix + ".ingredients", cauldron.ingredients.serializeIngredients());
                ++id;
            }
        }
        if (oldData != null) {
            for (String uuid : oldData.getKeys(false)) {
                if (config.contains(uuid)) continue;
                config.set(uuid, oldData.get(uuid));
            }
        }
    }

    public static void giveItem(final Player player, final ItemStack item) {
        P.p.getServer().getScheduler().runTaskLater((Plugin)P.p, new Runnable(){

            @Override
            public void run() {
                player.getInventory().addItem(new ItemStack[]{item});
            }
        }, 1L);
    }
}

