/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BRecipe;
import com.dre.brewery.Brew;
import com.dre.brewery.P;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffectType;

public class BIngredients {
    public static Set<Material> possibleIngredients = new HashSet<Material>();
    public static ArrayList<BRecipe> recipes = new ArrayList();
    public static Map<Material, String> cookedNames = new HashMap<Material, String>();
    private static int lastId = 0;
    private int id;
    private ArrayList<ItemStack> ingredients = new ArrayList();
    private Map<Material, Integer> materials = new HashMap<Material, Integer>();
    private int cookedTime;

    public BIngredients() {
        this.id = lastId++;
    }

    public BIngredients(ArrayList<ItemStack> ingredients, int cookedTime) {
        this.ingredients = ingredients;
        this.cookedTime = cookedTime;
        this.id = lastId++;
        for (ItemStack item : ingredients) {
            this.addMaterial(item);
        }
    }

    public void add(ItemStack ingredient) {
        this.addMaterial(ingredient);
        for (ItemStack item : this.ingredients) {
            if (!item.isSimilar(ingredient)) continue;
            item.setAmount(item.getAmount() + ingredient.getAmount());
            return;
        }
        this.ingredients.add(ingredient);
    }

    private void addMaterial(ItemStack ingredient) {
        if (this.materials.containsKey(ingredient.getType())) {
            int newAmount = this.materials.get(ingredient.getType()) + ingredient.getAmount();
            this.materials.put(ingredient.getType(), newAmount);
        } else {
            this.materials.put(ingredient.getType(), ingredient.getAmount());
        }
    }

    public ItemStack cook(int state) {
        ItemStack potion = new ItemStack(Material.POTION);
        PotionMeta potionMeta = (PotionMeta)potion.getItemMeta();
        this.cookedTime = state;
        String cookedName = null;
        BRecipe cookRecipe = this.getCookRecipe();
        int uid = Brew.generateUID();
        if (cookRecipe != null) {
            int quality = (int)Math.round((double)(this.getIngredientQuality(cookRecipe) + this.getCookingQuality(cookRecipe, false)) / 2.0);
            P.p.debugLog("cooked potion has Quality: " + quality);
            Brew brew = new Brew(uid, quality, cookRecipe, this);
            Brew.addOrReplaceEffects(potionMeta, brew.getEffects(), brew.getQuality());
            cookedName = cookRecipe.getName(quality);
            Brew.PotionColor.valueOf(cookRecipe.getColor()).colorBrew(potionMeta, potion, false);
        } else {
            new Brew(uid, this);
            if (state <= 1) {
                cookedName = P.p.languageReader.get("Brew_ThickBrew", new String[0]);
                Brew.PotionColor.BLUE.colorBrew(potionMeta, potion, false);
            } else {
                for (Material ingredient : this.materials.keySet()) {
                    if (!cookedNames.containsKey(ingredient) || this.materials.get(ingredient) <= this.getIngredientsCount() / 2) continue;
                    cookedName = cookedNames.get(ingredient);
                    Brew.PotionColor.CYAN.colorBrew(potionMeta, potion, true);
                }
            }
        }
        if (cookedName == null) {
            cookedName = P.p.languageReader.get("Brew_Undefined", new String[0]);
            Brew.PotionColor.CYAN.colorBrew(potionMeta, potion, true);
        }
        potionMeta.setDisplayName(P.p.color("&f" + cookedName));
        if (!P.use1_14) {
            uid *= 4;
        }
        potionMeta.addCustomEffect(PotionEffectType.REGENERATION.createEffect(uid, 0), true);
        potion.setItemMeta((ItemMeta)potionMeta);
        return potion;
    }

    private int getIngredientsCount() {
        int count = 0;
        for (ItemStack item : this.ingredients) {
            count += item.getAmount();
        }
        return count;
    }

    public int getCookedTime() {
        return this.cookedTime;
    }

    public BRecipe getBestRecipe(float wood, float time, boolean distilled) {
        float quality = 0.0f;
        BRecipe bestRecipe = null;
        for (BRecipe recipe : recipes) {
            int ingredientQuality = this.getIngredientQuality(recipe);
            int cookingQuality = this.getCookingQuality(recipe, distilled);
            if (ingredientQuality <= -1 || cookingQuality <= -1) continue;
            if (recipe.needsToAge() || (double)time > 0.5) {
                int ageQuality = this.getAgeQuality(recipe, time);
                int woodQuality = this.getWoodQuality(recipe, wood);
                P.p.debugLog("Ingredient Quality: " + ingredientQuality + " Cooking Quality: " + cookingQuality + " Wood Quality: " + woodQuality + " age Quality: " + ageQuality + " for " + recipe.getName(5));
                if (!(((float)ingredientQuality + (float)cookingQuality + (float)woodQuality + (float)ageQuality) / 4.0f > quality)) continue;
                quality = ((float)ingredientQuality + (float)cookingQuality + (float)woodQuality + (float)ageQuality) / 4.0f;
                bestRecipe = recipe;
                continue;
            }
            P.p.debugLog("Ingredient Quality: " + ingredientQuality + " Cooking Quality: " + cookingQuality + " for " + recipe.getName(5));
            if (!(((float)ingredientQuality + (float)cookingQuality) / 2.0f > quality)) continue;
            quality = ((float)ingredientQuality + (float)cookingQuality) / 2.0f;
            bestRecipe = recipe;
        }
        if (bestRecipe != null) {
            P.p.debugLog("best recipe: " + bestRecipe.getName(5) + " has Quality= " + quality);
        }
        return bestRecipe;
    }

    public BRecipe getCookRecipe() {
        BRecipe bestRecipe = this.getBestRecipe(0.0f, 0.0f, false);
        if (bestRecipe != null && bestRecipe.isCookingOnly()) {
            return bestRecipe;
        }
        return null;
    }

    public BRecipe getdistillRecipe(float wood, float time) {
        BRecipe bestRecipe = this.getBestRecipe(wood, time, true);
        if (bestRecipe != null && bestRecipe.needsDistilling()) {
            return bestRecipe;
        }
        return null;
    }

    public BRecipe getAgeRecipe(float wood, float time, boolean distilled) {
        BRecipe bestRecipe = this.getBestRecipe(wood, time, distilled);
        if (bestRecipe != null && bestRecipe.needsToAge()) {
            return bestRecipe;
        }
        return null;
    }

    public int getIngredientQuality(BRecipe recipe) {
        float quality = 10.0f;
        int badStuff = 0;
        if (recipe.isMissingIngredients(this.ingredients)) {
            return -1;
        }
        ArrayList<Material> mergedChecked = new ArrayList<Material>();
        for (ItemStack ingredient : this.ingredients) {
            int count;
            if (mergedChecked.contains(ingredient.getType())) continue;
            int amountInRecipe = recipe.amountOf(ingredient);
            if (recipe.hasExactData(ingredient)) {
                count = ingredient.getAmount();
            } else {
                mergedChecked.add(ingredient.getType());
                count = this.materials.get(ingredient.getType());
            }
            if (amountInRecipe == 0) {
                if (count > this.getIngredientsCount() / 2) {
                    return -1;
                }
                if (++badStuff < this.ingredients.size()) {
                    quality = (float)((double)quality - (double)count * ((double)recipe.getDifficulty() / 2.0));
                    continue;
                }
                return -1;
            }
            quality = (float)((double)quality - (double)((float)Math.abs(count - amountInRecipe) / (float)recipe.allowedCountDiff(amountInRecipe)) * 10.0);
        }
        if (quality >= 0.0f) {
            return Math.round(quality);
        }
        return -1;
    }

    public int getCookingQuality(BRecipe recipe, boolean distilled) {
        if (!recipe.needsDistilling() == distilled) {
            return -1;
        }
        int quality = 10 - (int)Math.round((double)((float)Math.abs(this.cookedTime - recipe.getCookingTime()) / (float)recipe.allowedTimeDiff(recipe.getCookingTime())) * 10.0);
        if (quality >= 0) {
            if (this.cookedTime <= 1) {
                return 0;
            }
            return quality;
        }
        return -1;
    }

    public int getDistillQuality(BRecipe recipe, int distillRuns) {
        if (recipe.needsDistilling() != distillRuns > 0) {
            return 0;
        }
        return 10 - Math.abs(recipe.getDistillRuns() - distillRuns);
    }

    public int getWoodQuality(BRecipe recipe, float wood) {
        if (recipe.getWood() == 0) {
            return 10;
        }
        int quality = 10 - Math.round(recipe.getWoodDiff(wood) * (float)recipe.getDifficulty());
        if (quality > 0) {
            return quality;
        }
        return 0;
    }

    public int getAgeQuality(BRecipe recipe, float time) {
        int quality = 10 - Math.round(Math.abs(time - recipe.getAge()) * ((float)recipe.getDifficulty() / 2.0f));
        if (quality > 0) {
            return quality;
        }
        return 0;
    }

    public BIngredients clone() {
        BIngredients copy = new BIngredients();
        copy.ingredients.addAll(this.ingredients);
        copy.materials.putAll(this.materials);
        copy.cookedTime = this.cookedTime;
        return copy;
    }

    public int save(ConfigurationSection config) {
        String path = "Ingredients." + this.id;
        if (this.cookedTime != 0) {
            config.set(path + ".cookedTime", (Object)this.cookedTime);
        }
        config.set(path + ".mats", this.serializeIngredients());
        return this.id;
    }

    public Map<String, Integer> serializeIngredients() {
        HashMap<String, Integer> mats = new HashMap<String, Integer>();
        for (ItemStack item : this.ingredients) {
            String mat = item.getType().name() + "," + item.getDurability();
            mats.put(mat, item.getAmount());
        }
        return mats;
    }
}

