/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BEffect;
import com.dre.brewery.Brew;
import com.dre.brewery.P;
import com.dre.brewery.Wakeup;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.mutable.MutableInt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class BPlayer {
    private static Map<String, BPlayer> players = new HashMap<String, BPlayer>();
    private static Map<Player, MutableInt> pTasks = new HashMap<Player, MutableInt>();
    private static int taskId;
    private static boolean modAge;
    private static Random pukeRand;
    private static Method gh;
    private static Field age;
    public static Map<Material, Integer> drainItems;
    public static Material pukeItem;
    public static int pukeDespawntime;
    public static int hangoverTime;
    public static boolean overdrinkKick;
    public static boolean enableHome;
    public static boolean enableLoginDisallow;
    public static boolean enablePuke;
    public static String homeType;
    private int quality = 0;
    private int drunkeness = 0;
    private int offlineDrunk = 0;
    private Vector push = new Vector(0, 0, 0);
    private int time = 20;

    public BPlayer() {
    }

    public BPlayer(String name, int quality, int drunkeness, int offlineDrunk) {
        this.quality = quality;
        this.drunkeness = drunkeness;
        this.offlineDrunk = offlineDrunk;
        players.put(name, this);
    }

    public static BPlayer get(Player player) {
        if (!players.isEmpty()) {
            return players.get(P.playerString(player));
        }
        return null;
    }

    public static BPlayer getByName(String playerName) {
        if (P.useUUID) {
            for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
                String name;
                OfflinePlayer p = P.p.getServer().getOfflinePlayer(UUID.fromString(entry.getKey()));
                if (p == null || (name = p.getName()) == null || !name.equalsIgnoreCase(playerName)) continue;
                return entry.getValue();
            }
            return null;
        }
        return players.get(playerName);
    }

    public static boolean hasPlayerbyName(String playerName) {
        if (P.useUUID) {
            for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
                String name;
                OfflinePlayer p = P.p.getServer().getOfflinePlayer(UUID.fromString(entry.getKey()));
                if (p == null || (name = p.getName()) == null || !name.equalsIgnoreCase(playerName)) continue;
                return true;
            }
            return false;
        }
        return players.containsKey(playerName);
    }

    public static boolean isEmpty() {
        return players.isEmpty();
    }

    public static boolean hasPlayer(Player player) {
        return players.containsKey(P.playerString(player));
    }

    public static BPlayer addPlayer(Player player) {
        BPlayer bPlayer = new BPlayer();
        players.put(P.playerString(player), bPlayer);
        return bPlayer;
    }

    public static void remove(Player player) {
        players.remove(P.playerString(player));
    }

    public static int numDrunkPlayers() {
        return players.size();
    }

    public void remove() {
        for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
            if (entry.getValue() != this) continue;
            players.remove(entry.getKey());
            return;
        }
    }

    public static void clear() {
        players.clear();
    }

    public static void drink(Brew brew, Player player) {
        int brewAlc = brew.calcAlcohol();
        if (brewAlc == 0) {
            BPlayer.addBrewEffects(brew, player);
            return;
        }
        BPlayer bPlayer = BPlayer.get(player);
        if (bPlayer == null) {
            bPlayer = BPlayer.addPlayer(player);
        }
        bPlayer.drunkeness += brewAlc;
        bPlayer.quality = brew.getQuality() > 0 ? (bPlayer.quality += brew.getQuality() * brewAlc) : (bPlayer.quality += brewAlc);
        if (bPlayer.drunkeness <= 100) {
            BPlayer.addBrewEffects(brew, player);
            BPlayer.addQualityEffects(brew.getQuality(), brewAlc, player);
        } else {
            bPlayer.drinkCap(player);
        }
    }

    public void drinkCap(Player player) {
        this.quality = this.getQuality() * 100;
        this.drunkeness = 100;
        if (overdrinkKick && !player.hasPermission("brewery.bypass.overdrink")) {
            this.passOut(player);
        } else {
            BPlayer.addPuke(player, 60 + (int)(Math.random() * 60.0));
            P.p.msg((CommandSender)player, P.p.languageReader.get("Player_CantDrink", new String[0]));
        }
    }

    public static void playerMove(PlayerMoveEvent event) {
        BPlayer bPlayer = BPlayer.get(event.getPlayer());
        if (bPlayer != null) {
            bPlayer.move(event);
        }
    }

    public void drainByItem(Player player, Material mat) {
        int strength = drainItems.get(mat);
        if (this.drain(player, strength)) {
            BPlayer.remove(player);
        }
    }

    public boolean drain(Player player, int amount) {
        if (this.drunkeness > 0) {
            this.quality -= this.getQuality() * amount;
        }
        this.drunkeness -= amount;
        if (this.drunkeness > 0) {
            if (this.offlineDrunk == 0 && player == null) {
                this.offlineDrunk = this.drunkeness;
            }
        } else {
            if (this.offlineDrunk == 0) {
                return true;
            }
            this.quality = this.getQuality();
            if (this.drunkeness <= -this.offlineDrunk) {
                return this.drunkeness <= -hangoverTime;
            }
        }
        return false;
    }

    public void move(PlayerMoveEvent event) {
        if (this.drunkeness >= 10 && this.drunkeness <= 100) {
            Player player;
            Player entity;
            if (this.time > 1) {
                --this.time;
            } else if ((event.getFrom().getX() != event.getTo().getX() || event.getFrom().getZ() != event.getTo().getZ()) && (entity = (player = event.getPlayer())).isOnGround()) {
                --this.time;
                if (this.time == 0) {
                    if (P.use1_9) {
                        this.push.setX((Math.random() - 0.5) / 2.0);
                        this.push.setZ((Math.random() - 0.5) / 2.0);
                    } else {
                        this.push.setX(Math.random() - 0.5);
                        this.push.setZ(Math.random() - 0.5);
                    }
                    player.setVelocity(this.push);
                } else if (this.time < 0 && this.time > -10) {
                    player.setVelocity(this.push);
                } else {
                    this.time = (int)(Math.random() * (201.0 - (double)(this.drunkeness * 2)));
                }
            }
        }
    }

    public void passOut(Player player) {
        player.kickPlayer(P.p.languageReader.get("Player_DrunkPassOut", new String[0]));
        this.offlineDrunk = this.drunkeness;
    }

    public int canJoin() {
        if (this.drunkeness <= 70) {
            return 0;
        }
        if (!enableLoginDisallow) {
            if (this.drunkeness <= 100) {
                return 0;
            }
            return 3;
        }
        if (this.drunkeness <= 90) {
            if (Math.random() > 0.4) {
                return 0;
            }
            return 2;
        }
        if (this.drunkeness <= 100) {
            if (Math.random() > 0.6) {
                return 0;
            }
            return 2;
        }
        return 3;
    }

    public void join(final Player player) {
        if (this.offlineDrunk == 0) {
            return;
        }
        P.p.getServer().getScheduler().runTaskLater((Plugin)P.p, new Runnable(){

            @Override
            public void run() {
                BPlayer.this.login(player);
            }
        }, 1L);
    }

    public void login(Player player) {
        Location randomLoc;
        if (this.drunkeness < 10) {
            if (this.offlineDrunk > 60 && enableHome && !player.hasPermission("brewery.bypass.teleport")) {
                this.goHome(player);
            }
            this.hangoverEffects(player);
            players.remove(P.playerString(player));
        } else if (this.offlineDrunk - this.drunkeness >= 30 && (randomLoc = Wakeup.getRandom(player.getLocation())) != null && !player.hasPermission("brewery.bypass.teleport")) {
            player.teleport(randomLoc);
            P.p.msg((CommandSender)player, P.p.languageReader.get("Player_Wake", new String[0]));
        }
        this.offlineDrunk = 0;
    }

    public void disconnecting() {
        this.offlineDrunk = this.drunkeness;
    }

    public void goHome(Player player) {
        if (homeType != null) {
            Location home = null;
            if (homeType.equalsIgnoreCase("bed")) {
                home = player.getBedSpawnLocation();
            } else if (homeType.startsWith("cmd: ")) {
                player.performCommand(homeType.substring(5));
            } else if (homeType.startsWith("cmd:")) {
                player.performCommand(homeType.substring(4));
            } else {
                P.p.errorLog("Config.yml 'homeType: " + homeType + "' unknown!");
            }
            if (home != null) {
                player.teleport(home);
            }
        }
    }

    public void drunkPuke(Player player) {
        if (this.drunkeness >= 80) {
            if (this.drunkeness >= 90) {
                if (Math.random() < 0.15 - (double)(this.getQuality() / 100)) {
                    BPlayer.addPuke(player, 20 + (int)(Math.random() * 40.0));
                }
            } else if (Math.random() < 0.08 - (double)(this.getQuality() / 100)) {
                BPlayer.addPuke(player, 10 + (int)(Math.random() * 30.0));
            }
        }
    }

    public static void addPuke(Player player, int count) {
        if (!enablePuke) {
            return;
        }
        if (pTasks.isEmpty()) {
            taskId = P.p.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)P.p, new Runnable(){

                @Override
                public void run() {
                    BPlayer.pukeTask();
                }
            }, 1L, 1L);
        }
        pTasks.put(player, new MutableInt(count));
    }

    public static void pukeTask() {
        Iterator<Map.Entry<Player, MutableInt>> iter = pTasks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Player, MutableInt> entry = iter.next();
            Player player = entry.getKey();
            MutableInt count = entry.getValue();
            if (!player.isValid() || !player.isOnline()) {
                iter.remove();
            }
            BPlayer.puke(player);
            count.decrement();
            if (count.intValue() > 0) continue;
            iter.remove();
        }
        if (pTasks.isEmpty()) {
            P.p.getServer().getScheduler().cancelTask(taskId);
        }
    }

    public static void puke(Player player) {
        if (pukeRand == null) {
            pukeRand = new Random();
        }
        if (pukeItem == null || pukeItem == Material.AIR) {
            pukeItem = Material.SOUL_SAND;
        }
        Location loc = player.getLocation();
        loc.setY(loc.getY() + 1.1);
        loc.setPitch(loc.getPitch() - 10.0f + (float)pukeRand.nextInt(20));
        loc.setYaw(loc.getYaw() - 10.0f + (float)pukeRand.nextInt(20));
        Vector direction = loc.getDirection();
        direction.multiply(0.5);
        loc.add(direction);
        Item item = player.getWorld().dropItem(loc, new ItemStack(pukeItem));
        item.setVelocity(direction);
        item.setPickupDelay(Short.MAX_VALUE);
        if (modAge) {
            if (pukeDespawntime >= 5800) {
                return;
            }
            try {
                if (gh == null) {
                    gh = Class.forName(P.p.getServer().getClass().getPackage().getName() + ".entity.CraftItem").getMethod("getHandle", null);
                }
                Object entityItem = gh.invoke((Object)item, (Object[])null);
                if (age == null) {
                    age = entityItem.getClass().getDeclaredField("age");
                    age.setAccessible(true);
                }
                if (pukeDespawntime <= 0) {
                    age.setInt(entityItem, 5999);
                } else if (pukeDespawntime <= 120) {
                    age.setInt(entityItem, 6000 - pukeDespawntime + pukeRand.nextInt((int)((float)pukeDespawntime / 2.0f)));
                } else {
                    age.setInt(entityItem, 6000 - pukeDespawntime + pukeRand.nextInt(100));
                }
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                modAge = false;
                P.p.errorLog("Failed to set Despawn Time on item " + pukeItem.name());
            }
        }
    }

    public void drunkEffects(Player player) {
        int duration = 10 - this.getQuality();
        duration += this.drunkeness / 2;
        if ((duration *= 5) > 240) {
            duration *= 5;
        } else if (duration < 115) {
            duration = 115;
        }
        if (!P.use1_14) {
            duration *= 4;
        }
        PotionEffectType.CONFUSION.createEffect(duration, 0).apply((LivingEntity)player);
    }

    public static void addQualityEffects(int quality, int brewAlc, Player player) {
        int duration = 7 - quality;
        if (quality == 0) {
            duration *= 125;
        } else if (quality <= 5) {
            duration *= 62;
        } else {
            duration = 25;
            if (brewAlc <= 10) {
                duration = 0;
            }
        }
        if (!P.use1_14) {
            duration *= 4;
        }
        if (duration > 0) {
            PotionEffectType.POISON.createEffect(duration, 0).apply((LivingEntity)player);
        }
        if (brewAlc > 10) {
            if (quality <= 5) {
                duration = 10 - quality;
                duration += brewAlc;
                duration *= 15;
            } else {
                duration = 30;
            }
            if (!P.use1_14) {
                duration *= 4;
            }
            PotionEffectType.BLINDNESS.createEffect(duration, 0).apply((LivingEntity)player);
        }
    }

    public static void addBrewEffects(Brew brew, Player player) {
        ArrayList<BEffect> effects = brew.getEffects();
        if (effects != null) {
            for (BEffect effect : effects) {
                effect.apply(brew.getQuality(), player);
            }
        }
    }

    public void hangoverEffects(Player player) {
        int duration = this.offlineDrunk * 25 * this.getHangoverQuality();
        if (!P.use1_14) {
            duration *= 2;
        }
        int amplifier = this.getHangoverQuality() / 3;
        PotionEffectType.SLOW.createEffect(duration, amplifier).apply((LivingEntity)player);
        PotionEffectType.HUNGER.createEffect(duration, amplifier).apply((LivingEntity)player);
    }

    public static void drunkeness() {
        for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
            Player player;
            String name = entry.getKey();
            BPlayer bplayer = entry.getValue();
            if (bplayer.drunkeness <= 30 || bplayer.offlineDrunk != 0 || (player = P.getPlayerfromString(name)) == null) continue;
            bplayer.drunkEffects(player);
            if (!enablePuke) continue;
            bplayer.drunkPuke(player);
        }
    }

    public static void onUpdate() {
        if (!players.isEmpty()) {
            int soberPerMin = 2;
            Iterator<Map.Entry<String, BPlayer>> iter = players.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, BPlayer> entry = iter.next();
                String name = entry.getKey();
                BPlayer bplayer = entry.getValue();
                if (bplayer.drunkeness == soberPerMin) {
                    ++soberPerMin;
                }
                if (!bplayer.drain(P.getPlayerfromString(name), soberPerMin)) continue;
                iter.remove();
            }
        }
    }

    public static void save(ConfigurationSection config) {
        for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
            ConfigurationSection section = config.createSection(entry.getKey());
            BPlayer bPlayer = entry.getValue();
            section.set("quality", (Object)bPlayer.quality);
            section.set("drunk", (Object)bPlayer.drunkeness);
            if (bPlayer.offlineDrunk == 0) continue;
            section.set("offDrunk", (Object)bPlayer.offlineDrunk);
        }
    }

    public int getDrunkeness() {
        return this.drunkeness;
    }

    public void setData(int drunkeness, int quality) {
        this.quality = quality > 0 ? quality * drunkeness : (this.quality == 0 ? 5 * drunkeness : this.getQuality() * drunkeness);
        this.drunkeness = drunkeness;
    }

    public int getQuality() {
        if (this.drunkeness == 0) {
            P.p.errorLog("drunkeness should not be 0!");
            return this.quality;
        }
        if (this.drunkeness < 0) {
            return this.quality;
        }
        return Math.round((float)this.quality / (float)this.drunkeness);
    }

    public int getHangoverQuality() {
        if (this.drunkeness < 0) {
            return this.quality + 11;
        }
        return -this.getQuality() + 11;
    }

    static {
        modAge = true;
        drainItems = new HashMap<Material, Integer>();
    }
}

