/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BEffect;
import com.dre.brewery.BIngredients;
import com.dre.brewery.Brew;
import com.dre.brewery.P;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.item.ItemInfo;
import net.milkbowl.vault.item.Items;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffectType;

public class BRecipe {
    private String[] name;
    private ArrayList<ItemStack> ingredients = new ArrayList();
    private int cookingTime;
    private int distillruns;
    private int distillTime;
    private byte wood;
    private int age;
    private String color;
    private int difficulty;
    private int alcohol;
    private ArrayList<BEffect> effects = new ArrayList();

    public BRecipe(ConfigurationSection configSectionRecipes, String recipeId) {
        String nameList = configSectionRecipes.getString(recipeId + ".name");
        if (nameList != null) {
            String[] name = nameList.split("/");
            if (name.length > 2) {
                this.name = name;
            } else {
                this.name = new String[1];
                this.name[0] = name[0];
            }
        } else {
            return;
        }
        List ingredientsList = configSectionRecipes.getStringList(recipeId + ".ingredients");
        if (ingredientsList != null) {
            for (String item : ingredientsList) {
                String[] ingredParts = item.split("/");
                if (ingredParts.length == 2) {
                    String[] matParts = ingredParts[0].contains(",") ? ingredParts[0].split(",") : (ingredParts[0].contains(":") ? ingredParts[0].split(":") : (ingredParts[0].contains(";") ? ingredParts[0].split(";") : ingredParts[0].split("\\.")));
                    Material mat = Material.matchMaterial((String)matParts[0]);
                    short durability = -1;
                    if (matParts.length == 2) {
                        durability = (short)P.p.parseInt(matParts[1]);
                    }
                    if (mat == null && P.p.hasVault) {
                        try {
                            ItemInfo vaultItem = Items.itemByString((String)matParts[0]);
                            if (vaultItem != null) {
                                mat = vaultItem.getType();
                                if (durability == -1 && vaultItem.getSubTypeId() != 0) {
                                    durability = vaultItem.getSubTypeId();
                                }
                                if (mat.name().contains("LEAVES") && durability > 3) {
                                    durability = (short)(durability - 4);
                                }
                            }
                        }
                        catch (Exception e) {
                            P.p.errorLog("Could not check vault for Item Name");
                            e.printStackTrace();
                        }
                    }
                    if (mat != null) {
                        ItemStack stack = new ItemStack(mat, P.p.parseInt(ingredParts[1]), durability);
                        this.ingredients.add(stack);
                        BIngredients.possibleIngredients.add(mat);
                        continue;
                    }
                    P.p.errorLog("Unknown Material: " + ingredParts[0]);
                    this.ingredients = null;
                    return;
                }
                return;
            }
        }
        this.cookingTime = configSectionRecipes.getInt(recipeId + ".cookingtime", 1);
        this.distillruns = configSectionRecipes.getInt(recipeId + ".distillruns", 0);
        this.distillTime = configSectionRecipes.getInt(recipeId + ".distilltime", 0) * 20;
        this.wood = (byte)configSectionRecipes.getInt(recipeId + ".wood", 0);
        this.age = configSectionRecipes.getInt(recipeId + ".age", 0);
        this.color = configSectionRecipes.getString(recipeId + ".color");
        this.difficulty = configSectionRecipes.getInt(recipeId + ".difficulty", 0);
        this.alcohol = configSectionRecipes.getInt(recipeId + ".alcohol", 0);
        List effectStringList = configSectionRecipes.getStringList(recipeId + ".effects");
        if (effectStringList != null) {
            for (String effectString : effectStringList) {
                BEffect effect = new BEffect(effectString);
                if (effect.isValid()) {
                    this.effects.add(effect);
                    continue;
                }
                P.p.errorLog("Error adding Effect to Recipe: " + this.getName(5));
            }
        }
    }

    public boolean isValid() {
        if (this.name == null || this.name.length < 1) {
            P.p.errorLog("Recipe Name missing or invalid!");
            return false;
        }
        if (this.getName(5) == null || this.getName(5).length() < 1) {
            P.p.errorLog("Recipe Name invalid");
            return false;
        }
        if (this.ingredients == null || this.ingredients.isEmpty()) {
            P.p.errorLog("No ingredients could be loaded for Recipe: " + this.getName(5));
            return false;
        }
        if (this.cookingTime < 1) {
            P.p.errorLog("Invalid cooking time '" + this.cookingTime + "' in Recipe: " + this.getName(5));
            return false;
        }
        if (this.distillruns < 0) {
            P.p.errorLog("Invalid distillruns '" + this.distillruns + "' in Recipe: " + this.getName(5));
            return false;
        }
        if (this.distillTime < 0) {
            P.p.errorLog("Invalid distilltime '" + this.distillTime + "' in Recipe: " + this.getName(5));
            return false;
        }
        if (this.wood < 0 || this.wood > 6) {
            P.p.errorLog("Invalid wood type '" + this.wood + "' in Recipe: " + this.getName(5));
            return false;
        }
        if (this.age < 0) {
            P.p.errorLog("Invalid age time '" + this.age + "' in Recipe: " + this.getName(5));
            return false;
        }
        try {
            Brew.PotionColor.valueOf(this.getColor());
        }
        catch (IllegalArgumentException e) {
            P.p.errorLog("Invalid Color '" + this.color + "' in Recipe: " + this.getName(5));
            return false;
        }
        if (this.difficulty < 0 || this.difficulty > 10) {
            P.p.errorLog("Invalid difficulty '" + this.difficulty + "' in Recipe: " + this.getName(5));
            return false;
        }
        if (this.alcohol < 0) {
            P.p.errorLog("Invalid alcohol '" + this.alcohol + "' in Recipe: " + this.getName(5));
            return false;
        }
        return true;
    }

    public int allowedCountDiff(int count) {
        int allowedCountDiff;
        if (count < 8) {
            count = 8;
        }
        if ((allowedCountDiff = Math.round((float)((11.0 - (double)this.difficulty) * ((double)count / 10.0)))) == 0) {
            return 1;
        }
        return allowedCountDiff;
    }

    public int allowedTimeDiff(int time) {
        int allowedTimeDiff;
        if (time < 8) {
            time = 8;
        }
        if ((allowedTimeDiff = Math.round((float)((11.0 - (double)this.difficulty) * ((double)time / 10.0)))) == 0) {
            return 1;
        }
        return allowedTimeDiff;
    }

    public float getWoodDiff(float wood) {
        return Math.abs(wood - (float)this.wood);
    }

    public boolean isCookingOnly() {
        return this.age == 0 && this.distillruns == 0;
    }

    public boolean needsDistilling() {
        return this.distillruns != 0;
    }

    public boolean needsToAge() {
        return this.age != 0;
    }

    public boolean isMissingIngredients(List<ItemStack> list) {
        if (list.size() < this.ingredients.size()) {
            return true;
        }
        for (ItemStack ingredient : this.ingredients) {
            boolean matches = false;
            for (ItemStack used : list) {
                if (!BRecipe.ingredientsMatch(used, ingredient)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            return true;
        }
        return false;
    }

    public boolean hasExactData(ItemStack item) {
        for (ItemStack ingredient : this.ingredients) {
            if (!ingredient.getType().equals((Object)item.getType())) continue;
            return ingredient.getDurability() != -1;
        }
        return true;
    }

    public static boolean ingredientsMatch(ItemStack usedItem, ItemStack recipeItem) {
        if (!recipeItem.getType().equals((Object)usedItem.getType())) {
            return false;
        }
        return recipeItem.getDurability() == -1 || recipeItem.getDurability() == usedItem.getDurability();
    }

    public ItemStack create(int quality) {
        ItemStack potion = new ItemStack(Material.POTION);
        PotionMeta potionMeta = (PotionMeta)potion.getItemMeta();
        int uid = Brew.generateUID();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.ingredients.size());
        for (ItemStack item : this.ingredients) {
            if (item.getDurability() == -1) {
                list.add(new ItemStack(item.getType(), item.getAmount()));
                continue;
            }
            list.add(item.clone());
        }
        BIngredients bIngredients = new BIngredients(list, this.cookingTime);
        Brew brew = new Brew(uid, bIngredients, quality, this.distillruns, this.getAge(), this.wood, this.getName(5), false, false, true, 0);
        Brew.PotionColor.valueOf(this.getColor()).colorBrew(potionMeta, potion, false);
        potionMeta.setDisplayName(P.p.color("&f" + this.getName(quality)));
        if (!P.use1_14) {
            uid *= 4;
        }
        potionMeta.addCustomEffect(PotionEffectType.REGENERATION.createEffect(uid, 0), true);
        brew.convertLore(potionMeta, false);
        Brew.addOrReplaceEffects(potionMeta, this.effects, quality);
        brew.touch();
        potion.setItemMeta((ItemMeta)potionMeta);
        return potion;
    }

    public int amountOf(ItemStack item) {
        for (ItemStack ingredient : this.ingredients) {
            if (!BRecipe.ingredientsMatch(item, ingredient)) continue;
            return ingredient.getAmount();
        }
        return 0;
    }

    public String getName(int quality) {
        if (this.name.length > 2) {
            if (quality <= 3) {
                return this.name[0];
            }
            if (quality <= 7) {
                return this.name[1];
            }
            return this.name[2];
        }
        return this.name[0];
    }

    public boolean hasName(String name) {
        for (String test : this.name) {
            if (!test.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getDistillRuns() {
        return this.distillruns;
    }

    public int getDistillTime() {
        return this.distillTime;
    }

    public String getColor() {
        if (this.color != null) {
            return this.color.toUpperCase();
        }
        return "BLUE";
    }

    public byte getWood() {
        return this.wood;
    }

    public float getAge() {
        return this.age;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public int getAlcohol() {
        return this.alcohol;
    }

    public ArrayList<BEffect> getEffects() {
        return this.effects;
    }
}

