/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.Brew;
import com.dre.brewery.LegacyUtil;
import com.dre.brewery.P;
import com.dre.brewery.integration.CitadelBarrel;
import com.dre.brewery.integration.GriefPreventionBarrel;
import com.dre.brewery.integration.LWCBarrel;
import com.dre.brewery.integration.LogBlockBarrel;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Barrel
implements InventoryHolder {
    public static CopyOnWriteArrayList<Barrel> barrels = new CopyOnWriteArrayList();
    private static int check = 0;
    private Block spigot;
    private int[] woodsloc = null;
    private int[] stairsloc = null;
    private byte signoffset;
    private boolean checked;
    private Inventory inventory;
    private float time;

    public Barrel(Block spigot, byte signoffset) {
        this.spigot = spigot;
        this.signoffset = signoffset;
    }

    public Barrel(Block spigot, byte sign, String[] st, String[] wo, Map<String, Object> items, float time) {
        Block block;
        this.spigot = spigot;
        this.signoffset = sign;
        this.inventory = this.isLarge() ? Bukkit.createInventory((InventoryHolder)this, (int)27, (String)P.p.languageReader.get("Etc_Barrel", new String[0])) : Bukkit.createInventory((InventoryHolder)this, (int)9, (String)P.p.languageReader.get("Etc_Barrel", new String[0]));
        if (items != null) {
            for (String string : items.keySet()) {
                if (!(items.get(string) instanceof ItemStack)) continue;
                this.inventory.setItem(P.p.parseInt(string), (ItemStack)items.get(string));
            }
        }
        this.time = time;
        int i = 0;
        if (wo.length > 1) {
            this.woodsloc = new int[wo.length];
            for (String wos : wo) {
                this.woodsloc[i] = P.p.parseInt(wos);
                ++i;
            }
            i = 0;
        }
        if (st.length > 1) {
            this.stairsloc = new int[st.length];
            for (String sts : st) {
                this.stairsloc[i] = P.p.parseInt(sts);
                ++i;
            }
        }
        if (this.woodsloc == null && this.stairsloc == null && (block = this.getBrokenBlock(true)) != null) {
            this.remove(block, null);
            return;
        }
        barrels.add(this);
    }

    public static void onUpdate() {
        for (Barrel barrel : barrels) {
            barrel.time = (float)((double)barrel.time + 0.05);
        }
        if (check == 0 && barrels.size() > 0) {
            Barrel random = barrels.get((int)Math.floor(Math.random() * (double)barrels.size()));
            if (random != null) {
                random.checked = false;
            }
            new BarrelCheck().runTaskTimer((Plugin)P.p, 1L, 1L);
        }
    }

    public boolean hasPermsOpen(Player player, PlayerInteractEvent event) {
        Block sign;
        Plugin plugin;
        if (this.isLarge()) {
            if (!player.hasPermission("brewery.openbarrel.big")) {
                P.p.msg((CommandSender)player, P.p.languageReader.get("Error_NoBarrelAccess", new String[0]));
                return false;
            }
        } else if (!player.hasPermission("brewery.openbarrel.small")) {
            P.p.msg((CommandSender)player, P.p.languageReader.get("Error_NoBarrelAccess", new String[0]));
            return false;
        }
        if (P.p.useWG && (plugin = P.p.getServer().getPluginManager().getPlugin("WorldGuard")) != null) {
            try {
                if (!P.p.wg.checkAccess(player, this.spigot, plugin)) {
                    return false;
                }
            }
            catch (Throwable e) {
                P.p.errorLog("Failed to Check WorldGuard for Barrel Open Permissions!");
                P.p.errorLog("Brewery was tested with version 5.8, 6.1 to 7.0 of WorldGuard!");
                P.p.errorLog("Disable the WorldGuard support in the config and do /brew reload");
                e.printStackTrace();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    P.p.msg((CommandSender)player, "&cWorldGuard check Error, Brewery was tested with up to v7.0 of Worldguard");
                    P.p.msg((CommandSender)player, "&cSet &7useWorldGuard: false &cin the config and /brew reload");
                } else {
                    P.p.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return false;
            }
        }
        if (P.p.useGP && P.p.getServer().getPluginManager().isPluginEnabled("GriefPrevention")) {
            try {
                if (!GriefPreventionBarrel.checkAccess(player, this.spigot)) {
                    return false;
                }
            }
            catch (Throwable e) {
                P.p.errorLog("Failed to Check GriefPrevention for Barrel Open Permissions!");
                P.p.errorLog("Brewery was tested with GriefPrevention v14.5 - v16.9");
                P.p.errorLog("Disable the GriefPrevention support in the config and do /brew reload");
                e.printStackTrace();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    P.p.msg((CommandSender)player, "&cGriefPrevention check Error, Brewery was tested with up to v16.9 of GriefPrevention");
                    P.p.msg((CommandSender)player, "&cSet &7useGriefPrevention: false &cin the config and /brew reload");
                } else {
                    P.p.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return false;
            }
        }
        if (event != null && P.p.useLWC && (plugin = P.p.getServer().getPluginManager().getPlugin("LWC")) != null && !LegacyUtil.isSign(event.getClickedBlock().getType()) && !(sign = this.getSignOfSpigot()).equals(event.getClickedBlock())) {
            try {
                return LWCBarrel.checkAccess(player, sign, event, plugin);
            }
            catch (Throwable e) {
                P.p.errorLog("Failed to Check LWC for Barrel Open Permissions!");
                P.p.errorLog("Brewery was tested with version 4.5.0 of LWC!");
                P.p.errorLog("Disable the LWC support in the config and do /brew reload");
                e.printStackTrace();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    P.p.msg((CommandSender)player, "&cLWC check Error, Brewery was tested with up to v4.5.0 of LWC");
                    P.p.msg((CommandSender)player, "&cSet &7useLWC: false &cin the config and /brew reload");
                } else {
                    P.p.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return false;
            }
        }
        if (event != null && P.p.useCitadel && (plugin = P.p.getServer().getPluginManager().getPlugin("Citadel")) != null) {
            try {
                if (LegacyUtil.isSign(event.getClickedBlock().getType())) {
                    return CitadelBarrel.checkAccess(player, this.getSignOfSpigot());
                }
                return CitadelBarrel.checkAccess(player, this.spigot);
            }
            catch (Throwable e) {
                P.p.errorLog("Failed to Check Citadel for Container Access Permissions!");
                P.p.errorLog("Brewery was tested with version 3.9.1 of Citadel!");
                P.p.errorLog("Disable Citadel support in the config and do /brew reload");
                e.printStackTrace();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    P.p.msg((CommandSender)player, "&cCitadel check Error, Brewery was tested with up to v3.9.1 of Citadel");
                } else {
                    P.p.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return false;
            }
        }
        return true;
    }

    public boolean hasPermsDestroy(Player player) {
        if (player == null) {
            this.willDestroy();
            return true;
        }
        if (P.p.useLWC) {
            try {
                return LWCBarrel.checkDestroy(player, this);
            }
            catch (Throwable e) {
                P.p.errorLog("Failed to Check LWC for Barrel Break Permissions!");
                P.p.errorLog("Brewery was tested with version 4.5.0 of LWC!");
                P.p.errorLog("Disable the LWC support in the config and do /brew reload");
                e.printStackTrace();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    P.p.msg((CommandSender)player, "&cLWC check Error, Brewery was tested with up to v4.5.0 of LWC");
                    P.p.msg((CommandSender)player, "&cSet &7useLWC: false &cin the config and /brew reload");
                } else {
                    P.p.msg((CommandSender)player, "&cError breaking Barrel, please report to an Admin!");
                }
                return false;
            }
        }
        return true;
    }

    public void willDestroy() {
        if (P.p.useLWC) {
            try {
                LWCBarrel.remove(this);
            }
            catch (Throwable e) {
                P.p.errorLog("Failed to Remove LWC Lock from Barrel!");
                P.p.errorLog("Brewery was tested with version 4.5.0 of LWC!");
                e.printStackTrace();
            }
        }
    }

    public void open(Player player) {
        if (this.inventory == null) {
            this.inventory = this.isLarge() ? Bukkit.createInventory((InventoryHolder)this, (int)27, (String)P.p.languageReader.get("Etc_Barrel", new String[0])) : Bukkit.createInventory((InventoryHolder)this, (int)9, (String)P.p.languageReader.get("Etc_Barrel", new String[0]));
        } else if (this.time > 0.0f && this.inventory.getViewers().isEmpty() && this.inventory.contains(Material.POTION)) {
            byte wood = this.getWood();
            long loadTime = System.nanoTime();
            for (ItemStack item : this.inventory.getContents()) {
                Brew brew;
                if (item == null || (brew = Brew.get(item)) == null) continue;
                brew.age(item, this.time, wood);
            }
            loadTime = System.nanoTime() - loadTime;
            float ftime = (float)((double)loadTime / 1000000.0);
            P.p.debugLog("opening Barrel with potions (" + ftime + "ms)");
        }
        this.time = 0.0f;
        if (P.p.useLB) {
            try {
                LogBlockBarrel.openBarrel((HumanEntity)player, this.inventory, this.spigot.getLocation());
            }
            catch (Throwable e) {
                P.p.errorLog("Failed to Log Barrel to LogBlock!");
                P.p.errorLog("Brewery was tested with version 1.94 of LogBlock!");
                e.printStackTrace();
            }
        }
        player.openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean hasBlock(Block block) {
        if (block != null) {
            if (LegacyUtil.isWoodPlanks(block.getType())) {
                return this.hasWoodBlock(block);
            }
            if (LegacyUtil.isWoodStairs(block.getType())) {
                return this.hasStairsBlock(block);
            }
        }
        return false;
    }

    public boolean hasWoodBlock(Block block) {
        int x;
        if (this.woodsloc != null && this.spigot.getWorld() != null && this.spigot.getWorld().equals(block.getWorld()) && this.woodsloc.length > 2 && Math.abs((x = block.getX()) - this.woodsloc[0]) < 10) {
            for (int i = 0; i < this.woodsloc.length - 2; i += 3) {
                if (this.woodsloc[i] != x || this.woodsloc[i + 1] != block.getY() || this.woodsloc[i + 2] != block.getZ()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasStairsBlock(Block block) {
        int x;
        if (this.stairsloc != null && this.spigot.getWorld() != null && this.spigot.getWorld().equals(block.getWorld()) && this.stairsloc.length > 2 && Math.abs((x = block.getX()) - this.stairsloc[0]) < 10) {
            for (int i = 0; i < this.stairsloc.length - 2; i += 3) {
                if (this.stairsloc[i] != x || this.stairsloc[i + 1] != block.getY() || this.stairsloc[i + 2] != block.getZ()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSignOfBarrel(byte offset) {
        return offset == 0 || this.signoffset == 0 || this.signoffset == offset;
    }

    public static Barrel get(Block block) {
        if (block == null) {
            return null;
        }
        Material type = block.getType();
        if (LegacyUtil.isFence(type) || LegacyUtil.isSign(type)) {
            return Barrel.getBySpigot(block);
        }
        if (LegacyUtil.isWoodPlanks(type) || LegacyUtil.isWoodStairs(type)) {
            return Barrel.getByWood(block);
        }
        return null;
    }

    public static Barrel getBySpigot(Block sign) {
        Block spigot = Barrel.getSpigotOfSign(sign);
        byte signoffset = 0;
        if (!spigot.equals(sign)) {
            signoffset = (byte)(sign.getY() - spigot.getY());
        }
        for (Barrel barrel : barrels) {
            if (!barrel.isSignOfBarrel(signoffset) || !barrel.spigot.equals(spigot)) continue;
            if (barrel.signoffset == 0 && signoffset != 0) {
                barrel.signoffset = signoffset;
            }
            return barrel;
        }
        return null;
    }

    public static Barrel getByWood(Block wood) {
        block3: {
            block2: {
                if (!LegacyUtil.isWoodPlanks(wood.getType())) break block2;
                for (Barrel barrel : barrels) {
                    if (!barrel.hasWoodBlock(wood)) continue;
                    return barrel;
                }
                break block3;
            }
            if (!LegacyUtil.isWoodStairs(wood.getType())) break block3;
            for (Barrel barrel : barrels) {
                if (!barrel.hasStairsBlock(wood)) continue;
                return barrel;
            }
        }
        return null;
    }

    public static boolean create(Block sign, Player player) {
        Barrel barrel;
        Block spigot = Barrel.getSpigotOfSign(sign);
        byte signoffset = 0;
        if (!spigot.equals(sign)) {
            signoffset = (byte)(sign.getY() - spigot.getY());
        }
        if ((barrel = Barrel.getBySpigot(spigot)) == null) {
            barrel = new Barrel(spigot, signoffset);
            if (barrel.getBrokenBlock(true) == null) {
                if (LegacyUtil.isSign(spigot.getType())) {
                    if (!player.hasPermission("brewery.createbarrel.small")) {
                        P.p.msg((CommandSender)player, P.p.languageReader.get("Perms_NoSmallBarrelCreate", new String[0]));
                        return false;
                    }
                } else if (!player.hasPermission("brewery.createbarrel.big")) {
                    P.p.msg((CommandSender)player, P.p.languageReader.get("Perms_NoBigBarrelCreate", new String[0]));
                    return false;
                }
                barrels.add(barrel);
                return true;
            }
        } else if (barrel.signoffset == 0 && signoffset != 0) {
            barrel.signoffset = signoffset;
            return true;
        }
        return false;
    }

    public void remove(Block broken, Player breaker) {
        if (this.inventory != null) {
            for (HumanEntity human : this.inventory.getViewers()) {
                human.closeInventory();
            }
            ItemStack[] items = this.inventory.getContents();
            if (P.p.useLB && breaker != null) {
                try {
                    LogBlockBarrel.breakBarrel(breaker, items, this.spigot.getLocation());
                }
                catch (Throwable e) {
                    P.p.errorLog("Failed to Log Barrel-break to LogBlock!");
                    P.p.errorLog("Brewery was tested with version 1.94 of LogBlock!");
                    e.printStackTrace();
                }
            }
            for (ItemStack item : items) {
                if (item == null) continue;
                Brew brew = Brew.get(item);
                if (brew != null) {
                    brew.age(item, this.time, this.getWood());
                    PotionMeta meta = (PotionMeta)item.getItemMeta();
                    if (Brew.hasColorLore(meta).booleanValue()) {
                        brew.convertLore(meta, false);
                        item.setItemMeta((ItemMeta)meta);
                    }
                }
                if (broken != null) {
                    broken.getWorld().dropItem(broken.getLocation(), item);
                    continue;
                }
                this.spigot.getWorld().dropItem(this.spigot.getLocation(), item);
            }
        }
        barrels.remove(this);
    }

    public static void onUnload(String name) {
        for (Barrel barrel : barrels) {
            if (!barrel.spigot.getWorld().getName().equals(name)) continue;
            barrels.remove(barrel);
        }
    }

    public void destroySign() {
        this.signoffset = 0;
    }

    public static void save(ConfigurationSection config, ConfigurationSection oldData) {
        P.p.createWorldSections(config);
        if (!barrels.isEmpty()) {
            int id = 0;
            for (Barrel barrel : barrels) {
                String worldName = barrel.spigot.getWorld().getName();
                String prefix = worldName.startsWith("DXL_") ? P.p.getDxlName(worldName) + "." + id : barrel.spigot.getWorld().getUID().toString() + "." + id;
                config.set(prefix + ".spigot", (Object)(barrel.spigot.getX() + "/" + barrel.spigot.getY() + "/" + barrel.spigot.getZ()));
                if (barrel.signoffset != 0) {
                    config.set(prefix + ".sign", (Object)barrel.signoffset);
                }
                if (barrel.stairsloc != null && barrel.stairsloc.length > 0) {
                    StringBuilder st = new StringBuilder();
                    for (int i : barrel.stairsloc) {
                        st.append(i).append(",");
                    }
                    config.set(prefix + ".st", (Object)st.substring(0, st.length() - 1));
                }
                if (barrel.woodsloc != null && barrel.woodsloc.length > 0) {
                    StringBuilder wo = new StringBuilder();
                    for (int i : barrel.woodsloc) {
                        wo.append(i).append(",");
                    }
                    config.set(prefix + ".wo", (Object)wo.substring(0, wo.length() - 1));
                }
                if (barrel.inventory != null) {
                    ConfigurationSection invConfig = null;
                    for (int slot = 0; slot < barrel.inventory.getSize(); ++slot) {
                        ItemStack item = barrel.inventory.getItem(slot);
                        if (item == null) continue;
                        if (invConfig == null) {
                            if (barrel.time != 0.0f) {
                                config.set(prefix + ".time", (Object)Float.valueOf(barrel.time));
                            }
                            invConfig = config.createSection(prefix + ".inv");
                        }
                        invConfig.set(slot + "", (Object)item);
                    }
                }
                ++id;
            }
        }
        if (oldData != null) {
            for (String uuid : oldData.getKeys(false)) {
                if (config.contains(uuid)) continue;
                config.set(uuid, oldData.get(uuid));
            }
        }
    }

    public static int getDirection(Block spigot) {
        int direction = 0;
        Material type = spigot.getRelative(0, 0, 1).getType();
        if (LegacyUtil.isWoodPlanks(type) || LegacyUtil.isWoodStairs(type)) {
            direction = 3;
        }
        if (LegacyUtil.isWoodPlanks(type = spigot.getRelative(0, 0, -1).getType()) || LegacyUtil.isWoodStairs(type)) {
            if (direction == 0) {
                direction = 4;
            } else {
                return 0;
            }
        }
        if (LegacyUtil.isWoodPlanks(type = spigot.getRelative(1, 0, 0).getType()) || LegacyUtil.isWoodStairs(type)) {
            if (direction == 0) {
                direction = 1;
            } else {
                return 0;
            }
        }
        if (LegacyUtil.isWoodPlanks(type = spigot.getRelative(-1, 0, 0).getType()) || LegacyUtil.isWoodStairs(type)) {
            if (direction == 0) {
                direction = 2;
            } else {
                return 0;
            }
        }
        return direction;
    }

    public boolean isLarge() {
        return !LegacyUtil.isSign(this.spigot.getType());
    }

    public byte getWood() {
        Block wood;
        switch (Barrel.getDirection(this.spigot)) {
            case 0: {
                return 0;
            }
            case 1: {
                wood = this.spigot.getRelative(1, 0, 0);
                break;
            }
            case 2: {
                wood = this.spigot.getRelative(-1, 0, 0);
                break;
            }
            case 3: {
                wood = this.spigot.getRelative(0, 0, 1);
                break;
            }
            default: {
                wood = this.spigot.getRelative(0, 0, -1);
            }
        }
        try {
            return LegacyUtil.getWoodType(wood);
        }
        catch (NoClassDefFoundError | NoSuchFieldError noSuchFieldError) {
            return 0;
        }
    }

    public Block getSignOfSpigot() {
        if (this.signoffset != 0) {
            if (LegacyUtil.isSign(this.spigot.getType())) {
                return this.spigot;
            }
            if (LegacyUtil.isSign(this.spigot.getRelative(0, (int)this.signoffset, 0).getType())) {
                return this.spigot.getRelative(0, (int)this.signoffset, 0);
            }
            this.signoffset = 0;
        }
        return this.spigot;
    }

    public static Block getSpigotOfSign(Block block) {
        for (int y = -2; y <= 1; ++y) {
            Block relative = block.getRelative(0, y, 0);
            if (!LegacyUtil.isFence(relative.getType())) continue;
            return relative;
        }
        return block;
    }

    public Block getBrokenBlock(boolean force) {
        if (force || this.spigot.getChunk().isLoaded()) {
            this.spigot = Barrel.getSpigotOfSign(this.spigot);
            if (LegacyUtil.isSign(this.spigot.getType())) {
                return this.checkSBarrel();
            }
            return this.checkLBarrel();
        }
        return null;
    }

    public Block checkSBarrel() {
        int endZ;
        int startZ;
        int endX;
        int startX;
        int direction = Barrel.getDirection(this.spigot);
        if (direction == 0) {
            return this.spigot;
        }
        ArrayList<Integer> stairs = new ArrayList<Integer>();
        if (direction == 1) {
            startX = 1;
            endX = startX + 1;
            startZ = -1;
            endZ = 0;
        } else if (direction == 2) {
            startX = -2;
            endX = startX + 1;
            startZ = 0;
            endZ = 1;
        } else if (direction == 3) {
            startX = 0;
            endX = 1;
            startZ = 1;
            endZ = startZ + 1;
        } else {
            startX = -1;
            endX = 0;
            startZ = -2;
            endZ = startZ + 1;
        }
        int x = startX;
        int z = startZ;
        for (int y = 0; y <= 1; ++y) {
            while (x <= endX) {
                while (z <= endZ) {
                    Block block = this.spigot.getRelative(x, y, z);
                    Material type = block.getType();
                    if (LegacyUtil.isWoodStairs(type)) {
                        if (y == 0 && !LegacyUtil.areStairsInverted(block)) {
                            return block;
                        }
                        stairs.add(block.getX());
                        stairs.add(block.getY());
                        stairs.add(block.getZ());
                        ++z;
                        continue;
                    }
                    return this.spigot.getRelative(x, y, z);
                }
                z = startZ;
                ++x;
            }
            z = startZ;
            x = startX;
        }
        this.stairsloc = ArrayUtils.toPrimitive((Integer[])stairs.toArray(new Integer[0]));
        return null;
    }

    public Block checkLBarrel() {
        int endZ;
        int startZ;
        int endX;
        int startX;
        int direction = Barrel.getDirection(this.spigot);
        if (direction == 0) {
            return this.spigot;
        }
        ArrayList<Integer> stairs = new ArrayList<Integer>();
        ArrayList<Integer> woods = new ArrayList<Integer>();
        if (direction == 1) {
            startX = 1;
            endX = startX + 3;
            startZ = -1;
            endZ = 1;
        } else if (direction == 2) {
            startX = -4;
            endX = startX + 3;
            startZ = -1;
            endZ = 1;
        } else if (direction == 3) {
            startX = -1;
            endX = 1;
            startZ = 1;
            endZ = startZ + 3;
        } else {
            startX = -1;
            endX = 1;
            startZ = -4;
            endZ = startZ + 3;
        }
        int x = startX;
        int z = startZ;
        for (int y = 0; y <= 2; ++y) {
            while (x <= endX) {
                while (z <= endZ) {
                    Block block = this.spigot.getRelative(x, y, z);
                    Material type = block.getType();
                    if (direction == 1 || direction == 2) {
                        if (y == 1 && z == 0) {
                            if (x == -1 || x == -4 || x == 1 || x == 4) {
                                woods.add(block.getX());
                                woods.add(block.getY());
                                woods.add(block.getZ());
                            }
                            ++z;
                            continue;
                        }
                    } else if (y == 1 && x == 0) {
                        if (z == -1 || z == -4 || z == 1 || z == 4) {
                            woods.add(block.getX());
                            woods.add(block.getY());
                            woods.add(block.getZ());
                        }
                        ++z;
                        continue;
                    }
                    if (LegacyUtil.isWoodPlanks(type) || LegacyUtil.isWoodStairs(type)) {
                        if (LegacyUtil.isWoodPlanks(type)) {
                            woods.add(block.getX());
                            woods.add(block.getY());
                            woods.add(block.getZ());
                        } else {
                            stairs.add(block.getX());
                            stairs.add(block.getY());
                            stairs.add(block.getZ());
                        }
                        ++z;
                        continue;
                    }
                    return block;
                }
                z = startZ;
                ++x;
            }
            z = startZ;
            x = startX;
        }
        this.stairsloc = ArrayUtils.toPrimitive((Integer[])stairs.toArray(new Integer[0]));
        this.woodsloc = ArrayUtils.toPrimitive((Integer[])woods.toArray(new Integer[0]));
        return null;
    }

    public static class BarrelCheck
    extends BukkitRunnable {
        public void run() {
            boolean repeat = true;
            while (repeat) {
                if (check < barrels.size()) {
                    Barrel barrel = barrels.get(check);
                    if (!barrel.checked) {
                        Block broken = barrel.getBrokenBlock(false);
                        if (broken != null) {
                            P.p.debugLog("Barrel at " + broken.getWorld().getName() + "/" + broken.getX() + "/" + broken.getY() + "/" + broken.getZ() + " has been destroyed unexpectedly, contents will drop");
                            barrel.willDestroy();
                            barrel.remove(broken, null);
                        } else {
                            barrel.checked = true;
                        }
                        repeat = false;
                    }
                    check++;
                    continue;
                }
                check = 0;
                repeat = false;
                this.cancel();
            }
        }
    }
}

