/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BEffect;
import com.dre.brewery.BIngredients;
import com.dre.brewery.BRecipe;
import com.dre.brewery.P;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class Brew {
    public static Map<Integer, Brew> potions = new HashMap<Integer, Brew>();
    public static long installTime = System.currentTimeMillis();
    public static Boolean colorInBarrels;
    public static Boolean colorInBrewer;
    private BIngredients ingredients;
    private int quality;
    private int distillRuns;
    private float ageTime;
    private float wood;
    private BRecipe currentRecipe;
    private boolean unlabeled;
    private boolean persistent;
    private boolean stat;
    private int lastUpdate;

    public Brew(int uid, BIngredients ingredients) {
        this.ingredients = ingredients;
        this.touch();
        potions.put(uid, this);
    }

    public Brew(int uid, int quality, BRecipe recipe, BIngredients ingredients) {
        this.ingredients = ingredients;
        this.quality = quality;
        this.currentRecipe = recipe;
        this.touch();
        potions.put(uid, this);
    }

    public Brew(int uid, BIngredients ingredients, int quality, int distillRuns, float ageTime, float wood, String recipe, boolean unlabeled, boolean persistent, boolean stat, int lastUpdate) {
        potions.put(uid, this);
        this.ingredients = ingredients;
        this.quality = quality;
        this.distillRuns = distillRuns;
        this.ageTime = ageTime;
        this.wood = wood;
        this.unlabeled = unlabeled;
        this.persistent = persistent;
        this.stat = stat;
        this.lastUpdate = lastUpdate;
        this.setRecipeFromString(recipe);
    }

    public static Brew get(int uid) {
        if (uid < -1) {
            if (!potions.containsKey(uid)) {
                P.p.errorLog("Database failure! unable to find UID " + uid + " of a custom Potion!");
                return null;
            }
        } else {
            return null;
        }
        return potions.get(uid);
    }

    public static Brew get(PotionMeta meta) {
        return Brew.get(Brew.getUID(meta));
    }

    public static Brew get(ItemStack item) {
        if (item.getType() == Material.POTION && item.hasItemMeta()) {
            return Brew.get((PotionMeta)item.getItemMeta());
        }
        return null;
    }

    public static int getUID(ItemStack item) {
        return Brew.getUID((PotionMeta)item.getItemMeta());
    }

    public static int getUID(PotionMeta potionMeta) {
        if (potionMeta.hasCustomEffect(PotionEffectType.REGENERATION)) {
            for (PotionEffect effect : potionMeta.getCustomEffects()) {
                if (!effect.getType().equals((Object)PotionEffectType.REGENERATION) || effect.getDuration() >= -1) continue;
                return effect.getDuration();
            }
        }
        return 0;
    }

    public static int generateUID() {
        int uid = -2;
        while (potions.containsKey(uid)) {
            --uid;
        }
        return uid;
    }

    public boolean setRecipeFromString(String name) {
        this.currentRecipe = null;
        if (name != null && !name.equals("")) {
            for (BRecipe recipe : BIngredients.recipes) {
                if (!recipe.getName(5).equalsIgnoreCase(name)) continue;
                this.currentRecipe = recipe;
                return true;
            }
            if (this.quality > 0) {
                this.currentRecipe = this.ingredients.getBestRecipe(this.wood, this.ageTime, this.distillRuns > 0);
                if (this.currentRecipe != null) {
                    if (!this.stat) {
                        this.quality = this.calcQuality();
                    }
                    P.p.log("Brew was made from Recipe: '" + name + "' which could not be found. '" + this.currentRecipe.getName(5) + "' used instead!");
                    return true;
                }
                P.p.errorLog("Brew was made from Recipe: '" + name + "' which could not be found!");
            }
        }
        return false;
    }

    public boolean reloadRecipe() {
        return this.currentRecipe == null || this.setRecipeFromString(this.currentRecipe.getName(5));
    }

    public ItemStack copy(ItemStack item) {
        ItemStack copy = item.clone();
        int uid = Brew.generateUID();
        this.clone(uid);
        PotionMeta meta = (PotionMeta)copy.getItemMeta();
        if (!P.use1_14) {
            uid *= 4;
        }
        meta.addCustomEffect(PotionEffectType.REGENERATION.createEffect(uid, 0), true);
        copy.setItemMeta((ItemMeta)meta);
        return copy;
    }

    public Brew clone(int uid) {
        Brew brew = new Brew(uid, this.quality, this.currentRecipe, this.ingredients);
        brew.distillRuns = this.distillRuns;
        brew.ageTime = this.ageTime;
        brew.unlabeled = this.unlabeled;
        if (!brew.persistent) {
            brew.stat = this.stat;
        }
        return brew;
    }

    public void remove(ItemStack item) {
        if (!this.persistent) {
            potions.remove(Brew.getUID(item));
        }
    }

    public int calcAlcohol() {
        if (this.quality == 0) {
            int badAlc = 0;
            if (this.distillRuns > 1) {
                badAlc = this.distillRuns;
            }
            if (this.ageTime > 10.0f) {
                badAlc += 5;
            } else if (this.ageTime > 2.0f) {
                badAlc += 3;
            }
            if (this.currentRecipe != null) {
                return badAlc;
            }
            return badAlc / 2;
        }
        if (this.currentRecipe != null) {
            int alc = this.currentRecipe.getAlcohol();
            if (this.currentRecipe.needsDistilling()) {
                if (this.distillRuns == 0) {
                    return 0;
                }
                alc = (int)((double)alc * (1.0 - (double)(10 - this.quality) * 0.04));
                alc /= 2;
                alc = (int)((float)alc * (1.0f + (float)this.distillRuns / (float)this.currentRecipe.getDistillRuns()));
            } else {
                alc = (int)((double)alc * ((double)this.quality / 10.0));
            }
            if (alc > 0) {
                return alc;
            }
        }
        return 0;
    }

    public int calcQuality() {
        float quality = this.ingredients.getIngredientQuality(this.currentRecipe) + this.ingredients.getCookingQuality(this.currentRecipe, this.distillRuns > 0);
        if (this.currentRecipe.needsToAge() || (double)this.ageTime > 0.5) {
            quality += (float)(this.ingredients.getWoodQuality(this.currentRecipe, this.wood) + this.ingredients.getAgeQuality(this.currentRecipe, this.ageTime));
            quality /= 4.0f;
        } else {
            quality /= 2.0f;
        }
        return Math.round(quality);
    }

    public int getQuality() {
        return this.quality;
    }

    public boolean canDistill() {
        if (this.stat) {
            return false;
        }
        if (this.currentRecipe != null) {
            return this.currentRecipe.getDistillRuns() > this.distillRuns;
        }
        return this.distillRuns < 6;
    }

    public ArrayList<BEffect> getEffects() {
        if (this.currentRecipe != null && this.quality > 0) {
            return this.currentRecipe.getEffects();
        }
        return null;
    }

    public void unLabel(ItemStack item) {
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        if (meta.hasLore()) {
            if (this.distillRuns > 0) {
                Brew.addOrReplaceLore(meta, P.p.color("&7"), P.p.languageReader.get("Brew_Distilled", new String[0]));
            }
            if (this.ageTime >= 1.0f) {
                Brew.addOrReplaceLore(meta, P.p.color("&7"), P.p.languageReader.get("Brew_BarrelRiped", new String[0]));
            }
            item.setItemMeta((ItemMeta)meta);
        }
        this.unlabeled = true;
    }

    public void touch() {
        this.lastUpdate = (int)((double)(System.currentTimeMillis() - installTime) / 3600000.0);
    }

    public int getDistillRuns() {
        return this.distillRuns;
    }

    public float getAgeTime() {
        return this.ageTime;
    }

    public BRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void makePersistent() {
        this.persistent = true;
    }

    public void removePersistence() {
        this.persistent = false;
    }

    public boolean isStatic() {
        return this.stat;
    }

    public void setStatic(boolean stat, ItemStack potion) {
        this.stat = stat;
        if (this.currentRecipe != null && this.canDistill()) {
            if (stat) {
                PotionColor.valueOf(this.currentRecipe.getColor()).colorBrew((PotionMeta)potion.getItemMeta(), potion, false);
            } else {
                PotionColor.valueOf(this.currentRecipe.getColor()).colorBrew((PotionMeta)potion.getItemMeta(), potion, true);
            }
        }
    }

    public int getLastUpdate() {
        return this.lastUpdate;
    }

    public static void distillAll(BrewerInventory inv, Brew[] contents) {
        for (int slot = 0; slot < 3; ++slot) {
            if (contents[slot] == null) continue;
            ItemStack slotItem = inv.getItem(slot);
            PotionMeta potionMeta = (PotionMeta)slotItem.getItemMeta();
            contents[slot].distillSlot(slotItem, potionMeta);
        }
    }

    public void distillSlot(ItemStack slotItem, PotionMeta potionMeta) {
        if (this.stat) {
            return;
        }
        ++this.distillRuns;
        BRecipe recipe = this.ingredients.getdistillRecipe(this.wood, this.ageTime);
        if (recipe != null) {
            this.currentRecipe = recipe;
            this.quality = this.calcQuality();
            Brew.addOrReplaceEffects(potionMeta, this.getEffects(), this.quality);
            potionMeta.setDisplayName(P.p.color("&f" + recipe.getName(this.quality)));
            PotionColor.valueOf(recipe.getColor()).colorBrew(potionMeta, slotItem, this.canDistill());
        } else {
            this.quality = 0;
            Brew.removeEffects(potionMeta);
            potionMeta.setDisplayName(P.p.color("&f" + P.p.languageReader.get("Brew_DistillUndefined", new String[0])));
            PotionColor.GREY.colorBrew(potionMeta, slotItem, this.canDistill());
        }
        if (this.currentRecipe != null && colorInBrewer != Brew.hasColorLore(potionMeta)) {
            this.convertLore(potionMeta, colorInBrewer);
        }
        String prefix = P.p.color("&7");
        if (colorInBrewer.booleanValue() && this.currentRecipe != null) {
            prefix = Brew.getQualityColor(this.ingredients.getDistillQuality(recipe, this.distillRuns));
        }
        this.updateDistillLore(prefix, potionMeta);
        this.touch();
        slotItem.setItemMeta((ItemMeta)potionMeta);
    }

    public int getDistillTimeNextRun() {
        if (!this.canDistill()) {
            return -1;
        }
        if (this.currentRecipe != null) {
            return this.currentRecipe.getDistillTime();
        }
        BRecipe recipe = this.ingredients.getdistillRecipe(this.wood, this.ageTime);
        if (recipe != null) {
            return recipe.getDistillTime();
        }
        return 0;
    }

    public void age(ItemStack item, float time, byte woodType) {
        if (this.stat) {
            return;
        }
        PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
        this.ageTime += time;
        if ((double)this.ageTime > 0.5) {
            if (this.wood == 0.0f) {
                this.wood = woodType;
            } else if (this.wood != (float)woodType) {
                this.woodShift(time, woodType);
            }
            BRecipe recipe = this.ingredients.getAgeRecipe(this.wood, this.ageTime, this.distillRuns > 0);
            if (recipe != null) {
                this.currentRecipe = recipe;
                this.quality = this.calcQuality();
                Brew.addOrReplaceEffects(potionMeta, this.getEffects(), this.quality);
                potionMeta.setDisplayName(P.p.color("&f" + recipe.getName(this.quality)));
                PotionColor.valueOf(recipe.getColor()).colorBrew(potionMeta, item, this.canDistill());
            } else {
                this.quality = 0;
                Brew.removeEffects(potionMeta);
                potionMeta.setDisplayName(P.p.color("&f" + P.p.languageReader.get("Brew_BadPotion", new String[0])));
                PotionColor.GREY.colorBrew(potionMeta, item, this.canDistill());
            }
        }
        if (this.currentRecipe != null && colorInBarrels != Brew.hasColorLore(potionMeta)) {
            this.convertLore(potionMeta, colorInBarrels);
        }
        if (this.ageTime >= 1.0f) {
            String prefix = P.p.color("&7");
            if (colorInBarrels.booleanValue() && this.currentRecipe != null) {
                prefix = Brew.getQualityColor(this.ingredients.getAgeQuality(this.currentRecipe, this.ageTime));
            }
            this.updateAgeLore(prefix, potionMeta);
        }
        if ((double)this.ageTime > 0.5 && colorInBarrels.booleanValue() && !this.unlabeled && this.currentRecipe != null) {
            this.updateWoodLore(potionMeta);
        }
        this.touch();
        item.setItemMeta((ItemMeta)potionMeta);
    }

    public void woodShift(float time, byte to) {
        int factor = 1;
        if (this.ageTime > 5.0f) {
            factor = 2;
        } else if (this.ageTime > 10.0f) {
            factor = 2;
            factor = (byte)(factor + Math.round(this.ageTime / 10.0f));
        }
        if (this.wood > (float)to) {
            this.wood -= time / (float)factor;
            if (this.wood < (float)to) {
                this.wood = to;
            }
        } else {
            this.wood += time / (float)factor;
            if (this.wood > (float)to) {
                this.wood = to;
            }
        }
    }

    public void convertLore(PotionMeta meta, Boolean toQuality) {
        String lore;
        int quality;
        if (this.currentRecipe == null) {
            return;
        }
        meta.setLore(null);
        String prefix = P.p.color("&7");
        if (toQuality.booleanValue() && !this.unlabeled) {
            quality = this.ingredients.getIngredientQuality(this.currentRecipe);
            prefix = Brew.getQualityColor(quality);
            lore = P.p.languageReader.get("Brew_Ingredients", new String[0]);
            Brew.addOrReplaceLore(meta, prefix, lore);
        }
        if (toQuality.booleanValue() && !this.unlabeled && this.distillRuns > 0 == this.currentRecipe.needsDistilling()) {
            quality = this.ingredients.getCookingQuality(this.currentRecipe, this.distillRuns > 0);
            prefix = Brew.getQualityColor(quality) + this.ingredients.getCookedTime() + " " + P.p.languageReader.get("Brew_minute", new String[0]);
            if (this.ingredients.getCookedTime() > 1) {
                prefix = prefix + P.p.languageReader.get("Brew_MinutePluralPostfix", new String[0]);
            }
            lore = " " + P.p.languageReader.get("Brew_fermented", new String[0]);
            Brew.addOrReplaceLore(meta, prefix, lore);
        }
        if (this.distillRuns > 0) {
            if (toQuality.booleanValue()) {
                quality = this.ingredients.getDistillQuality(this.currentRecipe, this.distillRuns);
                prefix = Brew.getQualityColor(quality);
            }
            this.updateDistillLore(prefix, meta);
        }
        if (this.ageTime >= 1.0f) {
            if (toQuality.booleanValue()) {
                quality = this.ingredients.getAgeQuality(this.currentRecipe, this.ageTime);
                prefix = Brew.getQualityColor(quality);
            }
            this.updateAgeLore(prefix, meta);
        }
        if (toQuality.booleanValue() && !this.unlabeled && (double)this.ageTime > 0.5) {
            this.updateWoodLore(meta);
        }
    }

    public void updateDistillLore(String prefix, PotionMeta meta) {
        if (!this.unlabeled && this.distillRuns > 1) {
            prefix = prefix + this.distillRuns + P.p.languageReader.get("Brew_-times", new String[0]) + " ";
        }
        Brew.addOrReplaceLore(meta, prefix, P.p.languageReader.get("Brew_Distilled", new String[0]));
    }

    public void updateAgeLore(String prefix, PotionMeta meta) {
        if (!this.unlabeled) {
            prefix = this.ageTime >= 1.0f && this.ageTime < 2.0f ? prefix + P.p.languageReader.get("Brew_OneYear", new String[0]) + " " : (this.ageTime < 201.0f ? prefix + (int)Math.floor(this.ageTime) + " " + P.p.languageReader.get("Brew_Years", new String[0]) + " " : prefix + P.p.languageReader.get("Brew_HundredsOfYears", new String[0]) + " ");
        }
        Brew.addOrReplaceLore(meta, prefix, P.p.languageReader.get("Brew_BarrelRiped", new String[0]));
    }

    public void updateWoodLore(PotionMeta meta) {
        List existingLore;
        int index;
        if (this.currentRecipe.getWood() > 0) {
            int quality = this.ingredients.getWoodQuality(this.currentRecipe, this.wood);
            Brew.addOrReplaceLore(meta, Brew.getQualityColor(quality), P.p.languageReader.get("Brew_Woodtype", new String[0]));
        } else if (meta.hasLore() && (index = Brew.indexOfSubstring(existingLore = meta.getLore(), P.p.languageReader.get("Brew_Woodtype", new String[0]))) > -1) {
            existingLore.remove(index);
            meta.setLore(existingLore);
        }
    }

    public static void addOrReplaceLore(PotionMeta meta, String prefix, String lore) {
        if (meta.hasLore()) {
            List existingLore = meta.getLore();
            int index = Brew.indexOfSubstring(existingLore, lore);
            if (index > -1) {
                existingLore.set(index, prefix + lore);
            } else {
                existingLore.add(prefix + lore);
            }
            meta.setLore(existingLore);
            return;
        }
        ArrayList<String> newLore = new ArrayList<String>();
        newLore.add("");
        newLore.add(prefix + lore);
        meta.setLore(newLore);
    }

    public static void addOrReplaceEffects(PotionMeta meta, ArrayList<BEffect> effects, int quality) {
        if (!P.use1_9 && effects != null) {
            for (BEffect effect : effects) {
                if (effect.isHidden()) continue;
                effect.writeInto(meta, quality);
            }
        }
    }

    public static void removeEffects(PotionMeta meta) {
        if (meta.hasCustomEffects()) {
            for (PotionEffect effect : meta.getCustomEffects()) {
                PotionEffectType type = effect.getType();
                if (type.equals((Object)PotionEffectType.REGENERATION)) continue;
                meta.removeCustomEffect(type);
            }
        }
    }

    public static int indexOfSubstring(List<String> list, String substring) {
        for (int index = 0; index < list.size(); ++index) {
            String string = list.get(index);
            if (!string.contains(substring)) continue;
            return index;
        }
        return -1;
    }

    public static Boolean hasColorLore(PotionMeta meta) {
        return meta.hasLore() && meta.getLore().size() > 1 && !((String)meta.getLore().get(1)).startsWith(P.p.color("&7"));
    }

    public static String getQualityColor(int quality) {
        String color = quality > 8 ? "&a" : (quality > 6 ? "&e" : (quality > 4 ? "&6" : (quality > 2 ? "&c" : "&4")));
        return P.p.color(color);
    }

    public static void save(ConfigurationSection config) {
        for (Map.Entry<Integer, Brew> entry : potions.entrySet()) {
            int uid = entry.getKey();
            Brew brew = entry.getValue();
            ConfigurationSection idConfig = config.createSection("" + uid);
            if (brew.quality != 0) {
                idConfig.set("quality", (Object)brew.quality);
            }
            if (brew.distillRuns != 0) {
                idConfig.set("distillRuns", (Object)brew.distillRuns);
            }
            if (brew.ageTime != 0.0f) {
                idConfig.set("ageTime", (Object)Float.valueOf(brew.ageTime));
            }
            if (brew.wood != -1.0f) {
                idConfig.set("wood", (Object)Float.valueOf(brew.wood));
            }
            if (brew.currentRecipe != null) {
                idConfig.set("recipe", (Object)brew.currentRecipe.getName(5));
            }
            if (brew.unlabeled) {
                idConfig.set("unlabeled", (Object)true);
            }
            if (brew.persistent) {
                idConfig.set("persist", (Object)true);
            }
            if (brew.stat) {
                idConfig.set("stat", (Object)true);
            }
            if (brew.lastUpdate > 0) {
                idConfig.set("lastUpdate", (Object)brew.lastUpdate);
            }
            idConfig.set("ingId", (Object)brew.ingredients.save(config.getParent()));
        }
    }

    public static enum PotionColor {
        PINK(1, PotionType.REGEN, Color.FUCHSIA),
        CYAN(2, PotionType.SPEED, Color.AQUA),
        ORANGE(3, PotionType.FIRE_RESISTANCE, Color.ORANGE),
        GREEN(4, PotionType.POISON, Color.GREEN),
        BRIGHT_RED(5, PotionType.INSTANT_HEAL, Color.fromRGB((int)255, (int)0, (int)0)),
        BLUE(6, PotionType.NIGHT_VISION, Color.NAVY),
        BLACK(8, PotionType.WEAKNESS, Color.BLACK),
        RED(9, PotionType.STRENGTH, Color.fromRGB((int)196, (int)0, (int)0)),
        GREY(10, PotionType.SLOWNESS, Color.GRAY),
        WATER(11, (PotionType)(P.use1_9 ? PotionType.WATER_BREATHING : null), Color.BLUE),
        DARK_RED(12, PotionType.INSTANT_DAMAGE, Color.fromRGB((int)128, (int)0, (int)0)),
        BRIGHT_GREY(14, PotionType.INVISIBILITY, Color.SILVER);

        private final int colorId;
        private final PotionType type;
        private final Color color;

        private PotionColor(int colorId, PotionType type, Color color) {
            this.colorId = colorId;
            this.type = type;
            this.color = color;
        }

        public short getColorId(boolean destillable) {
            if (destillable) {
                return (short)(this.colorId + 64);
            }
            return (short)(this.colorId + 32);
        }

        public PotionType getType() {
            return this.type;
        }

        public Color getColor() {
            return this.color;
        }

        public void colorBrew(PotionMeta meta, ItemStack potion, boolean destillable) {
            if (P.use1_9) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                if (P.use1_11) {
                    meta.setColor(this.getColor());
                } else {
                    meta.setBasePotionData(new PotionData(this.getType()));
                }
            } else {
                potion.setDurability(this.getColorId(destillable));
            }
        }
    }
}

