/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.P;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.material.Cauldron;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Stairs;
import org.bukkit.material.Tree;
import org.bukkit.material.Wood;

public class LegacyUtil {
    private static Method GET_MATERIAL;
    private static Method GET_BLOCK_TYPE_ID_AT;
    private static Method SET_DATA;
    public static final Material MAGMA;
    public static final Material CLOCK;
    public static final Material OAK_STAIRS;
    public static final Material SPRUCE_STAIRS;
    public static final Material BIRCH_STAIRS;
    public static final Material JUNGLE_STAIRS;
    public static final Material ACACIA_STAIRS;
    public static final Material DARK_OAK_STAIRS;
    public static final List<Material> PLANKS;
    public static final List<Material> FENCES;
    public static final Material STATIONARY_LAVA;
    public static final Material SIGN_POST;
    public static final Material WOOD;

    private static Material get(String name) {
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Material get(String newName, String oldName) {
        try {
            return Material.valueOf((String)(P.use1_13 ? newName : oldName));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean isWoodPlanks(Material type) {
        return WOOD != null && type == WOOD || PLANKS.contains(type);
    }

    public static boolean isWoodStairs(Material type) {
        return type == OAK_STAIRS || type == SPRUCE_STAIRS || type == BIRCH_STAIRS || type == JUNGLE_STAIRS || type == ACACIA_STAIRS && ACACIA_STAIRS != null || type == DARK_OAK_STAIRS && DARK_OAK_STAIRS != null;
    }

    public static boolean isFence(Material type) {
        return FENCES.contains(type);
    }

    public static boolean isSign(Material type) {
        return type.name().endsWith("SIGN") || !P.use1_13 && type == SIGN_POST;
    }

    public static boolean isLava(Material type) {
        return type == Material.LAVA || !P.use1_13 && type == STATIONARY_LAVA || MAGMA != null && type == MAGMA;
    }

    public static boolean areStairsInverted(Block block) {
        if (!P.use1_13) {
            MaterialData data = block.getState().getData();
            return data instanceof Stairs && ((Stairs)data).isInverted();
        }
        BlockData data = block.getBlockData();
        return data instanceof org.bukkit.block.data.type.Stairs && ((org.bukkit.block.data.type.Stairs)data).getHalf() == Bisected.Half.TOP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte getWoodType(Block wood) throws NoSuchFieldError, NoClassDefFoundError {
        TreeSpecies woodType;
        if (P.use1_13 || LegacyUtil.isWoodStairs(wood.getType())) {
            String material = wood.getType().name();
            if (material.startsWith("OAK")) {
                woodType = TreeSpecies.GENERIC;
            } else if (material.startsWith("SPRUCE")) {
                woodType = TreeSpecies.REDWOOD;
            } else if (material.startsWith("BIRCH")) {
                woodType = TreeSpecies.BIRCH;
            } else if (material.startsWith("JUNGLE")) {
                woodType = TreeSpecies.JUNGLE;
            } else if (material.startsWith("ACACIA")) {
                woodType = TreeSpecies.ACACIA;
            } else {
                if (!material.startsWith("DARK_OAK")) return 0;
                woodType = TreeSpecies.DARK_OAK;
            }
        } else {
            MaterialData data = wood.getState().getData();
            if (data instanceof Tree) {
                woodType = ((Tree)data).getSpecies();
            } else {
                if (!(data instanceof Wood)) return 0;
                woodType = ((Wood)data).getSpecies();
            }
        }
        switch (woodType) {
            case GENERIC: {
                return 2;
            }
            case REDWOOD: {
                return 4;
            }
            case BIRCH: {
                return 1;
            }
            case JUNGLE: {
                return 3;
            }
            case ACACIA: {
                return 5;
            }
            case DARK_OAK: {
                return 6;
            }
        }
        return 0;
    }

    public static byte getFillLevel(Block block) {
        if (block.getType() != Material.CAULDRON) {
            return 0;
        }
        if (P.use1_13) {
            Levelled cauldron = (Levelled)block.getBlockData();
            if (cauldron.getLevel() == 0) {
                return 0;
            }
            if (cauldron.getLevel() == cauldron.getMaximumLevel()) {
                return 2;
            }
            return 1;
        }
        Cauldron cauldron = (Cauldron)block.getState().getData();
        if (cauldron.isEmpty()) {
            return 0;
        }
        if (cauldron.isFull()) {
            return 2;
        }
        return 1;
    }

    public static Material getMaterial(int id) {
        try {
            return GET_MATERIAL != null ? (Material)GET_MATERIAL.invoke(null, id) : null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public static int getBlockTypeIdAt(Location location) {
        try {
            return GET_BLOCK_TYPE_ID_AT != null ? (Integer)GET_BLOCK_TYPE_ID_AT.invoke((Object)location.getWorld(), location) : 0;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return 0;
        }
    }

    public static void setData(Block block, byte data) {
        try {
            SET_DATA.invoke((Object)block, data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    static {
        try {
            GET_MATERIAL = Material.class.getDeclaredMethod("getMaterial", Integer.TYPE);
            GET_BLOCK_TYPE_ID_AT = World.class.getDeclaredMethod("getBlockTypeIdAt", Location.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        try {
            SET_DATA = Class.forName(Bukkit.getServer().getClass().getPackage().getName() + ".block.CraftBlock").getDeclaredMethod("setData", Byte.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        ArrayList<Material> planks = new ArrayList<Material>(6);
        for (Material m : Material.values()) {
            if (!m.name().endsWith("PLANKS")) continue;
            planks.add(m);
        }
        PLANKS = planks;
        ArrayList<Material> fences = new ArrayList<Material>(7);
        for (Material m : Material.values()) {
            if (!m.name().endsWith("FENCE")) continue;
            fences.add(m);
        }
        FENCES = fences;
        MAGMA = LegacyUtil.get("MAGMA_BLOCK", "MAGMA");
        CLOCK = LegacyUtil.get("CLOCK", "WATCH");
        OAK_STAIRS = LegacyUtil.get("OAK_STAIRS", "WOOD_STAIRS");
        SPRUCE_STAIRS = LegacyUtil.get("SPRUCE_STAIRS", "SPRUCE_WOOD_STAIRS");
        BIRCH_STAIRS = LegacyUtil.get("BIRCH_STAIRS", "BIRCH_WOOD_STAIRS");
        JUNGLE_STAIRS = LegacyUtil.get("JUNGLE_STAIRS", "JUNGLE_WOOD_STAIRS");
        ACACIA_STAIRS = LegacyUtil.get("ACACIA_STAIRS");
        DARK_OAK_STAIRS = LegacyUtil.get("DARK_OAK_STAIRS");
        STATIONARY_LAVA = LegacyUtil.get("STATIONARY_LAVA");
        SIGN_POST = LegacyUtil.get("SIGN_POST");
        WOOD = LegacyUtil.get("WOOD");
    }
}

